/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.AddressQueueStatus;

public class AddressStatusEncoding
implements EncodingSupport {
    private AddressQueueStatus status;
    private long addressId;
    private long id;

    public AddressStatusEncoding(long addressId, AddressQueueStatus status) {
        this.status = status;
        this.addressId = addressId;
    }

    public AddressStatusEncoding() {
    }

    public AddressQueueStatus getStatus() {
        return this.status;
    }

    public void setStatus(AddressQueueStatus status) {
        this.status = status;
    }

    public long getAddressId() {
        return this.addressId;
    }

    public void setAddressId(long addressId) {
        this.addressId = addressId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getEncodeSize() {
        return 10;
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeLong(this.addressId);
        buffer.writeShort(this.status.id);
    }

    public void decode(ActiveMQBuffer buffer) {
        this.addressId = buffer.readLong();
        short shortStatus = buffer.readShort();
        this.status = AddressQueueStatus.fromID(shortStatus);
    }

    public String toString() {
        return "AddressStatusEncoding{status=" + (Object)((Object)this.status) + ", id=" + this.addressId + '}';
    }
}

