/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.security.PublicKey;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.handlers.saml2.AbstractSignatureHandler;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.w3c.dom.Document;

public class SAML2SignatureValidationHandler
extends AbstractSignatureHandler {
    private SAML2Signature saml2Signature = new SAML2Signature();

    @Override
    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        this.validateSender(request, response);
    }

    @Override
    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        this.validateSender(request, response);
    }

    private void validateSender(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!this.isSupportsSignature(request)) {
            return;
        }
        Map<String, Object> requestOptions = request.getOptions();
        PicketLinkAuditHelper auditHelper = (PicketLinkAuditHelper)requestOptions.get("org.picketlink.federation.saml.AUDIT_HELPER");
        Boolean ignoreSignatures = (Boolean)requestOptions.get("IGNORE_SIGNATURES");
        if (ignoreSignatures == null) {
            ignoreSignatures = Boolean.FALSE;
        }
        if (ignoreSignatures == Boolean.TRUE) {
            return;
        }
        Document signedDocument = request.getRequestDocument();
        if (logger.isTraceEnabled()) {
            logger.trace("Going to validate signature for: " + DocumentUtil.asString((Document)signedDocument));
        }
        PublicKey publicKey = (PublicKey)request.getOptions().get("SENDER_PUBLIC_KEY");
        try {
            HTTPContext httpContext = (HTTPContext)request.getContext();
            logger.trace("HTTP method for validating response: " + httpContext.getRequest().getMethod());
            boolean isValid = this.isPostBinding(httpContext) ? this.verifyPostBindingSignature(signedDocument, publicKey) : this.verifyRedirectBindingSignature(httpContext, publicKey);
            if (!isValid) {
                if (auditHelper != null) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setWhoIsAuditing((String)requestOptions.get("CONTEXT_PATH"));
                    auditEvent.setType(PicketLinkAuditEventType.ERROR_SIG_VALIDATION);
                    auditHelper.audit(auditEvent);
                }
                throw this.constructSignatureException();
            }
        }
        catch (ProcessingException pe) {
            if (auditHelper != null) {
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setWhoIsAuditing((String)requestOptions.get("CONTEXT_PATH"));
                auditEvent.setType(PicketLinkAuditEventType.ERROR_SIG_VALIDATION);
                auditHelper.audit(auditEvent);
            }
            response.setError(100, "Signature Validation Failed");
            throw pe;
        }
    }

    private boolean verifyPostBindingSignature(Document signedDocument, PublicKey publicKey) throws ProcessingException {
        try {
            return this.saml2Signature.validate(signedDocument, publicKey);
        }
        catch (Exception e) {
            logger.samlHandlerErrorValidatingSignature((Throwable)e);
            throw logger.samlHandlerInvalidSignatureError();
        }
    }

    private boolean verifyRedirectBindingSignature(HTTPContext httpContext, PublicKey publicKey) throws ProcessingException {
        try {
            String queryString = httpContext.getRequest().getQueryString();
            byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL(queryString);
            if (sigValue == null) {
                throw logger.samlHandlerSignatureNotPresentError();
            }
            return RedirectBindingSignatureUtil.validateSignature(queryString, publicKey, sigValue);
        }
        catch (Exception e) {
            throw logger.samlHandlerSignatureValidationError((Throwable)e);
        }
    }

    private ProcessingException constructSignatureException() {
        return new ProcessingException((Throwable)logger.samlHandlerSignatureValidationFailed());
    }

    private boolean isPostBinding(HTTPContext httpContext) {
        HttpServletRequest httpServletRequest = httpContext.getRequest();
        Map parameterMap = httpServletRequest.getParameterMap();
        return !parameterMap.containsKey("Signature");
    }
}

