/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.activemq.artemis.wildfly.integration.recovery;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQRegistry;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.jboss.activemq.artemis.wildfly.integration.recovery.WildFlyActiveMQRecoveryRegistry;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;

public class WildFlyActiveMQRegistry
implements ActiveMQRegistry {
    private final AtomicBoolean started = new AtomicBoolean(false);
    private XAResourceRecoveryRegistry tmRegistry;

    public XAResourceRecoveryRegistry getTMRegistry() {
        return this.tmRegistry;
    }

    public void setTmRegistry(XAResourceRecoveryRegistry tmRegistry) {
        this.tmRegistry = tmRegistry;
    }

    public void register(XARecoveryConfig resourceConfig) {
        this.init();
        WildFlyActiveMQRecoveryRegistry.getInstance().register(resourceConfig);
    }

    public void unRegister(XARecoveryConfig resourceConfig) {
        this.init();
        WildFlyActiveMQRecoveryRegistry.getInstance().unRegister(resourceConfig);
    }

    public void stop() {
        if (this.started.compareAndSet(true, false) && this.getTMRegistry() != null) {
            this.getTMRegistry().removeXAResourceRecovery((XAResourceRecovery)WildFlyActiveMQRecoveryRegistry.getInstance());
            WildFlyActiveMQRecoveryRegistry.getInstance().stop();
        }
    }

    public void init() {
        if (this.started.compareAndSet(false, true) && this.getTMRegistry() != null) {
            this.getTMRegistry().addXAResourceRecovery((XAResourceRecovery)WildFlyActiveMQRecoveryRegistry.getInstance());
        }
    }
}

