/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.api.OpenApiConstants;
import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.responses.APIResponsesImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class ModelUtil {
    private ModelUtil() {
    }

    public static void addTag(OpenAPI openApi, Tag tag) {
        List tags = openApi.getTags();
        if (tags == null || tags.isEmpty()) {
            openApi.addTag(tag);
            return;
        }
        Tag current = tags.stream().filter(t -> t.getName().equals(tag.getName())).findFirst().orElse(null);
        int currentIndex = tags.indexOf(current);
        if (current != null) {
            Tag replacement = MergeUtil.mergeObjects(current, tag);
            tags.set(currentIndex, replacement);
        } else {
            openApi.addTag(tag);
        }
    }

    public static Components components(OpenAPI openApi) {
        if (openApi.getComponents() == null) {
            openApi.setComponents((Components)new ComponentsImpl());
        }
        return openApi.getComponents();
    }

    public static Paths paths(OpenAPIImpl openApi) {
        if (openApi.getPaths() == null) {
            openApi.setPaths(new PathsImpl());
        }
        return openApi.getPaths();
    }

    public static APIResponses responses(Operation operation) {
        if (operation.getResponses() == null) {
            operation.setResponses((APIResponses)new APIResponsesImpl());
        }
        return operation.getResponses();
    }

    public static boolean parameterHasSchema(Parameter parameter) {
        if (parameter.getSchema() != null) {
            return true;
        }
        if (parameter.getContent() != null && !parameter.getContent().isEmpty()) {
            Collection mediaTypes = parameter.getContent().values();
            for (MediaType mediaType : mediaTypes) {
                if (mediaType.getSchema() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Schema> getParameterSchemas(Parameter parameter) {
        if (parameter.getSchema() != null) {
            return Arrays.asList(parameter.getSchema());
        }
        if (parameter.getContent() != null && !parameter.getContent().isEmpty()) {
            Collection mediaTypes = parameter.getContent().values();
            ArrayList<Schema> schemas = new ArrayList<Schema>(mediaTypes.size());
            for (MediaType mediaType : mediaTypes) {
                if (mediaType.getSchema() == null) continue;
                schemas.add(mediaType.getSchema());
            }
        }
        return Collections.emptyList();
    }

    public static void setParameterSchema(Parameter parameter, Schema schema) {
        if (schema == null) {
            return;
        }
        if (parameter.getContent() == null) {
            parameter.schema(schema);
            return;
        }
        Content content = parameter.getContent();
        if (content.isEmpty()) {
            String[] defMediaTypes;
            for (String mediaTypeName : defMediaTypes = OpenApiConstants.DEFAULT_MEDIA_TYPES.get()) {
                MediaTypeImpl mediaType = new MediaTypeImpl();
                mediaType.setSchema(schema);
                content.addMediaType(mediaTypeName, (MediaType)mediaType);
            }
            return;
        }
        for (String mediaTypeName : content.keySet()) {
            MediaType mediaType = content.getMediaType(mediaTypeName);
            mediaType.setSchema(schema);
        }
    }

    public static boolean requestBodyHasSchema(RequestBody requestBody) {
        if (requestBody.getContent() != null && !requestBody.getContent().isEmpty()) {
            Collection mediaTypes = requestBody.getContent().values();
            for (MediaType mediaType : mediaTypes) {
                if (mediaType.getSchema() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static void setRequestBodySchema(RequestBody requestBody, Schema schema, String[] mediaTypes) {
        Content content = requestBody.getContent();
        if (content == null) {
            content = new ContentImpl();
            requestBody.setContent(content);
        }
        if (content.isEmpty()) {
            String[] requestBodyTypes = mediaTypes != null && mediaTypes.length > 0 ? mediaTypes : OpenApiConstants.DEFAULT_MEDIA_TYPES.get();
            for (String mediaTypeName : requestBodyTypes) {
                MediaTypeImpl mediaType = new MediaTypeImpl();
                mediaType.setSchema(schema);
                content.addMediaType(mediaTypeName, (MediaType)mediaType);
            }
            return;
        }
        for (String mediaTypeName : content.keySet()) {
            MediaType mediaType = content.getMediaType(mediaTypeName);
            mediaType.setSchema(schema);
        }
    }

    public static boolean operationHasParameter(Operation operation, String name) {
        List parameters = operation.getParameters();
        if (parameters == null) {
            return false;
        }
        for (Parameter parameter : parameters) {
            if (parameter.getName() != null && parameter.getName().equals(name)) {
                return true;
            }
            if (parameter.getRef() == null || !ModelUtil.nameFromRef(parameter.getRef()).equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String nameFromRef(String ref) {
        String[] split = ref.split("/");
        return split[split.length - 1];
    }
}

