/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataTransientCacheEntry;
import org.infinispan.metadata.Metadata;

public class MetadataTransientCacheValue
extends ImmortalCacheValue
implements MetadataAware {
    Metadata metadata;
    long lastUsed;

    public MetadataTransientCacheValue(Object value, Metadata metadata, long lastUsed) {
        super(value);
        this.metadata = metadata;
        this.lastUsed = lastUsed;
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new MetadataTransientCacheEntry(key, this.value, this.metadata, this.lastUsed);
    }

    @Override
    public long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public final boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransient(this.metadata.maxIdle(), this.lastUsed, now);
    }

    @Override
    public final boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    @Override
    public boolean canExpire() {
        return true;
    }

    @Override
    public boolean isMaxIdleExpirable() {
        return true;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public long getExpiryTime() {
        long maxIdle = this.metadata.maxIdle();
        return maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataTransientCacheValue> {
        public void writeObject(ObjectOutput output, MetadataTransientCacheValue tcv) throws IOException {
            output.writeObject(tcv.value);
            output.writeObject(tcv.metadata);
            UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)tcv.lastUsed);
        }

        public MetadataTransientCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
            return new MetadataTransientCacheValue(v, metadata, lastUsed);
        }

        public Integer getId() {
            return 44;
        }

        public Set<Class<? extends MetadataTransientCacheValue>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{MetadataTransientCacheValue.class});
        }
    }
}

