/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.List;
import org.wildfly.clustering.ee.infinispan.scheduler.Scheduler;
import org.wildfly.clustering.ejb.infinispan.ImmutableBeanEntry;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;

public class CompositeScheduler<I>
implements Scheduler<I, ImmutableBeanEntry<I>> {
    private final List<Scheduler<I, ImmutableBeanEntry<I>>> schedulers;

    public CompositeScheduler(List<Scheduler<I, ImmutableBeanEntry<I>>> schedulers) {
        this.schedulers = schedulers;
    }

    public void schedule(I id) {
        for (Scheduler<I, ImmutableBeanEntry<I>> scheduler : this.schedulers) {
            scheduler.schedule(id);
        }
    }

    public void schedule(I id, ImmutableBeanEntry<I> entry) {
        for (Scheduler<I, ImmutableBeanEntry<I>> scheduler : this.schedulers) {
            scheduler.schedule(id, entry);
        }
    }

    public void cancel(I id) {
        for (Scheduler<I, ImmutableBeanEntry<I>> scheduler : this.schedulers) {
            scheduler.cancel(id);
        }
    }

    public void cancel(Locality locality) {
        for (Scheduler<I, ImmutableBeanEntry<I>> scheduler : this.schedulers) {
            scheduler.cancel(locality);
        }
    }

    public void close() {
        for (Scheduler<I, ImmutableBeanEntry<I>> scheduler : this.schedulers) {
            scheduler.close();
        }
    }
}

