/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.marshalling.jboss.ByteBufferOutputStream;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.server.dispatcher.CommandMarshaller;

public class CommandDispatcherMarshaller<C>
implements CommandMarshaller<C> {
    private final MarshallingContext context;
    private final Object id;

    public CommandDispatcherMarshaller(MarshallingContext context, Object id) {
        this.context = context;
        this.id = id;
    }

    @Override
    public <R> ByteBuffer marshal(Command<R, ? super C> command) throws IOException {
        int version = this.context.getCurrentVersion();
        ByteBufferOutputStream buffer = new ByteBufferOutputStream();
        try (DataOutputStream output = new DataOutputStream((OutputStream)buffer);){
            IndexSerializer.VARIABLE.writeInt((DataOutput)output, version);
            try (Marshaller marshaller = this.context.createMarshaller(version);){
                marshaller.start(Marshalling.createByteOutput((OutputStream)output));
                marshaller.writeObject(this.id);
                marshaller.writeObject(command);
                marshaller.flush();
            }
            ByteBuffer byteBuffer = buffer.getBuffer();
            return byteBuffer;
        }
    }
}

