/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Map;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.server.registry.FunctionalRegistryFactoryServiceConfigurator;
import org.wildfly.clustering.server.registry.LocalRegistry;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class LocalRegistryFactoryServiceConfigurator<K, V>
extends FunctionalRegistryFactoryServiceConfigurator<K, V> {
    private final String containerName;
    private final String cacheName;
    private volatile SupplierDependency<Group> group;

    public LocalRegistryFactoryServiceConfigurator(ServiceName name, String containerName, String cacheName) {
        super(name);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public Registry<K, V> apply(Map.Entry<K, V> entry, Runnable closeTask) {
        return new LocalRegistry<K, V>((Group)this.group.get(), entry, closeTask);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.group = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.cacheName));
        return this;
    }

    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return this.group.register(builder);
    }
}

