/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.standard.std40.UAX29URLEmailTokenizer40;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.Version;

public class UAX29URLEmailTokenizerFactory
extends TokenizerFactory {
    private final int maxTokenLength;

    public UAX29URLEmailTokenizerFactory(Map<String, String> args) {
        super(args);
        this.maxTokenLength = this.getInt(args, "maxTokenLength", 255);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        if (this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_7_0)) {
            UAX29URLEmailTokenizer tokenizer = new UAX29URLEmailTokenizer(factory);
            tokenizer.setMaxTokenLength(this.maxTokenLength);
            return tokenizer;
        }
        UAX29URLEmailTokenizer40 tokenizer40 = new UAX29URLEmailTokenizer40(factory);
        tokenizer40.setMaxTokenLength(this.maxTokenLength);
        return tokenizer40;
    }
}

