/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.RuntimeResourceDefinition;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;

class RuntimeMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final RuntimeMXBeanAttributeHandler INSTANCE = new RuntimeMXBeanAttributeHandler();

    private RuntimeMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        try {
            if (!(PlatformMBeanConstants.OBJECT_NAME.getName().equals(name) || RuntimeResourceDefinition.RUNTIME_READ_ATTRIBUTES.contains(name) || RuntimeResourceDefinition.RUNTIME_METRICS.contains(name))) {
                throw RuntimeMXBeanAttributeHandler.unknownAttribute(operation);
            }
            RuntimeMXBeanAttributeHandler.storeResult(name, context.getResult());
        }
        catch (SecurityException | UnsupportedOperationException e) {
            throw new OperationFailedException(e.toString());
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw RuntimeMXBeanAttributeHandler.unknownAttribute(operation);
    }

    static void storeResult(String name, ModelNode store) {
        if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(name)) {
            store.set("java.lang:type=Runtime");
        } else if ("name".equals(name)) {
            String runtimeName;
            try {
                runtimeName = ManagementFactory.getRuntimeMXBean().getName();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String localAddr;
                try {
                    localAddr = InetAddress.getByName(null).toString();
                }
                catch (UnknownHostException uhe) {
                    localAddr = "localhost";
                }
                runtimeName = new Random().nextInt() + "@" + localAddr;
            }
            store.set(runtimeName);
        } else if ("vm-name".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getVmName());
        } else if ("vm-vendor".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getVmVendor());
        } else if ("vm-version".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getVmVersion());
        } else if ("spec-name".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getSpecName());
        } else if ("spec-vendor".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getSpecVendor());
        } else if ("spec-version".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getSpecVersion());
        } else if ("management-spec-version".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getManagementSpecVersion());
        } else if ("class-path".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getClassPath());
        } else if ("library-path".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getLibraryPath());
        } else if ("boot-class-path-supported".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().isBootClassPathSupported());
        } else if ("boot-class-path".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getBootClassPath());
        } else if ("input-arguments".equals(name)) {
            store.setEmptyList();
            for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                store.add(arg);
            }
        } else if ("uptime".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getUptime());
        } else if ("start-time".equals(name)) {
            store.set(ManagementFactory.getRuntimeMXBean().getStartTime());
        } else if ("system-properties".equals(name)) {
            store.setEmptyObject();
            TreeMap<String, String> sorted = new TreeMap<String, String>(ManagementFactory.getRuntimeMXBean().getSystemProperties());
            for (Map.Entry<String, String> prop : sorted.entrySet()) {
                ModelNode propNode = store.get(prop.getKey());
                if (prop.getValue() == null) continue;
                propNode.set(prop.getValue());
            }
        } else if (RuntimeResourceDefinition.RUNTIME_READ_ATTRIBUTES.contains(name) || RuntimeResourceDefinition.RUNTIME_METRICS.contains(name)) {
            throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(name);
        }
    }
}

