/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.util.New;

public abstract class CommandWithColumns
extends SchemaCommand {
    private ArrayList<DefineCommand> constraintCommands;
    private IndexColumn[] pkColumns;

    protected CommandWithColumns(Session session, Schema schema) {
        super(session, schema);
    }

    public abstract void addColumn(Column var1);

    public void addConstraintCommand(DefineCommand defineCommand) {
        if (defineCommand instanceof CreateIndex) {
            this.getConstraintCommands().add(defineCommand);
        } else {
            AlterTableAddConstraint alterTableAddConstraint = (AlterTableAddConstraint)defineCommand;
            boolean bl = alterTableAddConstraint.getType() == 6 ? this.setPrimaryKeyColumns(alterTableAddConstraint.getIndexColumns()) : false;
            if (!bl) {
                this.getConstraintCommands().add(defineCommand);
            }
        }
    }

    protected void changePrimaryKeysToNotNull(ArrayList<Column> arrayList) {
        if (this.pkColumns != null) {
            for (Column column : arrayList) {
                for (IndexColumn indexColumn : this.pkColumns) {
                    if (!column.getName().equals(indexColumn.columnName)) continue;
                    column.setNullable(false);
                }
            }
        }
    }

    protected void createConstraints() {
        if (this.constraintCommands != null) {
            for (DefineCommand defineCommand : this.constraintCommands) {
                defineCommand.setTransactional(this.transactional);
                defineCommand.update();
            }
        }
    }

    protected ArrayList<Sequence> generateSequences(ArrayList<Column> arrayList, boolean bl) {
        ArrayList<Sequence> arrayList2 = New.arrayList();
        if (arrayList != null) {
            for (Column column : arrayList) {
                Sequence sequence;
                if (column.isAutoIncrement()) {
                    int n = this.getObjectId();
                    column.convertAutoIncrementToSequence(this.session, this.getSchema(), n, bl);
                    if (!"''".equals(this.session.getDatabase().getCluster())) {
                        throw DbException.getUnsupportedException("CLUSTERING && auto-increment columns");
                    }
                }
                if ((sequence = column.getSequence()) == null) continue;
                arrayList2.add(sequence);
            }
        }
        return arrayList2;
    }

    private ArrayList<DefineCommand> getConstraintCommands() {
        if (this.constraintCommands == null) {
            this.constraintCommands = New.arrayList();
        }
        return this.constraintCommands;
    }

    private boolean setPrimaryKeyColumns(IndexColumn[] indexColumnArray) {
        if (this.pkColumns != null) {
            int n = indexColumnArray.length;
            if (n != this.pkColumns.length) {
                throw DbException.get(90017);
            }
            for (int i = 0; i < n; ++i) {
                if (indexColumnArray[i].columnName.equals(this.pkColumns[i].columnName)) continue;
                throw DbException.get(90017);
            }
            return true;
        }
        this.pkColumns = indexColumnArray;
        return false;
    }
}

