/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.ClassField;
import org.wildfly.clustering.marshalling.protostream.ClassResolver;
import org.wildfly.clustering.marshalling.protostream.ClassResolverField;
import org.wildfly.clustering.marshalling.protostream.Field;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class ClassMarshaller
implements ProtoStreamMarshaller<Class<?>> {
    private final Field<Class<?>> field;
    private final Field<Class<?>>[] fields = ClassField.values();

    public ClassMarshaller(ClassResolver resolver) {
        this.field = new ClassResolverField(resolver, this.fields.length);
    }

    public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        int tag = reader.readTag();
        if (tag == 0) {
            return null;
        }
        int index = WireFormat.getTagFieldNumber((int)tag);
        Field<Class<?>> field = index == this.field.getIndex() ? this.field : this.fields[index];
        return (Class)field.readFrom(context, reader);
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> targetClass) throws IOException {
        Field<Class<?>> field = this.getField(context, targetClass);
        writer.writeTag(field.getIndex(), 0);
        field.writeTo(context, writer, targetClass);
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, Class<?> targetClass) {
        Field<Class<?>> field = this.getField(context, targetClass);
        OptionalInt size = field.size(context, targetClass);
        return size.isPresent() ? OptionalInt.of(size.getAsInt() + Predictable.unsignedIntSize(field.getIndex() << 3 | 0)) : OptionalInt.empty();
    }

    Field<Class<?>> getField(ImmutableSerializationContext context, Class<?> targetClass) {
        if (targetClass == Object.class) {
            return ClassField.OBJECT;
        }
        AnyField classField = AnyField.fromJavaType(targetClass);
        if (classField != null) {
            return ClassField.FIELD;
        }
        if (targetClass.isArray()) {
            return ClassField.ARRAY;
        }
        try {
            BaseMarshaller marshaller = context.getMarshaller(targetClass);
            return context.getDescriptorByName(marshaller.getTypeName()).getTypeId() != null ? ClassField.ID : ClassField.NAME;
        }
        catch (IllegalArgumentException e) {
            return this.field;
        }
    }

    public Class<? extends Class<?>> getJavaClass() {
        return this.field.getJavaClass();
    }
}

