/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.exception.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.impl.ErrorContextImpl;
import org.hibernate.search.indexes.spi.IndexManager;

public class ErrorContextBuilder {
    private Throwable th;
    private LuceneWork operationAtFault;
    private Iterable<LuceneWork> workToBeDone;
    private List<LuceneWork> failingOperations;
    private List<LuceneWork> operationsThatWorked;
    private IndexManager indexManager;

    public ErrorContextBuilder errorThatOccurred(Throwable th) {
        this.th = th;
        return this;
    }

    public ErrorContextBuilder operationAtFault(LuceneWork operationAtFault) {
        this.operationAtFault = operationAtFault;
        return this;
    }

    public ErrorContextBuilder addWorkThatFailed(LuceneWork failedWork) {
        this.getFailingOperations().add(failedWork);
        return this;
    }

    public ErrorContextBuilder addAllWorkThatFailed(List<LuceneWork> worksThatFailed) {
        this.getFailingOperations().addAll(worksThatFailed);
        return this;
    }

    public ErrorContextBuilder workCompleted(LuceneWork luceneWork) {
        this.getOperationsThatWorked().add(luceneWork);
        return this;
    }

    public ErrorContextBuilder indexManager(IndexManager indexName) {
        this.indexManager = indexName;
        return this;
    }

    public ErrorContextBuilder allWorkToBeDone(Iterable<LuceneWork> workOnWriter) {
        this.workToBeDone = workOnWriter;
        return this;
    }

    public ErrorContext createErrorContext() {
        ErrorContextImpl context = new ErrorContextImpl();
        context.setThrowable(this.th);
        if (this.operationAtFault != null) {
            context.setOperationAtFault(this.operationAtFault);
        } else if (this.workToBeDone != null) {
            ArrayList<LuceneWork> workLeft = new ArrayList<LuceneWork>();
            for (LuceneWork work : this.workToBeDone) {
                workLeft.add(work);
            }
            if (this.operationsThatWorked != null) {
                workLeft.removeAll(this.operationsThatWorked);
            }
            if (!workLeft.isEmpty()) {
                context.setOperationAtFault((LuceneWork)workLeft.remove(0));
                this.getFailingOperations().addAll(workLeft);
            }
        }
        context.setFailingOperations(this.getFailingOperations());
        context.setIndexManager(this.indexManager);
        return context;
    }

    private List<LuceneWork> getFailingOperations() {
        if (this.failingOperations == null) {
            this.failingOperations = new ArrayList<LuceneWork>();
        }
        return this.failingOperations;
    }

    private List<LuceneWork> getOperationsThatWorked() {
        if (this.operationsThatWorked == null) {
            this.operationsThatWorked = new LinkedList<LuceneWork>();
        }
        return this.operationsThatWorked;
    }
}

