/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jberet.job.model.Properties;

abstract class AbstractPropertiesBuilder<T> {
    final Map<String, String> nameValues = new LinkedHashMap<String, String>();

    AbstractPropertiesBuilder() {
    }

    public T property(String k, String v) {
        this.nameValues.put(k, v);
        return (T)this;
    }

    public T properties(java.util.Properties props) {
        if (props != null) {
            for (String k : props.stringPropertyNames()) {
                this.nameValues.put(k, props.getProperty(k));
            }
        }
        return (T)this;
    }

    public T properties(String[] ... pairsOfKeyValue) {
        for (String[] pair : pairsOfKeyValue) {
            this.nameValues.put(pair[0], pair.length > 1 ? pair[1] : null);
        }
        return (T)this;
    }

    Properties nameValuesToProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, String> e : this.nameValues.entrySet()) {
            properties.add(e.getKey(), e.getValue());
        }
        return properties;
    }
}

