/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.ReadStreamSubscriber;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.streams.WriteStream;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.http.HttpClientResponse;
import io.vertx.mutiny.core.http.HttpConnection;
import io.vertx.mutiny.core.http.HttpFrame;
import io.vertx.mutiny.core.streams.ReadStream;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;

@MutinyGen(value=io.vertx.core.http.HttpClientRequest.class)
public class HttpClientRequest
implements io.vertx.mutiny.core.streams.WriteStream<Buffer> {
    public static final TypeArg<HttpClientRequest> __TYPE_ARG = new TypeArg(obj -> new HttpClientRequest((io.vertx.core.http.HttpClientRequest)obj), HttpClientRequest::getDelegate);
    private final io.vertx.core.http.HttpClientRequest delegate;
    private WriteStreamSubscriber<Buffer> subscriber;
    private MultiMap cached_0;
    private HttpConnection cached_1;

    public HttpClientRequest(io.vertx.core.http.HttpClientRequest delegate) {
        this.delegate = delegate;
    }

    public HttpClientRequest(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClientRequest)delegate;
    }

    HttpClientRequest() {
        this.delegate = null;
    }

    public io.vertx.core.http.HttpClientRequest getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientRequest that = (HttpClientRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber((WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Uni<Void> write(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.write((Object)data.getDelegate(), handler));
    }

    @Override
    public Void writeAndAwait(Buffer data) {
        return (Void)this.write(data).await().indefinitely();
    }

    @Override
    public void writeAndForget(Buffer data) {
        this.write(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Fluent
    private HttpClientRequest __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public HttpClientRequest exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Fluent
    private HttpClientRequest __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public HttpClientRequest drainHandler(Runnable handler) {
        return this.__drainHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @Fluent
    public HttpClientRequest setHost(String host) {
        this.delegate.setHost(host);
        return this;
    }

    public String getHost() {
        String ret = this.delegate.getHost();
        return ret;
    }

    @Fluent
    public HttpClientRequest setPort(int port) {
        this.delegate.setPort(port);
        return this;
    }

    public int getPort() {
        int ret = this.delegate.getPort();
        return ret;
    }

    @Fluent
    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.delegate.setFollowRedirects(followRedirects);
        return this;
    }

    @Fluent
    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        this.delegate.setMaxRedirects(maxRedirects);
        return this;
    }

    @Fluent
    public HttpClientRequest setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public HttpMethod getMethod() {
        HttpMethod ret = this.delegate.getMethod();
        return ret;
    }

    @Fluent
    public HttpClientRequest setMethod(HttpMethod method) {
        this.delegate.setMethod(method);
        return this;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public String getURI() {
        String ret = this.delegate.getURI();
        return ret;
    }

    @Fluent
    public HttpClientRequest setURI(String uri) {
        this.delegate.setURI(uri);
        return this;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    @Fluent
    public HttpClientRequest putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    @Override
    public Uni<Void> write(String chunk) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(chunk, handler));
    }

    @Override
    public Void writeAndAwait(String chunk) {
        return (Void)this.write(chunk).await().indefinitely();
    }

    @Override
    public void writeAndForget(String chunk) {
        this.write(chunk).subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> write(String chunk, String enc) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(chunk, enc, handler));
    }

    public Void writeAndAwait(String chunk, String enc) {
        return (Void)this.write(chunk, enc).await().indefinitely();
    }

    public void writeAndForget(String chunk, String enc) {
        this.write(chunk, enc).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private HttpClientRequest __continueHandler(Handler<Void> handler) {
        this.delegate.continueHandler(handler);
        return this;
    }

    public HttpClientRequest continueHandler(Runnable handler) {
        return this.__continueHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    public Uni<Void> sendHead() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.sendHead(completionHandler));
    }

    public Void sendHeadAndAwait() {
        return (Void)this.sendHead().await().indefinitely();
    }

    @Fluent
    public HttpClientRequest sendHeadAndForget() {
        this.sendHead().subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<HttpClientResponse> connect() {
        return AsyncResultUni.toUni(handler -> this.delegate.connect((Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public HttpClientResponse connectAndAwait() {
        return (HttpClientResponse)this.connect().await().indefinitely();
    }

    public void connectAndForget() {
        this.connect().subscribe().with(UniHelper.NOOP);
    }

    public Uni<HttpClientResponse> response() {
        return AsyncResultUni.toUni(handler -> this.delegate.response((Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public HttpClientResponse responseAndAwait() {
        return (HttpClientResponse)this.response().await().indefinitely();
    }

    @Fluent
    public HttpClientRequest responseAndForget() {
        this.response().subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<HttpClientResponse> send() {
        return AsyncResultUni.toUni(handler -> this.delegate.send((Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public HttpClientResponse sendAndAwait() {
        return (HttpClientResponse)this.send().await().indefinitely();
    }

    public void sendAndForget() {
        this.send().subscribe().with(UniHelper.NOOP);
    }

    public Uni<HttpClientResponse> send(String body) {
        return AsyncResultUni.toUni(handler -> this.delegate.send(body, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public HttpClientResponse sendAndAwait(String body) {
        return (HttpClientResponse)this.send(body).await().indefinitely();
    }

    public void sendAndForget(String body) {
        this.send(body).subscribe().with(UniHelper.NOOP);
    }

    public Uni<HttpClientResponse> send(Buffer body) {
        return AsyncResultUni.toUni(handler -> this.delegate.send(body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public HttpClientResponse sendAndAwait(Buffer body) {
        return (HttpClientResponse)this.send(body).await().indefinitely();
    }

    public void sendAndForget(Buffer body) {
        this.send(body).subscribe().with(UniHelper.NOOP);
    }

    public Uni<HttpClientResponse> send(ReadStream<Buffer> body) {
        return AsyncResultUni.toUni(handler -> this.delegate.send(body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public HttpClientResponse sendAndAwait(ReadStream<Buffer> body) {
        return (HttpClientResponse)this.send(body).await().indefinitely();
    }

    public void sendAndForget(ReadStream<Buffer> body) {
        this.send(body).subscribe().with(UniHelper.NOOP);
    }

    public Uni<HttpClientResponse> send(Publisher<Buffer> body) {
        return AsyncResultUni.toUni(handler -> this.delegate.send(ReadStreamSubscriber.asReadStream((Publisher)body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public HttpClientResponse sendAndAwait(Publisher<Buffer> body) {
        return (HttpClientResponse)this.send(body).await().indefinitely();
    }

    public void sendAndForget(Publisher<Buffer> body) {
        this.send(body).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public Uni<Void> end(String chunk) {
        return AsyncResultUni.toUni(handler -> this.delegate.end(chunk, handler));
    }

    @Override
    public Void endAndAwait(String chunk) {
        return (Void)this.end(chunk).await().indefinitely();
    }

    @Override
    public void endAndForget(String chunk) {
        this.end(chunk).subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> end(String chunk, String enc) {
        return AsyncResultUni.toUni(handler -> this.delegate.end(chunk, enc, handler));
    }

    public Void endAndAwait(String chunk, String enc) {
        return (Void)this.end(chunk, enc).await().indefinitely();
    }

    public void endAndForget(String chunk, String enc) {
        this.end(chunk, enc).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public Uni<Void> end(Buffer chunk) {
        return AsyncResultUni.toUni(handler -> this.delegate.end(chunk.getDelegate(), handler));
    }

    @Override
    public Void endAndAwait(Buffer chunk) {
        return (Void)this.end(chunk).await().indefinitely();
    }

    @Override
    public void endAndForget(Buffer chunk) {
        this.end(chunk).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.delegate.end(handler));
    }

    @Override
    public Void endAndAwait() {
        return (Void)this.end().await().indefinitely();
    }

    @Override
    public void endAndForget() {
        this.end().subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    public HttpClientRequest setTimeout(long timeoutMs) {
        this.delegate.setTimeout(timeoutMs);
        return this;
    }

    @Fluent
    private HttpClientRequest __pushHandler(final Handler<HttpClientRequest> handler) {
        this.delegate.pushHandler((Handler)new Handler<io.vertx.core.http.HttpClientRequest>(){

            public void handle(io.vertx.core.http.HttpClientRequest event) {
                handler.handle((Object)HttpClientRequest.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientRequest pushHandler(Consumer<HttpClientRequest> handler) {
        return this.__pushHandler(handler != null ? handler::accept : null);
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    public boolean reset(long code, Throwable cause) {
        boolean ret = this.delegate.reset(code, cause);
        return ret;
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    @Fluent
    public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, payload.getDelegate());
        return this;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    @Fluent
    public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    @Fluent
    public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public StreamPriority getStreamPriority() {
        StreamPriority ret = this.delegate.getStreamPriority();
        return ret;
    }

    @Fluent
    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    @Fluent
    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    @Fluent
    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public static HttpClientRequest newInstance(io.vertx.core.http.HttpClientRequest arg) {
        return arg != null ? new HttpClientRequest(arg) : null;
    }
}

