/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;

public class ActiveMQExceptionMessage_V2
extends ActiveMQExceptionMessage {
    private long correlationID;

    public ActiveMQExceptionMessage_V2(long correlationID, ActiveMQException exception) {
        super(exception);
        this.correlationID = correlationID;
    }

    public ActiveMQExceptionMessage_V2() {
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeLong(this.correlationID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        if (buffer.readableBytes() >= 8) {
            this.correlationID = buffer.readLong();
        }
    }

    @Override
    public final boolean isResponseAsync() {
        return true;
    }

    @Override
    public long getCorrelationID() {
        return this.correlationID;
    }

    @Override
    public String toString() {
        return this.getParentString() + ", exception= " + this.exception + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.correlationID ^ this.correlationID >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ActiveMQExceptionMessage_V2)) {
            return false;
        }
        ActiveMQExceptionMessage_V2 other = (ActiveMQExceptionMessage_V2)obj;
        return this.correlationID == other.correlationID;
    }
}

