/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.UnaryCapabilityNameResolver;
import org.jboss.as.clustering.jgroups.subsystem.StackOperation;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.service.CountDownLifecycleListener;
import org.wildfly.clustering.service.FunctionalService;

public class StackOperationHandler
extends AbstractRuntimeOnlyHandler
implements Registration<ManagementResourceRegistration> {
    private final Map<String, Operation<ChannelFactory>> operations = new HashMap<String, Operation<ChannelFactory>>();

    public StackOperationHandler() {
        for (Operation operation : EnumSet.allOf(StackOperation.class)) {
            this.operations.put(operation.getName(), (Operation<ChannelFactory>)operation);
        }
    }

    protected synchronized void executeRuntimeStep(final OperationContext context, final ModelNode op) throws OperationFailedException {
        String name = Operations.getName((ModelNode)op);
        final Operation<ChannelFactory> operation = this.operations.get(name);
        ServiceName serviceName = JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, UnaryCapabilityNameResolver.DEFAULT);
        Function<ChannelFactory, ModelNode> operationFunction = new Function<ChannelFactory, ModelNode>(){

            @Override
            public ModelNode apply(ChannelFactory factory) {
                try {
                    return operation.execute((ExpressionResolver)context, op, (Object)factory);
                }
                catch (OperationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName.append(new String[]{((Object)((Object)this)).getClass().getSimpleName()}));
        Supplier factory = builder.requires(serviceName);
        Reference reference = new Reference();
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch removeLatch = new CountDownLatch(1);
        ServiceController controller = builder.addListener((LifecycleListener)new CountDownLifecycleListener(startLatch, EnumSet.of(LifecycleEvent.UP, LifecycleEvent.FAILED))).addListener((LifecycleListener)new CountDownLifecycleListener(removeLatch, EnumSet.of(LifecycleEvent.REMOVED))).setInstance((Service)new FunctionalService(reference, (Function)operationFunction, factory)).setInitialMode(ServiceController.Mode.ACTIVE).install();
        try {
            startLatch.await();
            ModelNode result = (ModelNode)reference.get();
            if (result != null) {
                context.getResult().set(result);
            } else {
                context.getFailureDescription().set(controller.getStartException().getLocalizedMessage());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException((Throwable)e);
        }
        finally {
            try {
                controller.setMode(ServiceController.Mode.REMOVE);
                removeLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }

    public void register(ManagementResourceRegistration registration) {
        for (Operation operation : EnumSet.allOf(StackOperation.class)) {
            registration.registerOperationHandler((OperationDefinition)operation.getDefinition(), (OperationStepHandler)this);
        }
    }

    static class Reference<T>
    implements Consumer<T>,
    Supplier<T> {
        private volatile T value;

        Reference() {
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void accept(T value) {
            this.value = value;
        }
    }
}

