/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.idm.resolver;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.picketlink.config.idm.resolver.BasicPropertyResolver;
import org.picketlink.config.idm.resolver.PropertyResolver;

public class PropertyResolverMapper {
    private static final PropertyResolverMapper INSTANCE = PropertyResolverMapper.initInstance();
    private final PropertyResolver<Object> DEFAULT_PRIMITIVE_RESOLVER = new BasicPropertyResolver.PropertyEditorDelegateResolver<Object>();
    private Map<Class<?>, PropertyResolver> propertyResolvers = new ConcurrentHashMap();

    public static PropertyResolverMapper getInstance() {
        return INSTANCE;
    }

    private static PropertyResolverMapper initInstance() {
        PropertyResolverMapper instance = new PropertyResolverMapper();
        instance.addPropertyResolver(String.class, new BasicPropertyResolver.StringResolver());
        instance.addPropertyResolver(Class.class, new BasicPropertyResolver.ClassResolver());
        return instance;
    }

    private PropertyResolverMapper() {
    }

    public <V> void addPropertyResolver(Class<V> clazz, PropertyResolver<V> propertyResolver) {
        this.propertyResolvers.put(clazz, propertyResolver);
    }

    public <V> V resolveProperty(Object configurationValue, Class<V> clazz) {
        PropertyResolver<Object> propertyResolver = this.propertyResolvers.get(clazz);
        if (propertyResolver == null) {
            propertyResolver = this.DEFAULT_PRIMITIVE_RESOLVER;
        }
        return (V)propertyResolver.resolveProperty(configurationValue, clazz);
    }
}

