/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.controller;

import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.management.AuthorizedAddress;
import org.jboss.as.domain.management.controller.ActiveOperationResourceDefinition;
import org.jboss.dmr.ModelNode;

public class SecureOperationReadHandler
implements OperationStepHandler {
    private static final String HIDDEN = "<hidden>";
    private static final Set<Action.ActionEffect> ADDRESS_EFFECT = EnumSet.of(Action.ActionEffect.ADDRESS);
    static final OperationStepHandler INSTANCE = new SecureOperationReadHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        AuthorizedAddress authorizedAddress = AuthorizedAddress.authorizeAddress((OperationContext)context, (ModelNode)operation);
        String attribute = operation.require("name").asString();
        if (ActiveOperationResourceDefinition.OPERATION_NAME.getName().equals(attribute)) {
            if (authorizedAddress.isElided()) {
                context.getResult().set(HIDDEN);
            } else {
                context.getResult().set(model.get(attribute));
            }
        } else if (ActiveOperationResourceDefinition.ADDRESS.getName().equals(attribute)) {
            if (authorizedAddress.isElided()) {
                context.getResult().set(authorizedAddress.getAddress());
            } else {
                context.getResult().set(model.get(attribute));
            }
        } else {
            throw new IllegalStateException();
        }
    }
}

