/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rundeck.client.api.model.DateInfo;
import org.rundeck.client.api.model.JobItem;
import org.rundeck.client.util.RdClientConfig;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Execution {
    private String id;
    private String href;
    private String permalink;
    private String status;
    private String project;
    private String user;
    private String serverUUID;
    @JsonProperty(value="date-started")
    private DateInfo dateStarted;
    @JsonProperty(value="date-ended")
    private DateInfo dateEnded;
    private JobItem job;
    private String description;
    private String argstring;
    private List<String> successfulNodes;
    private List<String> failedNodes;

    public String toBasicString() {
        String desc = this.getBasicDescription();
        if (null != desc) {
            return String.format("[%s] %s <%s>", this.id, desc, this.permalink);
        }
        return String.format("[%s] <%s>", this.id, this.permalink);
    }

    public String toExtendedString(RdClientConfig config) {
        return String.format("%s %s %s %s %s %s %s", this.id, this.status, null != this.dateStarted ? this.dateStarted.format(config.getDateFormat()) : "-", null != this.dateEnded ? this.dateEnded.format(config.getDateFormat()) : "-", this.permalink, null != this.getJob() ? "job" : "adhoc", this.getBasicDescription());
    }

    private String getBasicDescription() {
        if (null != this.getJob()) {
            return this.getJob().toBasicString();
        }
        return this.shortened(this.description);
    }

    private String shortened(String description) {
        if (description.indexOf("\n") > 0) {
            String[] list = description.split("\\r?\\n");
            if (list.length > 1) {
                return String.format("%s (%d more lines)", list[0], list.length - 1);
            }
            return list[0];
        }
        return description;
    }

    public Map getInfoMap(RdClientConfig config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.getId());
        map.put("description", this.shortened(this.getDescription()));
        map.put("argstring", this.getArgstring());
        map.put("permalink", this.getPermalink());
        map.put("href", this.getHref());
        map.put("status", this.getStatus());
        map.put("project", this.getProject());
        if (null != this.getJob()) {
            map.put("job", this.getJob().toMap());
            map.put("adhoc", "false");
        } else {
            map.put("adhoc", "true");
        }
        map.put("user", this.getUser());
        map.put("serverUUID", this.getServerUUID());
        map.put("dateStarted", null != this.getDateStarted() ? this.getDateStarted().format(config.getDateFormat()) : null);
        map.put("dateEnded", null != this.getDateEnded() ? this.getDateEnded().format(config.getDateFormat()) : null);
        map.put("successfulNodes", this.getSuccessfulNodes());
        map.put("failedNodes", this.getFailedNodes());
        return map;
    }

    public String toStatusString() {
        return String.format("[%s] %s", this.id, this.status);
    }

    public String toString() {
        return "org.rundeck.client.api.model.Execution{id='" + this.id + '\'' + ", href='" + this.href + '\'' + ", permalink='" + this.permalink + '\'' + ", status='" + this.status + '\'' + ", project='" + this.project + '\'' + ", user='" + this.user + '\'' + ", serverUUID='" + this.serverUUID + '\'' + ", dateStarted=" + this.dateStarted + ", dateEnded=" + this.dateEnded + ", job=" + this.job + ", description='" + this.description + '\'' + ", argstring='" + this.argstring + '\'' + ", successfulNodes=" + this.successfulNodes + ", failedNodes=" + this.failedNodes + '}';
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public void setPermalink(String permalink) {
        this.permalink = permalink;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    public void setServerUUID(String serverUUID) {
        this.serverUUID = serverUUID;
    }

    public DateInfo getDateStarted() {
        return this.dateStarted;
    }

    public void setDateStarted(DateInfo dateStarted) {
        this.dateStarted = dateStarted;
    }

    public DateInfo getDateEnded() {
        return this.dateEnded;
    }

    public void setDateEnded(DateInfo dateEnded) {
        this.dateEnded = dateEnded;
    }

    public JobItem getJob() {
        return this.job;
    }

    public void setJob(JobItem job) {
        this.job = job;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getArgstring() {
        return this.argstring;
    }

    public void setArgstring(String argstring) {
        this.argstring = argstring;
    }

    public List<String> getSuccessfulNodes() {
        return this.successfulNodes;
    }

    public void setSuccessfulNodes(List<String> successfulNodes) {
        this.successfulNodes = successfulNodes;
    }

    public List<String> getFailedNodes() {
        return this.failedNodes;
    }

    public void setFailedNodes(List<String> failedNodes) {
        this.failedNodes = failedNodes;
    }
}

