/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.format;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.rundeck.client.tool.format.OutputFormatter;

public class NiceFormatter
implements OutputFormatter {
    OutputFormatter base;
    private String collectionIndicator = "* ";
    private String keyValueSeparator = ": ";
    private String indentation = "  ";
    static final String NL = System.getProperty("line.separator");

    public NiceFormatter(OutputFormatter base) {
        this.base = base;
    }

    @Override
    public OutputFormatter withBase(OutputFormatter base) {
        this.base = base;
        return this;
    }

    @Override
    public String format(Object o) {
        if (o instanceof Map) {
            return this.formatMap((Map)o, 0);
        }
        if (o instanceof Collection) {
            return this.formatCollection((Collection)o, 0);
        }
        return this.base.format(o);
    }

    private String formatMap(Map o, int level) {
        StringBuilder sb = new StringBuilder();
        for (Object key : o.keySet()) {
            this.indent(level, this.format(key), sb, true);
            Object o1 = o.get(key);
            String format = this.format(o1);
            sb.append(this.keyValueSeparator);
            if (null != format) {
                if (format.contains(NL)) {
                    sb.append(NL);
                    this.indent(level + 1, format, sb, true);
                } else {
                    sb.append(format);
                }
            }
            sb.append(NL);
        }
        return sb.toString();
    }

    private void indent(int level, String msg, StringBuilder sb, boolean firstLine) {
        if (level < 1) {
            sb.append(msg);
            return;
        }
        StringBuilder idsb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            idsb.append(this.indentation);
        }
        String id = idsb.toString();
        if (msg.contains(NL)) {
            String[] split = msg.split(Pattern.quote(NL));
            if (firstLine) {
                sb.append(id);
            }
            if (split.length > 0) {
                sb.append(split[0]).append(NL);
            }
            for (int i = 1; i < split.length; ++i) {
                String s = split[i];
                sb.append(id).append(s).append(NL);
            }
        } else {
            sb.append(id).append(msg);
        }
    }

    private String formatCollection(Collection o, int level) {
        StringBuilder sb = new StringBuilder();
        for (Object o1 : o) {
            this.indent(level, this.collectionIndicator, sb, true);
            String format = this.format(o1);
            if (format.contains(NL)) {
                this.indent(level + 1, format, sb, false);
            } else {
                sb.append(format);
            }
            sb.append(NL);
        }
        return sb.toString();
    }

    public String getCollectionIndicator() {
        return this.collectionIndicator;
    }

    public void setCollectionIndicator(String collectionIndicator) {
        this.collectionIndicator = collectionIndicator;
    }

    public String getKeyValueSeparator() {
        return this.keyValueSeparator;
    }

    public void setKeyValueSeparator(String keyValueSeparator) {
        this.keyValueSeparator = keyValueSeparator;
    }

    public String getIndentation() {
        return this.indentation;
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation;
    }
}

