/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.pages;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.fluent.Theme;
import com.jgoodies.fluent.navigation.NavigationBar;
import com.jgoodies.fluent.pivots.PivotContent;
import com.jgoodies.fluent.pivots.PivotModel;
import com.jgoodies.navigation.IAppBar;
import com.jgoodies.navigation.NavigationEventArgs;
import com.jgoodies.navigation.Page;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Supplier;
import javax.swing.Icon;

public class PivotPage
extends Page.AbstractPage {
    protected Theme theme;
    private boolean backButtonVisible = false;
    private Supplier<PivotModel> pivotSupplier = () -> null;
    private PivotModel cachedPivotModel;
    private final PropertyChangeListener pivotModelPropertyChangeListener = this::onPivotModelPropertyChanged;

    public final void setTheme(Theme theme) {
        this.theme = theme;
    }

    protected final boolean isBackButtonVisible() {
        return this.backButtonVisible;
    }

    public final void setBackButtonVisible(boolean visible) {
        this.backButtonVisible = visible;
    }

    @Override
    public final void setIcon(Icon newValue) {
        super.setIcon(newValue);
    }

    @Override
    public final void setDisplayString(String str, Object ... args) {
        super.setDisplayString(str, args);
    }

    public final PivotModel getTabs() {
        PivotModel oldPivotModel = this.cachedPivotModel;
        if (this.cachedPivotModel == null) {
            this.cachedPivotModel = this.pivotSupplier.get();
        }
        if (this.cachedPivotModel != oldPivotModel) {
            if (oldPivotModel != null) {
                oldPivotModel.removePropertyChangeListener(this.pivotModelPropertyChangeListener);
            }
            if (this.cachedPivotModel != null) {
                this.cachedPivotModel.addPropertyChangeListener(this.pivotModelPropertyChangeListener);
            }
        }
        return this.cachedPivotModel;
    }

    public final void setTabs(PivotModel pivotModel) {
        Preconditions.checkNotNull(pivotModel, "The %s must not be null.", "pivot model");
        this.setTabs(() -> pivotModel);
    }

    public final void setTabs(Supplier<PivotModel> pivotSupplier) {
        this.pivotSupplier = Preconditions.checkNotNull(pivotSupplier, "The %s must not be null.", "pivot supplier");
        this.cachedPivotModel = null;
        this.setContent(() -> PivotContent.build(this.getTabs(), this.theme));
    }

    @Override
    public final void setTopAppBar(IAppBar appBar) {
        super.setTopAppBar(appBar);
    }

    @Override
    public final void setTopAppBar(Supplier<IAppBar> appBarSupplier) {
        super.setTopAppBar(appBarSupplier);
    }

    public final void setTopNavigationBar() {
        this.setTopAppBar(() -> new NavigationBar.Builder().pageModel(this.getPageModel()).theme(this.theme).backButtonVisible(this.backButtonVisible).build());
    }

    @Override
    public final void setBottomAppBar(IAppBar appBar) {
        super.setBottomAppBar(appBar);
    }

    @Override
    public final void setBottomAppBar(Supplier<IAppBar> appBarSupplier) {
        super.setBottomAppBar(appBarSupplier);
    }

    @Override
    public void onNavigatedTo(NavigationEventArgs args) {
        if (this.getTabs() != null) {
            this.getTabs().selectByParameter(args.getParameter());
        }
    }

    @Override
    public String getPersistentPageParameter() {
        return this.getTabs() == null ? null : String.valueOf(this.getTabs().getSelectedIndex());
    }

    private void onPivotModelPropertyChanged(PropertyChangeEvent evt) {
        this.firePropertyChange(evt);
    }

    public static final class Builder {
        private final PivotPage target = new PivotPage();
        private boolean tabsSet = false;

        public Builder theme(Theme theme) {
            this.target.setTheme(theme);
            return this;
        }

        public Builder backButtonVisible(boolean visible) {
            this.target.setBackButtonVisible(visible);
            return this;
        }

        public Builder icon(Icon value) {
            this.target.setIcon(value);
            return this;
        }

        public Builder displayString(String value) {
            this.target.setDisplayString(value, new Object[0]);
            return this;
        }

        public Builder tabs(PivotModel pivotModel) {
            return this.tabs(() -> pivotModel);
        }

        public Builder tabs(Supplier<PivotModel> pivotSupplier) {
            this.target.setTabs(pivotSupplier);
            this.tabsSet = true;
            return this;
        }

        public Builder topAppBar(IAppBar value) {
            this.target.setTopAppBar(value);
            return this;
        }

        public Builder topAppBar(Supplier<IAppBar> value) {
            this.target.setTopAppBar(value);
            return this;
        }

        public Builder topNavigationBar() {
            this.target.setTopNavigationBar();
            return this;
        }

        public Builder bottomAppBar(IAppBar value) {
            this.target.setBottomAppBar(value);
            return this;
        }

        public Builder bottomAppBar(Supplier<IAppBar> value) {
            this.target.setBottomAppBar(value);
            return this;
        }

        public PivotPage build() {
            if (!this.tabsSet) {
                throw new IllegalStateException("You must call #tabs(PivotModel) or #tabs(Supplier<PivotModel>)  before you can build this page.");
            }
            return this.target;
        }
    }
}

