/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class HistoryList<E> {
    private final int limit;
    private final List<E> list;
    private int indexOfNextAdd;

    public HistoryList(int limit) {
        this.limit = limit;
        this.list = new ArrayList(limit);
        this.indexOfNextAdd = 0;
    }

    public boolean add(E e) {
        if (e.equals(this.getLastAdded())) {
            return false;
        }
        for (int index = this.list.size() - 1; index > 0 && index >= this.indexOfNextAdd; --index) {
            this.list.remove(index);
        }
        this.list.add(this.indexOfNextAdd, e);
        if (this.list.size() > this.limit) {
            this.list.remove(0);
        } else {
            ++this.indexOfNextAdd;
        }
        return true;
    }

    public void removeAll(E item) {
        for (int index = this.list.size() - 1; index > 0; --index) {
            E element = this.list.get(index);
            if (!element.equals(item)) continue;
            this.list.remove(index);
            if (index >= this.indexOfNextAdd) continue;
            --this.indexOfNextAdd;
        }
    }

    public E getAndGoPrevious() {
        return this.hasPrevious() ? (E)this.list.get(--this.indexOfNextAdd - 1) : null;
    }

    public E getAndGoNext() {
        return this.hasNext() ? (E)this.list.get(this.indexOfNextAdd++) : null;
    }

    public Iterator<E> getBackIterator() {
        List<E> sublist = this.subListNoDuplicates(0, this.indexOfNextAdd - 1);
        Collections.reverse(sublist);
        return sublist.iterator();
    }

    public Iterator<E> getNextIterator() {
        return this.subListNoDuplicates(this.indexOfNextAdd, this.list.size()).iterator();
    }

    public E getLastAdded() {
        return this.indexOfNextAdd > 0 ? (E)this.list.get(this.indexOfNextAdd - 1) : null;
    }

    public E getPrevious() {
        return this.hasPrevious() ? (E)this.list.get(this.indexOfNextAdd - 2) : null;
    }

    public E getNext() {
        return this.hasNext() ? (E)this.list.get(this.indexOfNextAdd) : null;
    }

    public void goBack(int steps) {
        this.indexOfNextAdd = Math.max(0, this.indexOfNextAdd - steps);
    }

    public void goNext(int steps) {
        this.indexOfNextAdd = Math.min(this.indexOfNextAdd + steps, this.list.size());
    }

    public boolean hasPrevious() {
        return this.indexOfNextAdd > 1;
    }

    public boolean hasNext() {
        return this.indexOfNextAdd < this.list.size();
    }

    private List<E> subListNoDuplicates(int startIndex, int stopIndex) {
        E lastAdded = this.getLastAdded();
        ArrayList<E> result = new ArrayList<E>();
        for (int i = startIndex; i < stopIndex; ++i) {
            E e = this.list.get(i);
            if (e == lastAdded) continue;
            result.add(e);
        }
        return result;
    }

    public String toString() {
        return "(Limit: " + this.limit + "; indexOfNextAdd: " + this.indexOfNextAdd + ")" + this.list.toString();
    }
}

