/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.blocking;

import org.multiverse.api.blocking.RetryLatch;
import org.multiverse.api.exceptions.RetryInterruptedException;

public final class DefaultRetryLatch
implements RetryLatch {
    private volatile long era = Long.MIN_VALUE;
    private volatile boolean isOpen = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(long expectedEra) {
        if (this.isOpen || expectedEra != this.era) {
            return;
        }
        DefaultRetryLatch defaultRetryLatch = this;
        synchronized (defaultRetryLatch) {
            if (this.isOpen || expectedEra != this.era) {
                return;
            }
            this.isOpen = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await(long expectedEra, String transactionFamilyName) {
        if (this.isOpen || expectedEra != this.era) {
            return;
        }
        try {
            DefaultRetryLatch defaultRetryLatch = this;
            synchronized (defaultRetryLatch) {
                while (!this.isOpen && this.era == expectedEra) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RetryInterruptedException(String.format("[%s] Was interrupted while waiting on the retry", transactionFamilyName), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitUninterruptible(long expectedEra) {
        if (this.isOpen || expectedEra != this.era) {
            return;
        }
        boolean restoreInterrupt = false;
        DefaultRetryLatch defaultRetryLatch = this;
        synchronized (defaultRetryLatch) {
            while (!this.isOpen && this.era == expectedEra) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    restoreInterrupt = true;
                }
            }
        }
        if (restoreInterrupt) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long awaitNanosUninterruptible(long expectedEra, long nanosTimeout) {
        if (this.isOpen || expectedEra != this.era) {
            return nanosTimeout;
        }
        if (nanosTimeout <= 0L) {
            return -1L;
        }
        restoreInterrupt = false;
        try {
            while (true) {
                startNs = System.nanoTime();
                var8_6 = this;
                synchronized (var8_6) {
                    while (!this.isOpen && expectedEra == this.era) {
                        if (nanosTimeout <= 0L) {
                            var9_7 = -1L;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 6, 9, 10, 14] lbl15 : MonitorExitStatement: MONITOREXIT : var8_6
                            if (restoreInterrupt) {
                                Thread.currentThread().interrupt();
                            }
                            return var9_7;
                        }
                        ms = nanosTimeout / 1000000L;
                        ns = (int)(nanosTimeout % 1000000L);
                        this.wait(ms, ns);
                        nanosTimeout -= System.nanoTime() - startNs;
                    }
                    var9_7 = nanosTimeout;
                    ** if (!restoreInterrupt) goto lbl27
                }
lbl-1000:
                // 1 sources

                {
                    Thread.currentThread().interrupt();
                }
lbl27:
                // 2 sources

                return var9_7;
                {
                    catch (InterruptedException ex) {
                        restoreInterrupt = true;
                        nanosTimeout -= System.nanoTime() - startNs;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Throwable var13_9) {
            if (restoreInterrupt) {
                Thread.currentThread().interrupt();
            }
            throw var13_9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long awaitNanos(long expectedEra, long nanosTimeout, String transactionFamilyName) {
        if (this.isOpen || expectedEra != this.era) {
            return nanosTimeout;
        }
        if (nanosTimeout <= 0L) {
            return -1L;
        }
        try {
            DefaultRetryLatch defaultRetryLatch = this;
            synchronized (defaultRetryLatch) {
                while (!this.isOpen && expectedEra == this.era) {
                    if (nanosTimeout <= 0L) {
                        return -1L;
                    }
                    long ms = nanosTimeout / 1000000L;
                    int ns = (int)(nanosTimeout % 1000000L);
                    long startNs = System.nanoTime();
                    this.wait(ms, ns);
                    nanosTimeout -= System.nanoTime() - startNs;
                }
                return nanosTimeout;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RetryInterruptedException(String.format("[%s] Was interrupted while waiting on the retry", transactionFamilyName), ex);
        }
    }

    @Override
    public long getEra() {
        return this.era;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        DefaultRetryLatch defaultRetryLatch = this;
        synchronized (defaultRetryLatch) {
            if (!this.isOpen) {
                this.notifyAll();
            } else {
                this.isOpen = false;
            }
            ++this.era;
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    public String toString() {
        return String.format("DefaultRetryLatch(open=%s, era=%s)", this.isOpen, this.era);
    }
}

