/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.outline;

import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.Font;
import com.aspose.words.License;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.SaveOptions;
import com.aspose.words.Shape;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.util.BundleUtility;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.exports.outline.OutlinePlugin;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.wizards.ExportPart;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;
import org.xmind.ui.wizards.IExporter;

public class OutlineDocumentExporter
extends Exporter {
    private static final int TYPE_CENTRAL = 0;
    private static final int TYPE_MAIN = 1;
    private static final int TYPE_SUB_1 = 2;
    private static final int TYPE_SUB_2 = 3;
    private static final int TYPE_SUB_3 = 8;
    private static final int TYPE_SUB = 4;
    private static final int TYPE_FLOATING = 5;
    private static final int TYPE_SUMMARY = 6;
    private static final int TYPE_CALLOUT = 7;
    public static final int PDF = 1;
    public static final int WORD_97_2003 = 2;
    public static final int WORD_2007 = 3;
    private String targetPath;
    private int version;
    private DocumentBuilder builder;
    private boolean currentSheetOnly;

    public OutlineDocumentExporter(ISheet sheet, ITopic centralTopic) {
        super(sheet, centralTopic);
    }

    public OutlineDocumentExporter(ISheet sheet, ITopic centralTopic, boolean currentSheetOnly) {
        super(sheet, centralTopic);
        this.currentSheetOnly = currentSheetOnly;
    }

    public OutlineDocumentExporter(ISheet sheet, ITopic centralTopic, boolean currentSheetOnly, String targetPath, int version) {
        this(sheet, centralTopic, currentSheetOnly);
        this.targetPath = targetPath;
        this.version = version;
    }

    public void init() {
        ISheet sheet = this.getSheet();
        if (this.currentSheetOnly) {
            this.appendTopicTitle(sheet.getRootTopic(), 0, 0);
        } else {
            IWorkbook workbook = sheet.getOwnedWorkbook();
            for (ISheet s : workbook.getSheets()) {
                this.appendTopicTitle(s.getRootTopic(), 0, 0);
                this.append((IExportPart)new EmptyLinePart((IExporter)this, null));
            }
        }
    }

    private void appendTopicTitle(ITopic topic, int level, int type) {
        int tl = "summary".equals(topic.getType()) ? level - 1 : level;
        this.append((IExportPart)new TitlePart(this, topic.getTitleText(), tl, type));
        List attacheds = topic.getChildren("attached");
        for (ITopic attached : attacheds) {
            this.appendTopicTitle(attached, level + 1, this.calcAttachedType(level + 1));
        }
        List detacheds = topic.getChildren("detached");
        for (ITopic detached : detacheds) {
            this.appendTopicTitle(detached, level + 1, 5);
        }
        List summaries = topic.getChildren("summary");
        for (ITopic summary : summaries) {
            this.appendTopicTitle(summary, level + 1, 6);
        }
        List callouts = topic.getChildren("callout");
        for (ITopic callout : callouts) {
            this.appendTopicTitle(callout, level + 1, 7);
        }
    }

    private int calcAttachedType(int level) {
        switch (level) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 8;
            }
        }
        return 4;
    }

    public void start(Display display, Shell shell) throws InvocationTargetException {
        super.start(display, shell);
        try {
            this.setLicense();
            this.builder = new DocumentBuilder(new Document());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.builder.getDocument().setDefaultTabStop(10.0);
    }

    private void setLicense() throws Exception {
        new License().setLicense((InputStream)new ByteArrayInputStream(OutlinePlugin.getAsposeLicense()));
    }

    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
        if (part instanceof TitlePart) {
            ((TitlePart)part).write(this.builder);
        }
        if (part instanceof EmptyLinePart) {
            ((EmptyLinePart)part).write(this.builder);
        }
    }

    public void end() throws InvocationTargetException {
        this.writePageNumber();
        int format = this.getSaveFormat(this.version);
        try {
            if (format == 20) {
                OoxmlSaveOptions saveOption = new OoxmlSaveOptions(format);
                saveOption.setCompliance(1);
                this.builder.getDocument().save(this.targetPath, (SaveOptions)saveOption);
            } else {
                this.builder.getDocument().save(this.targetPath, format);
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        super.end();
    }

    private int getSaveFormat(int version) {
        switch (version) {
            case 2: {
                return 10;
            }
            case 3: {
                return 20;
            }
        }
        return 40;
    }

    private void writePageNumber() {
        this.builder.moveToSection(0);
        this.builder.moveToHeaderFooter(3);
        try {
            this.builder.insertField("PAGE");
            this.builder.getParagraphFormat().setAlignment(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PageSetup pageSetup = this.builder.getCurrentSection().getPageSetup();
        pageSetup.setRestartPageNumbering(true);
        pageSetup.setPageStartingNumber(1);
    }

    private static class EmptyLinePart
    extends ExportPart {
        private DocumentBuilder builder;

        public EmptyLinePart(IExporter exporter, Object element) {
            super(exporter, element);
        }

        public void write(DocumentBuilder builder) {
            this.builder = builder;
            this.write();
        }

        private void write() {
            this.builder.writeln();
        }
    }

    private static class TitlePart
    extends ExportPart {
        private int level;
        private int type;
        private DocumentBuilder builder;

        public TitlePart(IExporter exporter, Object element) {
            super(exporter, element);
        }

        public TitlePart(OutlineDocumentExporter exporter, String title, int level, int type) {
            this((IExporter)exporter, title);
            this.level = level;
            this.type = type;
        }

        public void write(DocumentBuilder builder) {
            this.builder = builder;
            this.write();
        }

        private void write() {
            String bullet;
            String title;
            block15: {
                String path;
                URL url;
                this.style(this.type);
                title = (String)this.getElement();
                this.align(0);
                bullet = this.getBullet(this.type);
                if (bullet != null && (url = BundleUtility.find((String)"org.xmind.ui.exports.outline", (String)(path = "icons/" + bullet))) != null) {
                    InputStream stream = null;
                    try {
                        try {
                            stream = url.openStream();
                            this.picture(stream, 8, 8);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (stream != null) {
                                try {
                                    stream.close();
                                    stream = null;
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                                stream = null;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                            stream = null;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            String text = this.trim(this.correctTitle(title));
            this.multiLines(bullet == null ? text : " " + text);
            this.endParagraph();
            this.clearFontFormat();
        }

        private String getBullet(int type) {
            switch (type) {
                case 2: {
                    return "bullet_1.png";
                }
                case 3: {
                    return "bullet_2.png";
                }
                case 5: 
                case 8: {
                    return "bullet_3.png";
                }
            }
            return null;
        }

        private void style(int type) {
            switch (type) {
                case 0: {
                    this.setTextStyle("Calibri Light", false, false, 28, "#000000");
                    break;
                }
                case 1: {
                    this.setTextStyle("Calibri", false, false, 16, "#000000");
                    break;
                }
                case 2: {
                    this.setTextStyle("Calibri", true, false, 12, "#000000");
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    this.setTextStyle("Calibri", false, false, 12, "#000000");
                    break;
                }
                case 6: {
                    this.setTextStyle("Calibri", false, true, 12, "#823C14");
                    break;
                }
                case 7: {
                    this.setTextStyle("Calibri", false, true, 12, "#000000");
                    break;
                }
                default: {
                    this.setTextStyle("Calibri", false, false, 12, "#000000");
                }
            }
        }

        private void setTextStyle(String fontFamily, boolean bold, boolean italic, int size, String colorKey) {
            ParagraphFormat format = this.builder.getParagraphFormat();
            format.setLeftIndent((double)((this.level < 18 ? this.level : 18) * 12));
            format.setLineSpacing(17.0);
            Font font = this.builder.getFont();
            font.setName(fontFamily);
            font.setBold(bold);
            font.setItalic(italic);
            Color color = ColorUtils.getColor((String)colorKey);
            font.setColor(new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue()));
            font.setSize((double)size);
        }

        private void clearFontFormat() {
            this.builder.getFont().clearFormatting();
        }

        private String trim(String title) {
            int index = 0;
            int i = 0;
            while (i < title.length()) {
                if (title.charAt(i) != ' ') break;
                ++index;
                ++i;
            }
            return title.substring(index);
        }

        private String correctTitle(String title) {
            return title.replaceAll("\r\n|\r|\n", " ");
        }

        protected void endParagraph() {
            this.builder.writeln();
        }

        protected void align(int alignment) {
            this.builder.getParagraphFormat().setAlignment(alignment);
        }

        protected void multiLines(String text) {
            String[] lines = TitlePart.getMultiLines(text);
            int i = 0;
            while (i < lines.length) {
                this.print(lines[i]);
                if (i < lines.length - 1) {
                    this.builder.insertBreak(8);
                }
                ++i;
            }
        }

        protected static String[] getMultiLines(String text) {
            String[] lines = text.split("\\r\\n|\\r|\\n");
            return lines;
        }

        protected void print(String text) {
            this.builder.write(text);
        }

        protected Shape picture(InputStream stream, int width, int height) {
            try {
                return this.builder.insertImage(stream, (double)width, (double)height);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

