/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.ThreadSafe;
import net.rubygrapefruit.platform.internal.NativeLibraryLoader;
import net.rubygrapefruit.platform.internal.NativeLibraryLocator;
import net.rubygrapefruit.platform.internal.Platform;
import net.rubygrapefruit.platform.internal.jni.NativeLibraryFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class Native {
    private static NativeLibraryLoader loader;
    private static final Map<Class<?>, Object> integrations;

    private Native() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public static void init(File extractDir) throws NativeIntegrationUnavailableException, NativeException {
        Class<Native> clazz = Native.class;
        synchronized (Native.class) {
            if (loader == null) {
                Platform platform = Platform.current();
                try {
                    loader = new NativeLibraryLoader(platform, new NativeLibraryLocator(extractDir, "c067742578af261105cb4f569cf0c3c89f3d7b1fecec35dd04571415982c5e48"));
                    loader.load(platform.getLibraryName(), platform.getLibraryVariants());
                    String nativeVersion = NativeLibraryFunctions.getVersion();
                    if (!nativeVersion.equals("c067742578af261105cb4f569cf0c3c89f3d7b1fecec35dd04571415982c5e48")) {
                        throw new NativeException(String.format("Unexpected native library version loaded. Expected %s, was %s.", "c067742578af261105cb4f569cf0c3c89f3d7b1fecec35dd04571415982c5e48", nativeVersion));
                    }
                }
                catch (NativeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new NativeException("Failed to initialise native integration.", t);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public static <T extends NativeIntegration> T get(Class<T> type) throws NativeIntegrationUnavailableException, NativeException {
        Native.init(null);
        Class<Native> clazz = Native.class;
        synchronized (Native.class) {
            Platform platform = Platform.current();
            Class<T> canonicalType = platform.canonicalise(type);
            Object instance = integrations.get(canonicalType);
            if (instance == null) {
                try {
                    instance = platform.get(canonicalType, loader);
                }
                catch (NativeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new NativeException(String.format("Failed to load native integration %s.", type.getSimpleName()), t);
                }
                integrations.put(canonicalType, instance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (T)((NativeIntegration)type.cast(instance));
        }
    }

    static {
        integrations = new HashMap();
    }
}

