/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ProjectComponentIdentifierInternal;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.publish.internal.mapping.ComponentDependencyResolver;
import org.gradle.api.publish.internal.mapping.ResolvedCoordinates;
import org.gradle.api.publish.internal.mapping.VariantDependencyResolver;
import org.gradle.api.publish.internal.validation.VariantWarningCollector;
import org.gradle.internal.component.local.model.ProjectComponentSelectorInternal;
import org.gradle.util.Path;

public class ResolutionBackedVariantDependencyResolver
implements VariantDependencyResolver {
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final AttributeDesugaring attributeDesugaring;
    private final ComponentDependencyResolver fallback;
    private final ResolvedMappings mappings;

    public ResolutionBackedVariantDependencyResolver(ProjectDependencyPublicationResolver projectDependencyResolver, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ResolvedComponentResult rootComponent, ResolvedVariantResult rootVariant, AttributeDesugaring attributeDesugaring, ComponentDependencyResolver fallback) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.attributeDesugaring = attributeDesugaring;
        this.fallback = fallback;
        this.mappings = ResolutionBackedVariantDependencyResolver.calculateMappings(rootComponent, rootVariant, projectDependencyResolver, moduleIdentifierFactory);
    }

    private static ResolvedMappings calculateMappings(ResolvedComponentResult rootComponent, ResolvedVariantResult rootVariant, ProjectDependencyPublicationResolver projectDependencyResolver, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        HashMap<ModuleDependencyKey, ModuleVersionIdentifier> resolvedModules = new HashMap<ModuleDependencyKey, ModuleVersionIdentifier>();
        HashMap<ProjectDependencyKey, ModuleVersionIdentifier> resolvedProjects = new HashMap<ProjectDependencyKey, ModuleVersionIdentifier>();
        HashSet<ModuleDependencyKey> incompatibleModules = new HashSet<ModuleDependencyKey>();
        HashSet<ProjectDependencyKey> incompatibleProjects = new HashSet<ProjectDependencyKey>();
        ResolutionBackedVariantDependencyResolver.visitFirstLevelEdges(rootComponent, rootVariant, edge -> {
            ComponentSelector requested = edge.getRequested();
            ModuleVersionIdentifier coordinates = ResolutionBackedVariantDependencyResolver.getVariantCoordinates(edge, projectDependencyResolver, moduleIdentifierFactory);
            if (requested instanceof ModuleComponentSelector) {
                ModuleComponentSelector requestedModule = (ModuleComponentSelector)requested;
                ModuleDependencyKey key = new ModuleDependencyKey(requestedModule.getModuleIdentifier(), ModuleDependencyDetails.from(requested));
                if (incompatibleModules.contains(key)) {
                    return;
                }
                ModuleVersionIdentifier existing = resolvedModules.put(key, coordinates);
                if (existing != null && !existing.equals(coordinates)) {
                    resolvedModules.remove(key);
                    incompatibleModules.add(key);
                }
            } else if (requested instanceof ProjectComponentSelector) {
                ProjectComponentSelectorInternal requestedProject = (ProjectComponentSelectorInternal)requested;
                ProjectDependencyKey key = new ProjectDependencyKey(requestedProject.getIdentityPath(), ModuleDependencyDetails.from(requested));
                if (incompatibleProjects.contains(key)) {
                    return;
                }
                ModuleVersionIdentifier existing = resolvedProjects.put(key, coordinates);
                if (existing != null && !existing.equals(coordinates)) {
                    resolvedProjects.remove(key);
                    incompatibleProjects.add(key);
                }
            }
        });
        return new ResolvedMappings(resolvedModules, resolvedProjects, incompatibleModules, incompatibleProjects);
    }

    private static void visitFirstLevelEdges(ResolvedComponentResult rootComponent, ResolvedVariantResult rootVariant, Consumer<ResolvedDependencyResult> visitor) {
        List rootEdges = rootComponent.getDependenciesForVariant(rootVariant);
        for (DependencyResult dependencyResult : rootEdges) {
            if (!(dependencyResult instanceof ResolvedDependencyResult)) {
                UnresolvedDependencyResult unresolved = (UnresolvedDependencyResult)dependencyResult;
                throw new GradleException("Could not map coordinates for " + unresolved.getAttempted().getDisplayName() + ".", unresolved.getFailure());
            }
            if (dependencyResult.isConstraint()) continue;
            visitor.accept((ResolvedDependencyResult)dependencyResult);
        }
    }

    private static ModuleVersionIdentifier getVariantCoordinates(ResolvedDependencyResult edge, ProjectDependencyPublicationResolver projectDependencyResolver, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        ResolvedVariantResult variant = edge.getResolvedVariant();
        ComponentIdentifier componentId = variant.getOwner();
        if (componentId instanceof ProjectComponentIdentifier) {
            return ResolutionBackedVariantDependencyResolver.getProjectCoordinates(variant, (ProjectComponentIdentifierInternal)componentId, projectDependencyResolver);
        }
        if (componentId instanceof ModuleComponentIdentifier) {
            return ResolutionBackedVariantDependencyResolver.getModuleCoordinates(variant, (ModuleComponentIdentifier)componentId, moduleIdentifierFactory);
        }
        throw new UnsupportedOperationException("Unexpected component identifier type: " + componentId);
    }

    private static ModuleVersionIdentifier getModuleCoordinates(ResolvedVariantResult variant, ModuleComponentIdentifier componentId, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        ResolvedVariantResult externalVariant = variant.getExternalVariant().orElse(null);
        if (externalVariant != null) {
            ComponentIdentifier owningComponent = externalVariant.getOwner();
            if (owningComponent instanceof ModuleComponentIdentifier) {
                ModuleComponentIdentifier moduleComponentId = (ModuleComponentIdentifier)owningComponent;
                return moduleIdentifierFactory.moduleWithVersion(moduleComponentId.getModuleIdentifier(), moduleComponentId.getVersion());
            }
            throw new GradleException("Expected owning component of module component to be a module component: " + owningComponent);
        }
        return moduleIdentifierFactory.moduleWithVersion(componentId.getModuleIdentifier(), componentId.getVersion());
    }

    private static ModuleVersionIdentifier getProjectCoordinates(ResolvedVariantResult variant, ProjectComponentIdentifierInternal componentId, ProjectDependencyPublicationResolver projectDependencyResolver) {
        String variantName;
        Path identityPath = componentId.getIdentityPath();
        ModuleVersionIdentifier coordinates = (ModuleVersionIdentifier)projectDependencyResolver.resolveVariant(ModuleVersionIdentifier.class, identityPath, variantName = variant.getDisplayName());
        if (coordinates == null) {
            throw new InvalidUserDataException(String.format("Could not resolve coordinates for variant '%s' of project '%s'.", variantName, identityPath));
        }
        return coordinates;
    }

    @Override
    @Nullable
    public ResolvedCoordinates resolveVariantCoordinates(ExternalDependency dependency, VariantWarningCollector warnings) {
        ModuleIdentifier module = this.moduleIdentifierFactory.module(dependency.getGroup(), dependency.getName());
        ModuleDependencyKey key = new ModuleDependencyKey(module, ModuleDependencyDetails.from((ModuleDependency)dependency, this.attributeDesugaring));
        ModuleVersionIdentifier resolved = this.mappings.resolvedModules.get(key);
        if (resolved != null) {
            return ResolvedCoordinates.create(resolved);
        }
        if (this.mappings.incompatibleModules.contains(key)) {
            warnings.addIncompatible(String.format("Cannot determine variant coordinates for dependency '%s' since multiple dependencies ambiguously map to different resolved coordinates.", module));
        } else {
            warnings.addIncompatible(String.format("Cannot determine variant coordinates for dependency '%s' since the resolved graph does not contain the requested module.", module));
        }
        return this.fallback.resolveComponentCoordinates(dependency);
    }

    @Override
    public ResolvedCoordinates resolveVariantCoordinates(ProjectDependency dependency, VariantWarningCollector warnings) {
        Path identityPath = ((ProjectDependencyInternal)dependency).getIdentityPath();
        ProjectDependencyKey key = new ProjectDependencyKey(identityPath, ModuleDependencyDetails.from((ModuleDependency)dependency, this.attributeDesugaring));
        ModuleVersionIdentifier resolved = this.mappings.resolvedProjects.get(key);
        if (resolved != null) {
            return ResolvedCoordinates.create(resolved);
        }
        if (this.mappings.incompatibleProjects.contains(key)) {
            warnings.addIncompatible(String.format("Cannot determine variant coordinates for Project dependency '%s' since multiple dependencies ambiguously map to different resolved coordinates.", identityPath));
        } else {
            warnings.addIncompatible(String.format("Cannot determine variant coordinates for Project dependency '%s' since the resolved graph does not contain the requested project.", identityPath));
        }
        return this.fallback.resolveComponentCoordinates(dependency);
    }

    private static class ModuleDependencyDetails {
        final AttributeContainer requestAttributes;
        final List<Capability> requestCapabilities;

        public ModuleDependencyDetails(AttributeContainer requestAttributes, List<Capability> requestCapabilities) {
            this.requestAttributes = requestAttributes;
            this.requestCapabilities = requestCapabilities;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleDependencyDetails that = (ModuleDependencyDetails)o;
            return Objects.equals(this.requestAttributes, that.requestAttributes) && Objects.equals(this.requestCapabilities, that.requestCapabilities);
        }

        public int hashCode() {
            return Objects.hash(this.requestAttributes, this.requestCapabilities);
        }

        public static ModuleDependencyDetails from(ModuleDependency dependency, AttributeDesugaring attributeDesugaring) {
            ImmutableAttributes attributes = ((AttributeContainerInternal)dependency.getAttributes()).asImmutable();
            return new ModuleDependencyDetails((AttributeContainer)attributeDesugaring.desugar(attributes), dependency.getRequestedCapabilities());
        }

        public static ModuleDependencyDetails from(ComponentSelector componentSelector) {
            return new ModuleDependencyDetails(componentSelector.getAttributes(), componentSelector.getRequestedCapabilities());
        }
    }

    private static class ProjectDependencyKey {
        private final Path identityPath;
        private final ModuleDependencyDetails details;

        public ProjectDependencyKey(Path identityPath, ModuleDependencyDetails details) {
            this.identityPath = identityPath;
            this.details = details;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectDependencyKey that = (ProjectDependencyKey)o;
            return Objects.equals(this.identityPath, that.identityPath) && Objects.equals(this.details, that.details);
        }

        public int hashCode() {
            return Objects.hash(this.identityPath, this.details);
        }
    }

    private static class ModuleDependencyKey {
        private final ModuleIdentifier module;
        private final ModuleDependencyDetails details;

        public ModuleDependencyKey(ModuleIdentifier module, ModuleDependencyDetails details) {
            this.module = module;
            this.details = details;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleDependencyKey that = (ModuleDependencyKey)o;
            return Objects.equals(this.module, that.module) && Objects.equals(this.details, that.details);
        }

        public int hashCode() {
            return Objects.hash(this.module, this.details);
        }
    }

    private static class ResolvedMappings {
        final Map<ModuleDependencyKey, ModuleVersionIdentifier> resolvedModules;
        final Map<ProjectDependencyKey, ModuleVersionIdentifier> resolvedProjects;
        final Set<ModuleDependencyKey> incompatibleModules;
        final Set<ProjectDependencyKey> incompatibleProjects;

        ResolvedMappings(Map<ModuleDependencyKey, ModuleVersionIdentifier> resolvedModules, Map<ProjectDependencyKey, ModuleVersionIdentifier> resolvedProjects, Set<ModuleDependencyKey> incompatibleModules, Set<ProjectDependencyKey> incompatibleProjects) {
            this.resolvedModules = resolvedModules;
            this.resolvedProjects = resolvedProjects;
            this.incompatibleModules = incompatibleModules;
            this.incompatibleProjects = incompatibleProjects;
        }
    }
}

