/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.gradle.api.NonNullApi;
import org.gradle.cache.PersistentCache;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.LocalBuildCache;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.io.IoConsumer;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.util.internal.GFileUtils;

@NonNullApi
public class DirectoryBuildCache
implements BuildCacheTempFileStore,
Closeable,
LocalBuildCache {
    private final PathKeyFileStore fileStore;
    private final PersistentCache persistentCache;
    private final BuildCacheTempFileStore tempFileStore;
    private final FileAccessTracker fileAccessTracker;
    private final String failedFileSuffix;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public DirectoryBuildCache(PathKeyFileStore fileStore, PersistentCache persistentCache, BuildCacheTempFileStore tempFileStore, FileAccessTracker fileAccessTracker, String failedFileSuffix) {
        this.fileStore = fileStore;
        this.persistentCache = persistentCache;
        this.tempFileStore = tempFileStore;
        this.fileAccessTracker = fileAccessTracker;
        this.failedFileSuffix = failedFileSuffix;
    }

    @Override
    public boolean load(HashCode key, IoConsumer<InputStream> reader) {
        AtomicBoolean loaded = new AtomicBoolean(false);
        this.loadLocally(key, file -> {
            try {
                Closer closer = Closer.create();
                FileInputStream stream = (FileInputStream)closer.register((Closeable)new FileInputStream((File)file));
                try {
                    reader.accept((Object)stream);
                    loaded.set(true);
                }
                finally {
                    closer.close();
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
        return loaded.get();
    }

    @Override
    public void loadLocally(HashCode key, Consumer<? super File> reader) {
        this.persistentCache.withFileLock(() -> {
            this.lock.readLock().lock();
            try {
                this.loadInsideLock(key, reader);
            }
            finally {
                this.lock.readLock().unlock();
            }
        });
    }

    private void loadInsideLock(HashCode key, Consumer<? super File> reader) {
        LocallyAvailableResource resource = this.fileStore.get(new String[]{key.toString()});
        if (resource == null) {
            return;
        }
        File file = resource.getFile();
        this.fileAccessTracker.markAccessed(file);
        try {
            reader.accept(file);
        }
        catch (Exception e) {
            File failedFile = new File(file.getAbsolutePath() + this.failedFileSuffix);
            GFileUtils.deleteQuietly((File)failedFile);
            file.renameTo(failedFile);
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void store(HashCode key, IoConsumer<OutputStream> result) {
        this.tempFileStore.withTempFile(key, file -> {
            try (Closer closer = Closer.create();){
                result.accept((Object)((OutputStream)closer.register((Closeable)new FileOutputStream((File)file))));
            }
            catch (IOException ex) {
                throw UncheckedException.throwAsUncheckedException((Throwable)ex);
            }
            this.storeLocally(key, (File)file);
        });
    }

    @Override
    public void storeLocally(HashCode key, File file) {
        this.persistentCache.withFileLock(() -> {
            this.lock.writeLock().lock();
            try {
                this.storeInsideLock(key, file);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    private void storeInsideLock(HashCode key, File file) {
        LocallyAvailableResource resource = this.fileStore.move((Object)key.toString(), file);
        this.fileAccessTracker.markAccessed(resource.getFile());
    }

    public void withTempFile(HashCode key, Consumer<? super File> action) {
        this.persistentCache.withFileLock(() -> this.tempFileStore.withTempFile(key, action));
    }

    @Override
    public void close() {
        this.persistentCache.close();
    }
}

