/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.configuration.inputs;

import com.google.common.primitives.Primitives;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.internal.configuration.inputs.AccessTrackingSet;
import org.gradle.internal.configuration.inputs.AccessTrackingUtils;

public class AccessTrackingProperties
extends Properties {
    private final Properties delegate;
    private final Listener listener;

    public AccessTrackingProperties(Properties delegate, Listener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    @Override
    public Enumeration<?> propertyNames() {
        this.reportAggregatingAccess();
        return this.delegate.propertyNames();
    }

    @Override
    public Set<String> stringPropertyNames() {
        return new AccessTrackingSet<String>(this.delegate.stringPropertyNames(), this.trackingListener());
    }

    @Override
    public int size() {
        this.reportAggregatingAccess();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.reportAggregatingAccess();
        return this.delegate.isEmpty();
    }

    @Override
    public Enumeration<Object> keys() {
        this.reportAggregatingAccess();
        return this.delegate.keys();
    }

    @Override
    public Enumeration<Object> elements() {
        this.reportAggregatingAccess();
        return this.delegate.elements();
    }

    @Override
    public Set<Object> keySet() {
        return new AccessTrackingSet<Object>(this.delegate.keySet(), this.trackingListener());
    }

    @Override
    public Collection<Object> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return new AccessTrackingSet<Map.Entry>(this.delegate.entrySet(), this.entrySetTrackingListener(), x$0 -> new TrackingEntry((Map.Entry<Object, Object>)x$0));
    }

    private void onAccessEntrySetElement(@Nullable Object potentialEntry) {
        Object key;
        Map.Entry<?, ?> entry = AccessTrackingUtils.tryConvertingToEntry(potentialEntry);
        Object v0 = key = entry != null ? entry.getKey() : null;
        if (key != null) {
            this.getAndReportAccess(key);
        }
    }

    @Override
    public void forEach(BiConsumer<? super Object, ? super Object> action) {
        this.reportAggregatingAccess();
        this.delegate.forEach(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
        this.reportAggregatingAccess();
        Properties properties = this.delegate;
        synchronized (properties) {
            this.delegate.replaceAll((BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> {
                Object newValue = function.apply(k, v);
                if (!AccessTrackingProperties.simpleOrRefEquals(newValue, v)) {
                    this.reportChange(k, newValue);
                }
                return newValue;
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putIfAbsent(Object key, Object value) {
        Object oldValue;
        Properties properties = this.delegate;
        synchronized (properties) {
            oldValue = this.delegate.putIfAbsent(key, value);
        }
        this.reportAccess(key, oldValue);
        if (oldValue == null) {
            this.reportChange(key, value);
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        boolean hadValue;
        Object oldValue;
        Properties properties = this.delegate;
        synchronized (properties) {
            oldValue = this.delegate.get(key);
            hadValue = this.delegate.remove(key, value);
        }
        this.reportAccess(key, oldValue);
        if (hadValue) {
            this.reportRemoval(key);
        }
        return hadValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Object key, Object expectedOldValue, Object newValue) {
        boolean changed;
        Object oldValue;
        Properties properties = this.delegate;
        synchronized (properties) {
            oldValue = this.delegate.get(key);
            changed = this.delegate.replace(key, expectedOldValue, newValue);
        }
        this.reportAccess(key, oldValue);
        if (changed) {
            this.reportChange(key, newValue);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object replace(Object key, Object value) {
        Object oldValue;
        Properties properties = this.delegate;
        synchronized (properties) {
            oldValue = this.delegate.replace(key, value);
        }
        this.reportAccess(key, oldValue);
        if (oldValue != null) {
            this.reportChange(key, value);
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object computeIfAbsent(Object key, Function<? super Object, ?> mappingFunction) {
        Object oldValue;
        Object computedValue = null;
        Properties properties = this.delegate;
        synchronized (properties) {
            oldValue = this.delegate.get(key);
            if (oldValue == null) {
                computedValue = this.delegate.computeIfAbsent(key, mappingFunction);
            }
        }
        this.reportAccess(key, oldValue);
        if (computedValue != null) {
            this.reportChange(key, computedValue);
            return computedValue;
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        Object oldValue;
        Object computedValue = null;
        Properties properties = this.delegate;
        synchronized (properties) {
            oldValue = this.delegate.get(key);
            if (oldValue != null) {
                computedValue = this.delegate.computeIfPresent(key, remappingFunction);
            }
        }
        this.reportAccess(key, oldValue);
        if (oldValue != null) {
            if (computedValue != null) {
                this.reportChange(key, computedValue);
            } else {
                this.reportRemoval(key);
            }
        }
        return computedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object compute(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        Object newValue;
        Object oldValue;
        Properties properties = this.delegate;
        synchronized (properties) {
            oldValue = this.delegate.get(key);
            newValue = this.delegate.compute(key, remappingFunction);
        }
        this.reportAccess(key, oldValue);
        if (newValue != null) {
            this.reportChange(key, newValue);
        } else if (oldValue != null) {
            this.reportRemoval(key);
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        Object newValue;
        Object oldValue;
        Properties properties = this.delegate;
        synchronized (properties) {
            oldValue = this.delegate.get(key);
            newValue = this.delegate.merge(key, value, remappingFunction);
        }
        this.reportAccess(key, oldValue);
        if (newValue != null) {
            this.reportChange(key, newValue);
        } else if (oldValue != null) {
            this.reportRemoval(key);
        }
        return newValue;
    }

    @Override
    public boolean contains(Object value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getAndReportAccess(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object put(Object key, Object value) {
        Object oldValue;
        Properties properties = this.delegate;
        synchronized (properties) {
            oldValue = this.delegate.put(key, value);
        }
        this.reportAccess(key, oldValue);
        this.reportChange(key, value);
        return oldValue;
    }

    @Override
    @Nullable
    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object remove(Object key) {
        Object result;
        Properties properties = this.delegate;
        synchronized (properties) {
            result = this.delegate.remove(key);
        }
        this.reportAccess(key, result);
        this.reportRemoval(key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<?, ?> t) {
        Properties properties = this.delegate;
        synchronized (properties) {
            this.delegate.putAll(t);
        }
        t.forEach(this.listener::onChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Properties properties = this.delegate;
        synchronized (properties) {
            this.delegate.clear();
        }
        this.reportClear();
    }

    @Override
    @Nullable
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    @Nullable
    public String getProperty(String key, @Nullable String defaultValue) {
        Object oValue = this.getAndReportAccess(key);
        String value = oValue instanceof String ? (String)oValue : null;
        return value != null ? value : defaultValue;
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        Object value = this.getAndReportAccess(key);
        return value != null ? value : defaultValue;
    }

    @Override
    @Nullable
    public Object get(Object key) {
        return this.getAndReportAccess(key);
    }

    @Override
    public void load(Reader reader) throws IOException {
        this.delegate.load(reader);
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        this.delegate.load(inStream);
    }

    @Override
    @Deprecated
    public void save(OutputStream out, String comments) {
        this.reportAggregatingAccess();
        this.delegate.save(out, comments);
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        this.reportAggregatingAccess();
        this.delegate.store(writer, comments);
    }

    @Override
    public void store(OutputStream out, @Nullable String comments) throws IOException {
        this.reportAggregatingAccess();
        this.delegate.store(out, comments);
    }

    @Override
    public void loadFromXML(InputStream in) throws IOException {
        this.delegate.loadFromXML(in);
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.reportAggregatingAccess();
        this.delegate.storeToXML(os, comment);
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        this.reportAggregatingAccess();
        this.delegate.storeToXML(os, comment, encoding);
    }

    @Override
    public void list(PrintStream out) {
        this.reportAggregatingAccess();
        this.delegate.list(out);
    }

    @Override
    public void list(PrintWriter out) {
        this.reportAggregatingAccess();
        this.delegate.list(out);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        this.reportAggregatingAccess();
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        this.reportAggregatingAccess();
        return this.delegate.hashCode();
    }

    @Nullable
    private Object getAndReportAccess(@Nullable Object key) {
        Object value = this.delegate.get(key);
        assert (key != null);
        this.reportAccess(key, value);
        return value;
    }

    private void reportAccess(Object key, @Nullable Object value) {
        this.listener.onAccess(key, value);
    }

    private void reportAggregatingAccess() {
        this.delegate.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)this::reportAccess));
    }

    private void reportChange(Object key, Object value) {
        this.listener.onChange(key, value);
    }

    private void reportRemoval(Object key) {
        this.listener.onRemove(key);
    }

    private void reportClear() {
        this.listener.onClear();
    }

    private static boolean simpleOrRefEquals(@Nullable Object lhs, @Nullable Object rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        Class<?> lhsClass = lhs.getClass();
        if (lhsClass == rhs.getClass() && AccessTrackingProperties.isSimpleType(lhsClass)) {
            return Objects.equals(lhs, rhs);
        }
        return false;
    }

    private static boolean isSimpleType(Class<?> clazz) {
        return clazz == String.class || Primitives.isWrapperType(clazz);
    }

    private AccessTrackingSet.Listener trackingListener() {
        return new AccessTrackingSet.Listener(){

            @Override
            public void onAccess(@Nullable Object o) {
                AccessTrackingProperties.this.getAndReportAccess(o);
            }

            @Override
            public void onAggregatingAccess() {
                AccessTrackingProperties.this.reportAggregatingAccess();
            }

            @Override
            public void onRemove(@Nullable Object object) {
                AccessTrackingProperties.this.reportRemoval(Objects.requireNonNull(object));
            }

            @Override
            public void onClear() {
                AccessTrackingProperties.this.reportClear();
            }
        };
    }

    private AccessTrackingSet.Listener entrySetTrackingListener() {
        return new AccessTrackingSet.Listener(){

            @Override
            public void onAccess(@Nullable Object o) {
                AccessTrackingProperties.this.onAccessEntrySetElement(o);
            }

            @Override
            public void onAggregatingAccess() {
                AccessTrackingProperties.this.reportAggregatingAccess();
            }

            @Override
            public void onRemove(@Nullable Object potentialEntry) {
                Object removedKey;
                Map.Entry<?, ?> entry = AccessTrackingUtils.tryConvertingToEntry(potentialEntry);
                Object v0 = removedKey = entry != null ? entry.getKey() : null;
                if (removedKey != null) {
                    AccessTrackingProperties.this.reportRemoval(removedKey);
                }
            }

            @Override
            public void onClear() {
                AccessTrackingProperties.this.reportClear();
            }
        };
    }

    private class TrackingEntry
    implements Map.Entry<Object, Object> {
        private final Map.Entry<Object, Object> delegate;

        TrackingEntry(Map.Entry<Object, Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object getKey() {
            return this.delegate.getKey();
        }

        @Override
        public Object getValue() {
            return this.delegate.getValue();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.delegate.getKey(), that.getKey()) && Objects.equals(this.delegate.getValue(), that.getValue());
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public Object setValue(Object value) {
            Object oldValue = this.delegate.setValue(value);
            AccessTrackingProperties.this.listener.onAccess(this.getKey(), oldValue);
            AccessTrackingProperties.this.reportChange(this.getKey(), value);
            return oldValue;
        }
    }

    public static interface Listener {
        public void onAccess(Object var1, @Nullable Object var2);

        public void onChange(Object var1, Object var2);

        public void onRemove(Object var1);

        public void onClear();
    }
}

