/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import javax.annotation.Nullable;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationInvocationException;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.BuildOperationState;
import org.gradle.internal.operations.BuildOperationTimeSupplier;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildOperationRunner
implements BuildOperationRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildOperationRunner.class);
    private static final BuildOperationWorker<RunnableBuildOperation> RUNNABLE_BUILD_OPERATION_WORKER = new BuildOperationWorker<RunnableBuildOperation>(){

        @Override
        public void execute(RunnableBuildOperation buildOperation, BuildOperationContext context) throws Exception {
            buildOperation.run(context);
        }
    };
    private final BuildOperationTimeSupplier clock;
    private final BuildOperationIdFactory buildOperationIdFactory;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final BuildOperationExecutionListenerFactory listenerFactory;

    public DefaultBuildOperationRunner(CurrentBuildOperationRef currentBuildOperationRef, BuildOperationTimeSupplier clock, BuildOperationIdFactory buildOperationIdFactory, BuildOperationExecutionListenerFactory listenerFactory) {
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.clock = clock;
        this.buildOperationIdFactory = buildOperationIdFactory;
        this.listenerFactory = listenerFactory;
    }

    @Override
    public void run(RunnableBuildOperation buildOperation) {
        this.execute(buildOperation, RUNNABLE_BUILD_OPERATION_WORKER, this.getCurrentBuildOperation());
    }

    @Override
    public <T> T call(CallableBuildOperation<T> buildOperation) {
        CallableBuildOperationWorker worker = new CallableBuildOperationWorker();
        this.execute(buildOperation, worker, this.getCurrentBuildOperation());
        return worker.getReturnValue();
    }

    @Override
    public <O extends BuildOperation> void execute(final O buildOperation, final BuildOperationWorker<O> worker, @Nullable BuildOperationState defaultParent) {
        this.execute(buildOperation.description(), defaultParent, new BuildOperationExecution<O>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public O execute(BuildOperationDescriptor descriptor, BuildOperationState operationState, @Nullable BuildOperationState parent, ReadableBuildOperationContext context, BuildOperationExecutionListener listener) {
                try {
                    listener.start(descriptor, operationState);
                    Throwable failure = null;
                    try {
                        worker.execute(buildOperation, context);
                    }
                    catch (Throwable t) {
                        if (context.getFailure() == null) {
                            context.failed(t);
                        }
                        failure = t;
                    }
                    listener.stop(descriptor, operationState, parent, context);
                    if (failure != null) {
                        throw DefaultBuildOperationRunner.throwAsBuildOperationInvocationException(failure);
                    }
                    BuildOperation buildOperation2 = buildOperation;
                    return buildOperation2;
                }
                finally {
                    listener.close(descriptor, operationState);
                }
            }
        });
    }

    @Override
    public BuildOperationContext start(BuildOperationDescriptor.Builder descriptorBuilder) {
        return this.execute(descriptorBuilder, this.getCurrentBuildOperation(), new BuildOperationExecution<BuildOperationContext>(){

            @Override
            public BuildOperationContext execute(final BuildOperationDescriptor descriptor, final BuildOperationState operationState, final @Nullable BuildOperationState parent, final ReadableBuildOperationContext context, final BuildOperationExecutionListener listener) {
                listener.start(descriptor, operationState);
                return new BuildOperationContext(){
                    private boolean finished;

                    @Override
                    public void failed(@Nullable Throwable failure) {
                        this.assertNotFinished();
                        context.failed(failure);
                        this.finish();
                    }

                    @Override
                    public void setResult(@Nullable Object result) {
                        this.assertNotFinished();
                        context.setResult(result);
                        this.finish();
                    }

                    @Override
                    public void setStatus(String status) {
                        this.assertNotFinished();
                        context.setStatus(status);
                    }

                    @Override
                    public void progress(String status) {
                        this.assertNotFinished();
                        context.progress(status);
                    }

                    @Override
                    public void progress(long progress, long total, String units, String status) {
                        this.assertNotFinished();
                        context.progress(progress, total, units, status);
                    }

                    private void finish() {
                        this.finished = true;
                        try {
                            listener.stop(descriptor, operationState, parent, context);
                        }
                        finally {
                            listener.close(descriptor, operationState);
                        }
                    }

                    private void assertNotFinished() {
                        if (this.finished) {
                            throw new IllegalStateException(String.format("Operation (%s) has already finished.", descriptor));
                        }
                    }
                };
            }
        });
    }

    private <O> O execute(BuildOperationDescriptor.Builder descriptorBuilder, @Nullable BuildOperationState defaultParent, BuildOperationExecution<O> execution) {
        BuildOperationState descriptorParent = (BuildOperationState)descriptorBuilder.getParentState();
        BuildOperationState parent = descriptorParent == null ? defaultParent : descriptorParent;
        OperationIdentifier id = new OperationIdentifier(this.buildOperationIdFactory.nextId());
        BuildOperationDescriptor descriptor = descriptorBuilder.build(id, parent == null ? null : parent.getDescription().getId());
        DefaultBuildOperationRunner.assertParentRunning("Cannot start operation (%s) as parent operation (%s) has already completed.", descriptor, parent);
        BuildOperationState operationState = new BuildOperationState(descriptor, this.clock.getCurrentTime());
        BuildOperationTrackingListener listener = new BuildOperationTrackingListener(this.currentBuildOperationRef, this.listenerFactory.createListener());
        DefaultBuildOperationContext context = new DefaultBuildOperationContext(descriptor, listener);
        return execution.execute(descriptor, operationState, parent, context, listener);
    }

    private static void assertParentRunning(String message, BuildOperationDescriptor child, @Nullable BuildOperationState parent) {
        if (parent != null && !parent.isRunning()) {
            String parentName = parent.getDescription().getDisplayName();
            throw new IllegalStateException(String.format(message, child.getDisplayName(), parentName));
        }
    }

    @Nullable
    private BuildOperationState getCurrentBuildOperation() {
        return (BuildOperationState)this.currentBuildOperationRef.get();
    }

    private static RuntimeException throwAsBuildOperationInvocationException(Throwable t) {
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new BuildOperationInvocationException(t.getMessage(), t);
    }

    private static class DefaultBuildOperationContext
    implements ReadableBuildOperationContext {
        private final BuildOperationDescriptor descriptor;
        private final BuildOperationExecutionListener listener;
        private Throwable failure;
        private Object result;
        private String status;

        public DefaultBuildOperationContext(BuildOperationDescriptor descriptor, BuildOperationExecutionListener listener) {
            this.descriptor = descriptor;
            this.listener = listener;
        }

        @Override
        @Nullable
        public Object getResult() {
            return this.result;
        }

        @Override
        public void setResult(@Nullable Object result) {
            this.result = result;
        }

        @Override
        @Nullable
        public Throwable getFailure() {
            return this.failure;
        }

        @Override
        public void failed(@Nullable Throwable t) {
            this.failure = t;
        }

        @Override
        @Nullable
        public String getStatus() {
            return this.status;
        }

        @Override
        public void setStatus(@Nullable String status) {
            this.status = status;
        }

        @Override
        public void progress(String status) {
            this.listener.progress(this.descriptor, status);
        }

        @Override
        public void progress(long progress, long total, String units, String status) {
            this.listener.progress(this.descriptor, progress, total, units, status);
        }
    }

    public static interface BuildOperationExecutionListenerFactory {
        public BuildOperationExecutionListener createListener();
    }

    public static interface BuildOperationExecutionListener {
        public static final BuildOperationExecutionListener NO_OP = new BuildOperationExecutionListener(){

            @Override
            public void start(BuildOperationDescriptor descriptor, BuildOperationState operationState) {
            }

            @Override
            public void progress(BuildOperationDescriptor descriptor, String status) {
            }

            @Override
            public void progress(BuildOperationDescriptor descriptor, long progress, long total, String units, String status) {
            }

            @Override
            public void stop(BuildOperationDescriptor descriptor, BuildOperationState operationState, @Nullable BuildOperationState parent, ReadableBuildOperationContext context) {
            }

            @Override
            public void close(BuildOperationDescriptor descriptor, BuildOperationState operationState) {
            }
        };

        public void start(BuildOperationDescriptor var1, BuildOperationState var2);

        public void progress(BuildOperationDescriptor var1, String var2);

        public void progress(BuildOperationDescriptor var1, long var2, long var4, String var6, String var7);

        public void stop(BuildOperationDescriptor var1, BuildOperationState var2, @Nullable BuildOperationState var3, ReadableBuildOperationContext var4);

        public void close(BuildOperationDescriptor var1, BuildOperationState var2);
    }

    public static interface ReadableBuildOperationContext
    extends BuildOperationContext {
        @Nullable
        public Object getResult();

        @Override
        public void setResult(@Nullable Object var1);

        @Nullable
        public Throwable getFailure();

        @Nullable
        public String getStatus();

        @Override
        public void setStatus(@Nullable String var1);
    }

    private static class BuildOperationTrackingListener
    implements BuildOperationExecutionListener {
        private final CurrentBuildOperationRef currentBuildOperationRef;
        private final BuildOperationExecutionListener delegate;
        private BuildOperationState originalCurrentBuildOperation;

        private BuildOperationTrackingListener(CurrentBuildOperationRef currentBuildOperationRef, BuildOperationExecutionListener delegate) {
            this.currentBuildOperationRef = currentBuildOperationRef;
            this.delegate = delegate;
        }

        @Override
        public void start(BuildOperationDescriptor descriptor, BuildOperationState operationState) {
            this.originalCurrentBuildOperation = (BuildOperationState)this.currentBuildOperationRef.get();
            this.currentBuildOperationRef.set(operationState);
            operationState.setRunning(true);
            LOGGER.debug("Build operation '{}' started", (Object)descriptor.getDisplayName());
            this.delegate.start(descriptor, operationState);
        }

        @Override
        public void progress(BuildOperationDescriptor descriptor, String status) {
            this.delegate.progress(descriptor, status);
        }

        @Override
        public void progress(BuildOperationDescriptor descriptor, long progress, long total, String units, String status) {
            this.delegate.progress(descriptor, progress, total, units, status);
        }

        @Override
        public void stop(BuildOperationDescriptor descriptor, BuildOperationState operationState, @Nullable BuildOperationState parent, ReadableBuildOperationContext context) {
            this.delegate.stop(descriptor, operationState, parent, context);
            LOGGER.debug("Completing Build operation '{}'", (Object)descriptor.getDisplayName());
            DefaultBuildOperationRunner.assertParentRunning("Parent operation (%2$s) completed before this operation (%1$s).", descriptor, parent);
        }

        @Override
        public void close(BuildOperationDescriptor descriptor, BuildOperationState operationState) {
            this.delegate.close(descriptor, operationState);
            this.currentBuildOperationRef.set(this.originalCurrentBuildOperation);
            operationState.setRunning(false);
            LOGGER.debug("Build operation '{}' completed", (Object)descriptor.getDisplayName());
        }
    }

    private static class CallableBuildOperationWorker<T>
    implements BuildOperationWorker<CallableBuildOperation<T>> {
        private T returnValue;

        private CallableBuildOperationWorker() {
        }

        @Override
        public void execute(CallableBuildOperation<T> buildOperation, BuildOperationContext context) throws Exception {
            this.returnValue = buildOperation.call(context);
        }

        public T getReturnValue() {
            return this.returnValue;
        }
    }

    private static interface BuildOperationExecution<O> {
        public O execute(BuildOperationDescriptor var1, BuildOperationState var2, @Nullable BuildOperationState var3, ReadableBuildOperationContext var4, BuildOperationExecutionListener var5);
    }
}

