/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IActionDelegate;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.Messages;

public class CopyLinkAction
extends Action
implements IActionDelegate {
    public static final String ID = "org.rssowl.ui.CopyLinkAction";
    private ISelection fSelection;
    private boolean fIgnoreActiveSelection;

    public CopyLinkAction() {
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setText(Messages.CopyLinkAction_COPY_LINK);
        this.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/copy_link.gif"));
        this.setDisabledImageDescriptor(OwlUI.getImageDescriptor("icons/dlcl16/copy_link.gif"));
    }

    public void setIgnoreActiveSelection(boolean ignoreActiveSelection) {
        this.fIgnoreActiveSelection = ignoreActiveSelection;
    }

    public boolean isEnabled() {
        ISelection selection = this.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)selection).toList();
            for (Object entry : list) {
                if (!(entry instanceof IBookMark) && !(entry instanceof INews) && !(entry instanceof IAttachment)) continue;
                return true;
            }
        }
        return false;
    }

    public void run() {
        ISelection selection;
        ISelection iSelection = selection = this.fIgnoreActiveSelection && this.fSelection != null ? this.fSelection : this.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            StringBuilder str = new StringBuilder();
            if (!structuredSelection.isEmpty()) {
                List list = structuredSelection.toList();
                int i = 0;
                for (Object element : list) {
                    IAttachment attachment;
                    Object link;
                    if (element instanceof IBookMark) {
                        str.append(i > 0 ? "\n" : "").append(URIUtils.toHTTP((String)((IBookMark)element).getFeedLinkReference().getLinkAsText()));
                        ++i;
                        continue;
                    }
                    if (element instanceof INews) {
                        INews news = (INews)element;
                        link = CoreUtils.getLink((INews)news);
                        if (link == null) continue;
                        str.append(i > 0 ? "\n" : "").append((String)link);
                        ++i;
                        continue;
                    }
                    if (!(element instanceof IAttachment) || (link = (attachment = (IAttachment)element).getLink()) == null) continue;
                    str.append(i > 0 ? "\n" : "").append(link);
                    ++i;
                }
            }
            if (str.length() > 0) {
                OwlUI.getClipboard().setContents(new Object[]{str.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
    }

    private ISelection getSelection() {
        IStructuredSelection activeSelection = OwlUI.getActiveSelection();
        if (activeSelection != null && !activeSelection.isEmpty() && activeSelection instanceof IStructuredSelection) {
            return activeSelection;
        }
        return this.fSelection;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }
}

