/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.rssowl.core.persist.INews;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.editors.browser.EmbeddedWebBrowser;
import org.rssowl.ui.internal.editors.browser.WebBrowserContext;

public class OpenInBrowserAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public static final String ID = "org.rssowl.ui.OpenInBrowserAction";
    private IStructuredSelection fSelection;
    private WebBrowserContext fContext;
    private boolean fForceOpenInBackground;

    public OpenInBrowserAction() {
        this((IStructuredSelection)StructuredSelection.EMPTY);
    }

    public OpenInBrowserAction(IStructuredSelection selection) {
        this(selection, null);
    }

    public void setForceOpenInBackground(boolean forceOpenInBackground) {
        this.fForceOpenInBackground = forceOpenInBackground;
    }

    public OpenInBrowserAction(IStructuredSelection selection, WebBrowserContext context) {
        this.fSelection = selection;
        this.fContext = context;
        this.setText(Messages.OpenInBrowserAction_OPEN_IN_BROWSER);
        this.setId(ID);
        this.setActionDefinitionId(ID);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        try {
            this.internalRun();
        }
        catch (URISyntaxException e) {
            Activator.getDefault().getLog().log(Activator.getDefault().createErrorStatus(e.getMessage(), e));
        }
    }

    private void internalRun() throws URISyntaxException {
        String title = Messages.OpenInBrowserAction_LOADING;
        List selection = this.fSelection.toList();
        for (Object object : selection) {
            URI link = null;
            if (object instanceof INews) {
                INews news = (INews)object;
                title = CoreUtils.getHeadline((INews)news, (boolean)true);
                String linkStr = CoreUtils.getLink((INews)news);
                if (StringUtils.isSet((String)linkStr)) {
                    link = new URI(linkStr);
                }
            } else if (object instanceof URI) {
                link = (URI)object;
            } else if (object instanceof String) {
                link = new URI(URIUtils.fastEncode((String)((String)object)));
            }
            if (link == null || !link.isAbsolute()) continue;
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                IWebBrowser browser = browserSupport.createBrowser("org.rssowl.ui.WebBrowser");
                if (browser instanceof EmbeddedWebBrowser) {
                    if (this.fContext != null) {
                        ((EmbeddedWebBrowser)browser).setContext(this.fContext);
                    } else {
                        ((EmbeddedWebBrowser)browser).setContext(WebBrowserContext.createFrom(title));
                    }
                    try {
                        ((EmbeddedWebBrowser)browser).openURL(link.toURL(), this.fForceOpenInBackground);
                    }
                    catch (MalformedURLException malformedURLException) {
                        ((EmbeddedWebBrowser)browser).openURL(link, this.fForceOpenInBackground);
                    }
                    continue;
                }
                browser.openURL(link.toURL());
            }
            catch (PartInitException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            catch (MalformedURLException e) {
                Activator.getDefault().getLog().log(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }
}

