/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.ICategoryDAO;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.ContentAssistAdapter;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignLabelsDialog
extends Dialog {
    private Text fLabelsInput;
    private final Set<INews> fNews;
    private Set<ILabel> fExistingLabels;
    private ResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private HashSet<String> fExistingLabelNames;
    private Label fInfoImg;
    private Label fInfoText;

    public AssignLabelsDialog(Shell parentShell, Set<INews> news) {
        super(parentShell);
        this.fNews = news;
        this.fExistingLabels = CoreUtils.loadSortedLabels();
        this.fExistingLabelNames = new HashSet(this.fExistingLabels.size());
        for (ILabel label : this.fExistingLabels) {
            this.fExistingLabelNames.add(label.getName().toLowerCase());
        }
    }

    protected void okPressed() {
        String labelsValue = this.fLabelsInput.getText();
        String[] labelsValueSplit = labelsValue.split(",");
        for (INews news : this.fNews) {
            Set newsLabels = news.getLabels();
            for (ILabel newsLabel : newsLabels) {
                news.removeLabel(newsLabel);
            }
        }
        if (labelsValueSplit.length > 0) {
            String[] stringArray = labelsValueSplit;
            int n = labelsValueSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String labelValue = stringArray[n2];
                ILabel label = null;
                if ((labelValue = labelValue.trim()).length() != 0) {
                    for (ILabel existingLabel : this.fExistingLabels) {
                        if (!existingLabel.getName().toLowerCase().equals(labelValue.toLowerCase())) continue;
                        label = existingLabel;
                        break;
                    }
                    if (label == null) {
                        ILabel newLabel = Owl.getModelFactory().createLabel(null, labelValue);
                        newLabel.setColor(OwlUI.toString(new RGB(0, 0, 0)));
                        newLabel.setOrder(this.fExistingLabels.size());
                        DynamicDAO.save((IPersistable)newLabel);
                        this.fExistingLabels.add(newLabel);
                        label = newLabel;
                    }
                    for (INews news : this.fNews) {
                        news.addLabel(label);
                    }
                }
                ++n2;
            }
        }
        Controller.getDefault().getSavedSearchService().forceQuickUpdate();
        DynamicDAO.saveAll(this.fNews);
        super.okPressed();
    }

    public boolean close() {
        this.fResources.dispose();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(2, 10, 10, 5, 6, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.AssignLabelsDialog_LABELS);
        this.fLabelsInput = new Text(composite, 2052);
        this.fLabelsInput.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fLabelsInput.setText(this.getLabelsValue());
        this.fLabelsInput.setSelection(this.fLabelsInput.getText().length());
        this.fLabelsInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AssignLabelsDialog.this.onModifyName();
            }
        });
        ContentAssistAdapter adapter = new ContentAssistAdapter((Control)this.fLabelsInput, ',', true);
        final ArrayList<String> labelNames = new ArrayList<String>(this.fExistingLabels.size());
        for (ILabel label : this.fExistingLabels) {
            labelNames.add(label.getName());
        }
        final Pair<SimpleContentProposalProvider, ContentProposalAdapter> pair = OwlUI.hookAutoComplete((Control)this.fLabelsInput, adapter, labelNames, true, false);
        ((ContentProposalAdapter)pair.getSecond()).setProposalAcceptanceStyle(1);
        JobRunner.runDelayedInBackgroundThread(new Runnable(){

            public void run() {
                if (!AssignLabelsDialog.this.fLabelsInput.isDisposed()) {
                    TreeSet<String> values = new TreeSet<String>(new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.compareToIgnoreCase(o2);
                        }
                    });
                    Set categoryNames = ((ICategoryDAO)DynamicDAO.getDAO(ICategoryDAO.class)).loadAllNames();
                    categoryNames = StringUtils.replaceAll((Set)categoryNames, (String)",", (String)" ");
                    values.addAll(categoryNames);
                    values.addAll(labelNames);
                    if (!AssignLabelsDialog.this.fLabelsInput.isDisposed()) {
                        OwlUI.applyAutoCompleteProposals(values, (SimpleContentProposalProvider)pair.getFirst(), (ContentProposalAdapter)pair.getSecond(), false);
                    }
                }
            }
        });
        Composite infoContainer = new Composite(composite, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        ((GridLayout)infoContainer.getLayout()).marginTop = 15;
        this.fInfoImg = new Label(infoContainer, 0);
        this.fInfoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fInfoText = new Label(infoContainer, 64);
        this.fInfoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.showInfo();
        AssignLabelsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private String getLabelsValue() {
        TreeSet<ILabel> labels = new TreeSet<ILabel>(new Comparator<ILabel>(){

            @Override
            public int compare(ILabel l1, ILabel l2) {
                if (l1.equals(l2)) {
                    return 0;
                }
                return l1.getOrder() < l2.getOrder() ? -1 : 1;
            }
        });
        for (INews news : this.fNews) {
            Set newsLabels = news.getLabels();
            labels.addAll(newsLabels);
        }
        StringBuilder str = new StringBuilder();
        for (ILabel label : labels) {
            str.append(label.getName()).append(", ");
        }
        return str.toString();
    }

    private void showWarning(String msg) {
        this.fInfoText.setText(msg);
        this.fInfoImg.setImage(OwlUI.getImage(this.fResources, "icons/obj16/warning.gif"));
        this.fInfoImg.getParent().layout();
    }

    private void showInfo() {
        this.fInfoText.setText(Messages.AssignLabelsDialog_SEPARATE_LABELS);
        this.fInfoImg.setImage(OwlUI.getImage(this.fResources, "icons/obj16/info.gif"));
        this.fInfoImg.getParent().layout();
    }

    private void onModifyName() {
        int newLabelCounter = 0;
        String labelsValue = this.fLabelsInput.getText();
        String[] labelsValueSplit = labelsValue.split(",");
        HashSet<String> handledNewLabels = new HashSet<String>(1);
        String[] stringArray = labelsValueSplit;
        int n = labelsValueSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String labelValue = stringArray[n2];
            if ((labelValue = labelValue.trim().toLowerCase()).length() > 0 && !handledNewLabels.contains(labelValue) && !this.fExistingLabelNames.contains(labelValue)) {
                ++newLabelCounter;
                handledNewLabels.add(labelValue.toLowerCase());
            }
            ++n2;
        }
        if (newLabelCounter == 0) {
            this.showInfo();
        } else if (newLabelCounter == 1) {
            this.showWarning(Messages.AssignLabelsDialog_NEW_LABEL_CREATE);
        } else {
            this.showWarning(NLS.bind((String)Messages.AssignLabelsDialog_N_LABEL_CREATE, (Object)newLabelCounter));
        }
    }

    protected Control createButtonBar(Composite parent) {
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        return super.createButtonBar(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AssignLabelsDialog_ASSIGN_LABELS);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        int minWidth = this.convertHorizontalDLUsToPixels(320);
        int minHeight = shell.computeSize((int)minWidth, (int)-1).y;
        Point requiredSize = shell.computeSize(-1, -1);
        shell.setSize(Math.max(minWidth, requiredSize.x), Math.max(minHeight, requiredSize.y));
        LayoutUtils.positionShell(shell);
    }
}

