/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IFolderDAO;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.FolderAdapter;
import org.rssowl.core.persist.event.FolderEvent;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.ReparentInfo;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.DeleteTypesAction;
import org.rssowl.ui.internal.actions.EntityPropertyDialogAction;
import org.rssowl.ui.internal.actions.NewFolderAction;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageSetsDialog
extends TitleAreaDialog {
    private static ManageSetsDialog fgVisibleInstance;
    private LocalResourceManager fResources;
    private TableViewer fViewer;
    private Label fStatusLabel;
    private Button fEditButton;
    private Button fDeleteButton;
    private IFolder fSelectedSet;
    private FolderAdapter fFolderListener;

    public ManageSetsDialog(Shell parentShell, IFolder selectedSet) {
        super(parentShell);
        this.fSelectedSet = selectedSet;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    public static ManageSetsDialog getVisibleInstance() {
        return fgVisibleInstance;
    }

    public int open() {
        fgVisibleInstance = this;
        this.registerListeners();
        return super.open();
    }

    private void registerListeners() {
        this.fFolderListener = new FolderAdapter(){

            public void entitiesAdded(final Set<FolderEvent> events) {
                JobRunner.runInUIThread((Widget)ManageSetsDialog.this.fViewer.getControl(), new Runnable(){

                    public void run() {
                        for (FolderEvent folderEvent : events) {
                            IFolder folder = folderEvent.getEntity();
                            if (folder.getParent() != null) continue;
                            ManageSetsDialog.this.fViewer.add((Object)folder);
                            ManageSetsDialog.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)folder));
                        }
                    }
                });
            }
        };
        DynamicDAO.addEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
    }

    public boolean close() {
        this.unregisterListeners();
        fgVisibleInstance = null;
        this.fResources.dispose();
        return super.close();
    }

    private void unregisterListeners() {
        DynamicDAO.removeEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ManageSetsDialog_MANAGE_SETS);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ManageSetsDialog_SETS);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/bkmrk_set_title.gif"));
        this.showInfo();
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 10));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fViewer = new TableViewer(composite, 2048);
        this.fViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, false));
        ((GridData)this.fViewer.getTable().getLayoutData()).heightHint = this.fViewer.getTable().getItemHeight() * 7;
        this.fViewer.getTable().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        this.initDragAndDrop();
        this.fViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return CoreUtils.loadRootFolders().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IFolder)element).getName();
            }

            public Image getImage(Object element) {
                return OwlUI.getImage((ResourceManager)ManageSetsDialog.this.fResources, OwlUI.BOOKMARK_SET);
            }
        });
        this.fViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IFolder folder1 = (IFolder)e1;
                IFolder folder2 = (IFolder)e2;
                return folder1.getId().compareTo(folder2.getId());
            }
        });
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ManageSetsDialog.this.onEdit();
            }
        });
        this.fViewer.setInput((Object)this);
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        buttonContainer.setLayoutData((Object)new GridData(1, 4, false, false));
        Button addButton = new Button(buttonContainer, 8);
        addButton.setText(Messages.ManageSetsDialog_NEW);
        ManageSetsDialog.applyDialogFont((Control)addButton);
        this.setButtonLayoutData(addButton);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageSetsDialog.this.onAdd();
            }
        });
        this.fEditButton = new Button(buttonContainer, 8);
        this.fEditButton.setText(Messages.ManageSetsDialog_EDIT);
        ManageSetsDialog.applyDialogFont((Control)this.fEditButton);
        this.setButtonLayoutData(this.fEditButton);
        this.fEditButton.setEnabled(false);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageSetsDialog.this.onEdit();
            }
        });
        this.fDeleteButton = new Button(buttonContainer, 8);
        this.fDeleteButton.setText(Messages.ManageSetsDialog_DELETE);
        ManageSetsDialog.applyDialogFont((Control)this.fDeleteButton);
        this.setButtonLayoutData(this.fDeleteButton);
        ((GridData)this.fDeleteButton.getLayoutData()).verticalAlignment = 0x1000008;
        ((GridData)this.fDeleteButton.getLayoutData()).grabExcessVerticalSpace = true;
        this.fDeleteButton.setEnabled(false);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageSetsDialog.this.onDelete();
            }
        });
        Composite statusContainer = new Composite(composite, 0);
        statusContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 5, 0));
        statusContainer.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this.fStatusLabel = new Label(statusContainer, 0);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ManageSetsDialog.this.onSelectionChange();
            }
        });
        Collection rootFolders = ((IFolderDAO)DynamicDAO.getDAO(IFolderDAO.class)).loadRoots();
        for (IFolder rootFolder : rootFolders) {
            if (!rootFolder.equals(this.fSelectedSet)) continue;
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)rootFolder));
            break;
        }
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        ManageSetsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void initDragAndDrop() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        ViewerDropAdapter dropAdapter = new ViewerDropAdapter((Viewer)this.fViewer){

            public boolean validateDrop(final Object target, int operation, TransferData transferType) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                    final boolean[] result = new boolean[1];
                    SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                        public void run() throws Exception {
                            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                            if (selection instanceof IStructuredSelection) {
                                List draggedObjects = ((IStructuredSelection)selection).toList();
                                result[0] = ManageSetsDialog.this.isValidDrop(draggedObjects, target);
                            }
                        }
                    });
                    return result[0];
                }
                return false;
            }

            public boolean performDrop(final Object data) {
                if (data instanceof IStructuredSelection) {
                    SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                        public void run() throws Exception {
                            IStructuredSelection selection = (IStructuredSelection)data;
                            List draggedObjects = selection.toList();
                            ManageSetsDialog.this.perfromDrop(draggedObjects, this.getCurrentTarget());
                        }
                    });
                    return true;
                }
                return false;
            }
        };
        dropAdapter.setFeedbackEnabled(false);
        this.fViewer.addDropSupport(ops, transfers, (DropTargetListener)dropAdapter);
    }

    private boolean isValidDrop(List<?> draggedObjects, Object dropTarget) {
        if (!(dropTarget instanceof IFolder)) {
            return false;
        }
        IFolder dropFolder = (IFolder)dropTarget;
        for (Object draggedObject : draggedObjects) {
            IMark draggedMark;
            IFolder draggedFolder;
            if (!(draggedObject instanceof IFolder ? CoreUtils.hasChildRelation((IFolder)dropFolder, (IEntity)(draggedFolder = (IFolder)draggedObject)) : draggedObject instanceof IMark && CoreUtils.hasChildRelation((IFolder)dropFolder, (IEntity)(draggedMark = (IMark)draggedObject)))) continue;
            return false;
        }
        return true;
    }

    private void perfromDrop(List<?> draggedObjects, Object dropTarget) {
        if (!(dropTarget instanceof IFolder) || draggedObjects.isEmpty()) {
            return;
        }
        IFolder dropFolder = (IFolder)dropTarget;
        ArrayList<ReparentInfo> reparenting = new ArrayList<ReparentInfo>(draggedObjects.size());
        for (Object object : draggedObjects) {
            if (!(object instanceof IFolder) && !(object instanceof IMark)) continue;
            IFolderChild draggedFolderChild = (IFolderChild)object;
            reparenting.add(ReparentInfo.create((Object)draggedFolderChild, (Object)dropFolder, null, null));
        }
        CoreUtils.reparentWithProperties(reparenting);
        this.fViewer.setSelection(this.fViewer.getSelection());
    }

    private void onAdd() {
        this.showInfo();
        NewFolderAction newFolderAction = new NewFolderAction(this.getShell(), null, null);
        newFolderAction.setRootMode(true);
        newFolderAction.run(null);
        this.fViewer.refresh();
        Table table = this.fViewer.getTable();
        Object lastItem = table.getItem(table.getItemCount() - 1).getData();
        this.fViewer.setSelection((ISelection)new StructuredSelection(lastItem));
        table.setFocus();
    }

    private void onEdit() {
        this.showInfo();
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (!selection.isEmpty()) {
            new EntityPropertyDialogAction((IShellProvider)this, (ISelectionProvider)this.fViewer).run();
            this.fViewer.refresh();
        }
    }

    private void onDelete() {
        this.showInfo();
        if (this.fViewer.getTable().getItemCount() == 1) {
            this.setErrorMessage(Messages.ManageSetsDialog_DELETE_LAST_SET_ERROR);
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (!selection.isEmpty()) {
            DeleteTypesAction deleteAction = new DeleteTypesAction(this.getShell(), selection);
            deleteAction.run();
            if (deleteAction.isConfirmed()) {
                this.fViewer.remove(selection.getFirstElement());
            }
        }
    }

    private void onSelectionChange() {
        this.updateStatusLabel();
        ISelection selection = this.fViewer.getSelection();
        this.fEditButton.setEnabled(!selection.isEmpty());
        this.fDeleteButton.setEnabled(!selection.isEmpty());
    }

    protected int getShellStyle() {
        int style = 0x860 | ManageSetsDialog.getDefaultOrientation();
        return style;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        int minWidth = this.convertHorizontalDLUsToPixels(320);
        int minHeight = shell.computeSize((int)minWidth, (int)-1).y;
        Point requiredSize = shell.computeSize(-1, -1);
        shell.setSize(Math.max(minWidth, requiredSize.x), Math.max(minHeight, requiredSize.y));
        LayoutUtils.positionShell(shell);
    }

    private void showInfo() {
        this.setErrorMessage(null);
        this.setMessage(Messages.ManageSetsDialog_SELECT_SET);
    }

    private void updateStatusLabel() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.isEmpty()) {
            this.fStatusLabel.setText("");
        } else {
            IFolder bookmarkSet = (IFolder)selection.getFirstElement();
            int[] counter = new int[4];
            this.count(bookmarkSet, counter);
            StringBuilder itemBuilder = new StringBuilder();
            if (counter[0] > 0) {
                itemBuilder.append(counter[0] == 1 ? Messages.ManageSetsDialog_1_FOLDER : NLS.bind((String)Messages.ManageSetsDialog_N_FOLDERS, (Object)counter[0])).append(", ");
            }
            if (counter[1] > 0) {
                itemBuilder.append(counter[1] == 1 ? Messages.ManageSetsDialog_1_BOOKMARK : NLS.bind((String)Messages.ManageSetsDialog_N_BOOKMARKS, (Object)counter[1])).append(", ");
            }
            if (counter[2] > 0) {
                itemBuilder.append(counter[2] == 1 ? Messages.ManageSetsDialog_1_SEARCH : NLS.bind((String)Messages.ManageSetsDialog_N_SEARCHES, (Object)counter[2])).append(", ");
            }
            if (counter[3] > 0) {
                itemBuilder.append(counter[3] == 1 ? Messages.ManageSetsDialog_1_BIN : NLS.bind((String)Messages.ManageSetsDialog_N_BINS, (Object)counter[3])).append(", ");
            }
            if (counter[0] == 0 && counter[1] == 0 && counter[2] == 0 && counter[3] == 0) {
                itemBuilder = new StringBuilder(Messages.ManageSetsDialog_EMPTY_SET);
            } else if (itemBuilder.length() > 0) {
                itemBuilder.delete(itemBuilder.length() - 2, itemBuilder.length());
            }
            this.fStatusLabel.setText(NLS.bind((String)Messages.ManageSetsDialog_SET_CONTENT, (Object)bookmarkSet.getName(), (Object)itemBuilder.toString()));
        }
    }

    private void count(IFolder folder, int[] counter) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            if (mark instanceof IBookMark) {
                counter[1] = counter[1] + 1;
                continue;
            }
            if (mark instanceof ISearchMark) {
                counter[2] = counter[2] + 1;
                continue;
            }
            if (!(mark instanceof INewsBin)) continue;
            counter[3] = counter[3] + 1;
        }
        List childs = folder.getFolders();
        counter[0] = counter[0] + childs.size();
        for (IFolder child : childs) {
            this.count(child, counter);
        }
    }
}

