/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.rssowl.core.INewsAction;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.ISearchFilterDAO;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.IModelSearch;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.SearchHit;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.ConfirmDialog;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.dialogs.NewsFilterDialog;
import org.rssowl.ui.internal.filter.NewsActionDescriptor;
import org.rssowl.ui.internal.filter.NewsActionPresentationManager;
import org.rssowl.ui.internal.util.CColumnLayoutData;
import org.rssowl.ui.internal.util.CTable;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsFiltersListDialog
extends TitleAreaDialog {
    private static final int FILTER_CHUNK_SIZE = 50;
    private static NewsFiltersListDialog fgVisibleInstance;
    private static final String SETTINGS_SECTION = "org.rssowl.ui.internal.dialogs.NewsFiltersListDialog";
    private NewsActionPresentationManager fNewsActionPresentationManager = NewsActionPresentationManager.getInstance();
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private CheckboxTableViewer fViewer;
    private Button fEditButton;
    private Button fDeleteButton;
    private Button fMoveDownButton;
    private Button fMoveUpButton;
    private Image fFilterIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.FILTER);
    private ISearchFilterDAO fSearchFilterDao = (ISearchFilterDAO)DynamicDAO.getDAO(ISearchFilterDAO.class);
    private Button fApplySelectedFilter;
    private ISearchFilter fSelectedFilter;

    public NewsFiltersListDialog(Shell parentShell) {
        super(parentShell);
    }

    public static NewsFiltersListDialog getVisibleInstance() {
        return fgVisibleInstance;
    }

    public int open() {
        fgVisibleInstance = this;
        return super.open();
    }

    public boolean close() {
        boolean res = super.close();
        fgVisibleInstance = null;
        this.fResources.dispose();
        return res;
    }

    protected Control createDialogArea(Composite parent) {
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        this.setTitle(Messages.NewsFiltersListDialog_NEWS_FILTERS);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/filter_wiz.png"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 10));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite tableContainer = new Composite(composite, 0);
        tableContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        tableContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        CTable cTable = new CTable(tableContainer, 67618);
        this.fViewer = new CheckboxTableViewer(cTable.getControl());
        this.fViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer.getTable().setHeaderVisible(true);
        ((GridData)this.fViewer.getTable().getLayoutData()).heightHint = this.fViewer.getTable().getItemHeight() * 15;
        this.fViewer.getTable().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        TableColumn nameCol = new TableColumn(this.fViewer.getTable(), 0);
        CColumnLayoutData data = new CColumnLayoutData(CColumnLayoutData.Size.FILL, 100);
        cTable.manageColumn(nameCol, data, Messages.NewsFiltersListDialog_NAME, null, null, false, false);
        this.fViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return NewsFiltersListDialog.this.fSearchFilterDao.loadAll().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ISearchFilter filter = (ISearchFilter)cell.getElement();
                Display display = NewsFiltersListDialog.this.fViewer.getControl().getDisplay();
                if (filter.isEnabled()) {
                    cell.setText(filter.getName());
                } else {
                    cell.setText(NLS.bind((String)Messages.NewsFiltersListDialog_FILTER_DISABLED, (Object)filter.getName()));
                }
                cell.setImage(NewsFiltersListDialog.this.fFilterIcon);
                if (!OwlUI.isHighContrast()) {
                    cell.setForeground(filter.isEnabled() ? display.getSystemColor(2) : display.getSystemColor(16));
                }
            }
        });
        this.fViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ISearchFilter filter1 = (ISearchFilter)e1;
                ISearchFilter filter2 = (ISearchFilter)e2;
                return filter1.getOrder() < filter2.getOrder() ? -1 : 1;
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                NewsFiltersListDialog.this.fEditButton.setEnabled(!selection.isEmpty());
                NewsFiltersListDialog.this.fDeleteButton.setEnabled(!selection.isEmpty());
                NewsFiltersListDialog.this.fApplySelectedFilter.setEnabled(!selection.isEmpty() && selection.size() == 1);
                NewsFiltersListDialog.this.updateMoveEnablement();
            }
        });
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NewsFiltersListDialog.this.onEdit();
            }
        });
        this.fViewer.setInput((Object)this);
        this.updateCheckedState();
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ISearchFilter filter = (ISearchFilter)event.getElement();
                filter.setEnabled(event.getChecked());
                NewsFiltersListDialog.this.fSearchFilterDao.save((IPersistable)filter);
                NewsFiltersListDialog.this.fViewer.update((Object)filter, null);
                NewsFiltersListDialog.this.updateTitle();
            }
        });
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        buttonContainer.setLayoutData((Object)new GridData(1, 4, false, false));
        Button addButton = new Button(buttonContainer, 8);
        addButton.setText(Messages.NewsFiltersListDialog_NEW);
        addButton.setFocus();
        NewsFiltersListDialog.applyDialogFont((Control)addButton);
        this.setButtonLayoutData(addButton);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFiltersListDialog.this.onAdd();
            }
        });
        this.fEditButton = new Button(buttonContainer, 8);
        this.fEditButton.setText(Messages.NewsFiltersListDialog_EDIT);
        NewsFiltersListDialog.applyDialogFont((Control)this.fEditButton);
        this.setButtonLayoutData(this.fEditButton);
        this.fEditButton.setEnabled(false);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFiltersListDialog.this.onEdit();
            }
        });
        this.fDeleteButton = new Button(buttonContainer, 8);
        this.fDeleteButton.setText(Messages.NewsFiltersListDialog_DELETE);
        NewsFiltersListDialog.applyDialogFont((Control)this.fDeleteButton);
        this.setButtonLayoutData(this.fDeleteButton);
        this.fDeleteButton.setEnabled(false);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFiltersListDialog.this.onDelete();
            }
        });
        this.fMoveUpButton = new Button(buttonContainer, 8);
        this.fMoveUpButton.setText(Messages.NewsFiltersListDialog_MOVE_UP);
        this.fMoveUpButton.setEnabled(false);
        NewsFiltersListDialog.applyDialogFont((Control)this.fMoveUpButton);
        this.setButtonLayoutData(this.fMoveUpButton);
        ((GridData)this.fMoveUpButton.getLayoutData()).verticalIndent = 10;
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFiltersListDialog.this.onMove(true);
            }
        });
        this.fMoveDownButton = new Button(buttonContainer, 8);
        this.fMoveDownButton.setText(Messages.NewsFiltersListDialog_MOVE_DOWN);
        this.fMoveDownButton.setEnabled(false);
        NewsFiltersListDialog.applyDialogFont((Control)this.fMoveDownButton);
        this.setButtonLayoutData(this.fMoveDownButton);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFiltersListDialog.this.onMove(false);
            }
        });
        Composite buttonBar = new Composite(composite, 0);
        buttonBar.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        buttonBar.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fApplySelectedFilter = new Button(buttonBar, 8);
        this.fApplySelectedFilter.setText(Messages.NewsFiltersListDialog_RUN_SELECTED_FILTER);
        this.fApplySelectedFilter.setEnabled(false);
        NewsFiltersListDialog.applyDialogFont((Control)this.fApplySelectedFilter);
        this.setButtonLayoutData(this.fApplySelectedFilter);
        ((GridData)this.fApplySelectedFilter.getLayoutData()).grabExcessHorizontalSpace = false;
        ((GridData)this.fApplySelectedFilter.getLayoutData()).horizontalAlignment = 1;
        this.fApplySelectedFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFiltersListDialog.this.onApplySelectedFilter();
            }
        });
        Button closeButton = new Button(buttonBar, 8);
        closeButton.setText(Messages.NewsFiltersListDialog_CLOSE);
        NewsFiltersListDialog.applyDialogFont((Control)closeButton);
        this.setButtonLayoutData(closeButton);
        ((GridData)closeButton.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)closeButton.getLayoutData()).horizontalAlignment = 0x1000008;
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFiltersListDialog.this.close();
            }
        });
        this.updateTitle();
        if (this.fSelectedFilter != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.fSelectedFilter), true);
        }
        NewsFiltersListDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void onApplySelectedFilter() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (!selection.isEmpty()) {
            ISearchFilter filter = (ISearchFilter)selection.getFirstElement();
            List actions = filter.getActions();
            ArrayList<IFilterAction> forcableActions = new ArrayList<IFilterAction>(actions.size());
            for (IFilterAction action : actions) {
                NewsActionDescriptor newsActionDescriptor = this.fNewsActionPresentationManager.getNewsActionDescriptor(action.getActionId());
                if (newsActionDescriptor == null || !newsActionDescriptor.isForcable()) continue;
                forcableActions.add(action);
            }
            if (forcableActions.isEmpty()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)NLS.bind((String)Messages.NewsFiltersListDialog_RUN_SELECTED_FILTER_N, (Object)filter.getName()), (String)NLS.bind((String)Messages.NewsFiltersListDialog_NO_ACTIONS_TO_RUN, (Object)filter.getName()));
                return;
            }
            IModelSearch search = Owl.getPersistenceService().getModelSearch();
            List<SearchHit<NewsReference>> targetNews = null;
            Set visibleStates = INews.State.getVisible();
            if (filter.getSearch() == null) {
                ISearchField stateField = Owl.getModelFactory().createSearchField(14, INews.class.getName());
                ISearchCondition stateCondition = Owl.getModelFactory().createSearchCondition(stateField, SearchSpecifier.IS, EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED, INews.State.READ));
                targetNews = search.searchNews(Collections.singleton(stateCondition), true);
            } else {
                List result = search.searchNews(filter.getSearch());
                targetNews = new ArrayList(result.size());
                for (SearchHit resultItem : result) {
                    INews.State state = (INews.State)resultItem.getData((Object)14);
                    if (!visibleStates.contains(state)) continue;
                    targetNews.add(resultItem);
                }
            }
            if (targetNews.isEmpty()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)NLS.bind((String)Messages.NewsFiltersListDialog_RUN_SELECTED_FILTER_N, (Object)filter.getName()), (String)NLS.bind((String)Messages.NewsFiltersListDialog_NO_FILTER_MATCH, (Object)filter.getName()));
                return;
            }
            boolean multipleActions = forcableActions.size() > 1;
            String title = NLS.bind((String)Messages.NewsFiltersListDialog_RUN_SELECTED_FILTER_N, (Object)filter.getName());
            StringBuilder message = new StringBuilder();
            if (multipleActions) {
                message.append(NLS.bind((String)Messages.NewsFiltersListDialog_PERFORM_ACTIONS, (Object)targetNews.size())).append("\n");
            } else {
                message.append(NLS.bind((String)Messages.NewsFiltersListDialog_PERFORM_ACTION, (Object)targetNews.size())).append("\n");
            }
            for (IFilterAction action : forcableActions) {
                String label;
                NewsActionDescriptor newsActionDescriptor = this.fNewsActionPresentationManager.getNewsActionDescriptor(action.getActionId());
                String string = label = newsActionDescriptor.getNewsAction() != null ? newsActionDescriptor.getNewsAction().getLabel(action.getData()) : null;
                if (StringUtils.isSet(label)) {
                    message.append("\n").append(NLS.bind((String)Messages.NewsFiltersListDialog_FILTER_LIST_ELEMENT, (Object)label));
                    continue;
                }
                message.append("\n").append(NLS.bind((String)Messages.NewsFiltersListDialog_FILTER_LIST_ELEMENT, (Object)newsActionDescriptor.getName()));
            }
            message.append("\n\n").append(Messages.NewsFiltersListDialog_CONFIRM);
            ConfirmDialog dialog = new ConfirmDialog(this.getShell(), title, Messages.NewsFiltersListDialog_NO_UNDO, message.toString(), IDialogConstants.OK_LABEL, null){

                protected String getTitleImage() {
                    return "icons/wizban/filter_wiz.png";
                }

                public void setTitle(String newTitle) {
                    super.setTitle(Messages.NewsFiltersListDialog_RUN_SELECTED_FILTER_TITLE);
                }
            };
            if (dialog.open() == 0) {
                this.applyFilter(targetNews, filter);
            }
        }
    }

    private void applyFilter(final List<SearchHit<NewsReference>> news, final ISearchFilter filter) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                List chunks = CoreUtils.toChunks((List)news, (int)50);
                monitor.beginTask(NLS.bind((String)Messages.NewsFiltersListDialog_WAIT_FILTER_APPLIED, (Object)filter.getName()), chunks.size());
                if (monitor.isCanceled()) {
                    return;
                }
                int counter = 0;
                for (List chunk : chunks) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.subTask(NLS.bind((String)Messages.NewsFiltersListDialog_FILTERED_N_OF_M_NEWS, (Object)(counter * 50), (Object)news.size()));
                    ArrayList<INews> newsItemsToFilter = new ArrayList<INews>(50);
                    for (SearchHit chunkItem : chunk) {
                        INews newsItemToFilter = ((NewsReference)chunkItem.getResult()).resolve();
                        if (newsItemToFilter != null && newsItemToFilter.isVisible()) {
                            newsItemsToFilter.add(newsItemToFilter);
                            continue;
                        }
                        CoreUtils.reportIndexIssue();
                    }
                    NewsFiltersListDialog.this.applyFilterOnChunks(newsItemsToFilter, filter);
                    monitor.worked(1);
                    ++counter;
                }
                monitor.done();
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        dialog.setBlockOnOpen(false);
        dialog.setCancelable(true);
        dialog.setOpenOnRun(true);
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    private void applyFilterOnChunks(final List<INews> news, ISearchFilter filter) {
        Collection actions = CoreUtils.getActions((ISearchFilter)filter);
        final HashSet entitiesToSave = new HashSet(news.size());
        final HashMap replacements = new HashMap();
        for (final IFilterAction action : actions) {
            INewsAction newsAction;
            NewsActionDescriptor newsActionDescriptor = this.fNewsActionPresentationManager.getNewsActionDescriptor(action.getActionId());
            if (newsActionDescriptor == null || !newsActionDescriptor.isForcable() || (newsAction = newsActionDescriptor.getNewsAction()) == null) continue;
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }

                public void run() throws Exception {
                    List changedEntities = newsAction.run(news, replacements, action.getData());
                    entitiesToSave.addAll(changedEntities);
                }
            });
        }
        if (!entitiesToSave.isEmpty()) {
            DynamicDAO.saveAll(entitiesToSave);
        }
    }

    private void updateTitle() {
        TableItem[] items;
        ISearchFilter problematicFilter = null;
        Table table = this.fViewer.getTable();
        TableItem[] tableItemArray = items = table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            TableItem item = tableItemArray[n2];
            ISearchFilter filter = (ISearchFilter)item.getData();
            if (filter.getSearch() == null && filter.isEnabled() && (index = table.indexOf(item)) < table.getItemCount() - 1) {
                problematicFilter = filter;
                break;
            }
            ++n2;
        }
        if (problematicFilter != null) {
            this.setMessage(NLS.bind((String)Messages.NewsFiltersListDialog_FILTER_MATCHES_ALL_NEWS, (Object)problematicFilter.getName()), 2);
        } else {
            this.setMessage(Messages.NewsFiltersListDialog_ENABLED_FILTERS, 1);
        }
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    private void updateMoveEnablement() {
        boolean enableMoveUp = true;
        boolean enableMoveDown = true;
        int[] selectionIndices = this.fViewer.getTable().getSelectionIndices();
        if (selectionIndices.length == 1) {
            enableMoveUp = selectionIndices[0] != 0;
            enableMoveDown = selectionIndices[0] != this.fViewer.getTable().getItemCount() - 1;
        } else {
            enableMoveUp = false;
            enableMoveDown = false;
        }
        this.fMoveUpButton.setEnabled(enableMoveUp);
        this.fMoveDownButton.setEnabled(enableMoveDown);
    }

    private void onMove(boolean up) {
        TableItem[] items = this.fViewer.getTable().getItems();
        ArrayList<ISearchFilter> sortedFilters = new ArrayList<ISearchFilter>(items.length);
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            sortedFilters.add((ISearchFilter)item.getData());
            ++n2;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        ISearchFilter selectedFilter = (ISearchFilter)selection.getFirstElement();
        int selectedFilterOrder = selectedFilter.getOrder();
        ISearchFilter otherFilter = null;
        int index = sortedFilters.indexOf(selectedFilter);
        if (up && index > 0) {
            otherFilter = (ISearchFilter)sortedFilters.get(index - 1);
            selectedFilter.setOrder(otherFilter.getOrder());
            otherFilter.setOrder(selectedFilterOrder);
        } else if (!up && index < sortedFilters.size() - 1) {
            otherFilter = (ISearchFilter)sortedFilters.get(index + 1);
            selectedFilter.setOrder(otherFilter.getOrder());
            otherFilter.setOrder(selectedFilterOrder);
        }
        this.fSearchFilterDao.saveAll(Arrays.asList(selectedFilter, otherFilter));
        this.fViewer.refresh();
        this.fViewer.getTable().showSelection();
        this.updateCheckedState();
        this.updateMoveEnablement();
        this.updateTitle();
    }

    private void updateCheckedState() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.fViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            ISearchFilter filter = (ISearchFilter)item.getData();
            this.fViewer.setChecked((Object)filter, filter.isEnabled());
            ++n2;
        }
    }

    private void onAdd() {
        NewsFilterDialog dialog = new NewsFilterDialog(this.getShell());
        Table table = this.fViewer.getTable();
        dialog.setFilterPosition(table.getItemCount());
        if (dialog.open() == 0) {
            this.fViewer.refresh();
            this.updateCheckedState();
            this.fViewer.setSelection((ISelection)new StructuredSelection(table.getItem(table.getItemCount() - 1).getData()));
            this.fViewer.getTable().setFocus();
            this.updateTitle();
        }
    }

    private void onEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        ISearchFilter filter = (ISearchFilter)selection.getFirstElement();
        NewsFilterDialog dialog = new NewsFilterDialog(this.getShell(), filter);
        if (dialog.open() == 0) {
            this.fViewer.refresh(true);
            this.fViewer.getTable().setFocus();
            this.updateTitle();
        }
    }

    private void onDelete() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        List selectedFilters = selection.toList();
        ConfirmDialog dialog = new ConfirmDialog(this.getShell(), Messages.NewsFiltersListDialog_CONFIRM_DELETE, Messages.NewsFiltersListDialog_NO_UNDO, this.getMessage(selectedFilters), null);
        if (dialog.open() == 0) {
            ArrayList<ISearchFilter> filtersToDelete = new ArrayList<ISearchFilter>(selectedFilters.size());
            for (ISearchFilter filter : selectedFilters) {
                filtersToDelete.add(filter);
            }
            this.fSearchFilterDao.deleteAll(filtersToDelete);
            this.fViewer.remove(selection.toArray());
            this.fixOrderAfterDelete();
            this.updateTitle();
        }
    }

    private void fixOrderAfterDelete() {
        ArrayList<ISearchFilter> filtersToSave = new ArrayList<ISearchFilter>();
        TableItem[] items = this.fViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            ISearchFilter filter = (ISearchFilter)item.getData();
            filter.setOrder(i);
            filtersToSave.add(filter);
            ++i;
        }
        DynamicDAO.saveAll(filtersToSave);
    }

    private String getMessage(List<?> elements) {
        StringBuilder message = new StringBuilder();
        if (elements.size() == 1) {
            ISearchFilter filter = (ISearchFilter)elements.get(0);
            message.append(NLS.bind((String)Messages.NewsFiltersListDialog_CONFIRM_DELETE_FILTER_N, (Object)filter.getName()));
        } else {
            message.append(Messages.NewsFiltersListDialog_CONFIRM_DELETE_FILTERS);
        }
        return message.toString();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.NewsFiltersListDialog_NEWS_FILTERS);
    }

    public void setSelection(ISearchFilter filter) {
        this.fSelectedFilter = filter;
        if (this.fViewer != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.fSelectedFilter), true);
        }
    }

    public void refresh() {
        if (this.fViewer != null) {
            this.fViewer.refresh();
            this.updateCheckedState();
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected int getShellStyle() {
        int style = 0xCF0 | NewsFiltersListDialog.getDefaultOrientation();
        return style;
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_SECTION);
        if (section != null) {
            return section;
        }
        return settings.addNewSection(SETTINGS_SECTION);
    }
}

