/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.cleanup;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpGroup;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpTask;
import org.rssowl.ui.internal.dialogs.cleanup.Messages;

public class BookMarkTask
extends CleanUpTask {
    private String fLabel;
    private ImageDescriptor fImage;
    private final IBookMark fMark;

    BookMarkTask(CleanUpGroup group, IBookMark mark) {
        super(group);
        Assert.isNotNull((Object)mark);
        this.fMark = mark;
        this.init();
    }

    private void init() {
        this.fLabel = NLS.bind((String)Messages.BookMarkTask_DELETE_N, (Object)this.fMark.getName());
        this.fImage = OwlUI.getFavicon(this.fMark);
        if (this.fImage == null) {
            this.fImage = OwlUI.BOOKMARK;
        }
    }

    public IBookMark getMark() {
        return this.fMark;
    }

    ImageDescriptor getImage() {
        return this.fImage;
    }

    String getLabel() {
        return this.fLabel;
    }
}

