/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.cleanup;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.IAbortable;
import org.rssowl.core.connection.ICredentials;
import org.rssowl.core.connection.IProtocolHandler;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.ILabelDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.IModelSearch;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.SearchHit;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.dialogs.cleanup.BookMarkTask;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpGroup;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpIndexTask;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpOperations;
import org.rssowl.ui.internal.dialogs.cleanup.DefragDatabaseTask;
import org.rssowl.ui.internal.dialogs.cleanup.DeleteOrphanedSearchMarkTask;
import org.rssowl.ui.internal.dialogs.cleanup.DisableOrphanedNewsFiltersTask;
import org.rssowl.ui.internal.dialogs.cleanup.Messages;
import org.rssowl.ui.internal.dialogs.cleanup.NewsTask;
import org.rssowl.ui.internal.dialogs.cleanup.OptimizeSearchTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanUpModel {
    private static final long DAY = 86400000L;
    private final List<CleanUpGroup> fTasks;
    private final CleanUpOperations fOps;
    private final Collection<IBookMark> fBookmarks;
    private final IModelFactory fFactory;
    private final IModelSearch fModelSearch;
    private final ISearchField fLocationField;
    private final String fNewsName;
    private final INewsDAO fNewsDao;
    private final IPreferenceScope fPreferences;

    public CleanUpModel(CleanUpOperations operations, Collection<IBookMark> bookmarks) {
        this.fOps = operations;
        this.fBookmarks = bookmarks;
        this.fTasks = new ArrayList<CleanUpGroup>();
        this.fFactory = Owl.getModelFactory();
        this.fModelSearch = Owl.getPersistenceService().getModelSearch();
        this.fNewsDao = (INewsDAO)DynamicDAO.getDAO(INewsDAO.class);
        this.fPreferences = Owl.getPreferenceService().getGlobalScope();
        String newsName = INews.class.getName();
        this.fLocationField = this.fFactory.createSearchField(19, newsName);
        this.fNewsName = INews.class.getName();
    }

    public List<CleanUpGroup> getTasks() {
        return this.fTasks;
    }

    private ISearchCondition getLocationCondition(IBookMark mark) {
        Long[][] value = new Long[3][1];
        value[1][0] = mark.getId();
        return this.fFactory.createSearchCondition(this.fLocationField, SearchSpecifier.IS, (Object)value);
    }

    public void generate(IProgressMonitor monitor) {
        List<SearchHit<NewsReference>> results;
        HashSet<NewsReference> newsOfMarkToDelete;
        CleanUpGroup group;
        HashSet<IBookMark> bookmarksToDelete = new HashSet<IBookMark>();
        HashMap<IBookMark, HashSet<NewsReference>> newsToDelete = new HashMap<IBookMark, HashSet<NewsReference>>();
        CleanUpGroup recommendedTasks = new CleanUpGroup(Messages.CleanUpModel_RECOMMENDED_OPS);
        if (this.fPreferences.getBoolean(DefaultPreferences.CLEAN_UP_INDEX)) {
            recommendedTasks.addTask(new CleanUpIndexTask(recommendedTasks));
        }
        recommendedTasks.addTask(new DefragDatabaseTask(recommendedTasks));
        recommendedTasks.addTask(new OptimizeSearchTask(recommendedTasks));
        this.fTasks.add(recommendedTasks);
        ArrayList<ISearchMark> orphanedSearches = new ArrayList<ISearchMark>();
        Collection searches = DynamicDAO.loadAll(ISearchMark.class);
        for (ISearchMark search : searches) {
            if (!CoreUtils.isOrphaned((ISearch)search)) continue;
            orphanedSearches.add(search);
        }
        if (!orphanedSearches.isEmpty()) {
            recommendedTasks.addTask(new DeleteOrphanedSearchMarkTask(recommendedTasks, orphanedSearches));
        }
        ArrayList<ISearchFilter> orphanedFilters = new ArrayList<ISearchFilter>();
        Collection filters = DynamicDAO.loadAll(ISearchFilter.class);
        for (ISearchFilter filter : filters) {
            if (!filter.isEnabled() || !CoreUtils.isOrphaned((ISearchFilter)filter)) continue;
            orphanedFilters.add(filter);
        }
        if (!orphanedFilters.isEmpty()) {
            recommendedTasks.addTask(new DisableOrphanedNewsFiltersTask(recommendedTasks, orphanedFilters));
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (this.fOps.deleteFeedByLastVisit()) {
            group = new CleanUpGroup(NLS.bind((String)Messages.CleanUpModel_DELETE_BY_VISIT, (Object)this.fOps.getLastVisitDays()));
            int days = this.fOps.getLastVisitDays();
            long maxLastVisitDate = DateUtils.getToday().getTimeInMillis() - (long)days * 86400000L;
            for (IBookMark mark : this.fBookmarks) {
                Date date = mark.getLastVisitDate();
                if (date == null) {
                    date = mark.getCreationDate();
                }
                if (date != null && date.getTime() >= maxLastVisitDate) continue;
                bookmarksToDelete.add(mark);
                group.addTask(new BookMarkTask(group, mark));
            }
            if (!group.isEmpty()) {
                this.fTasks.add(group);
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (this.fOps.deleteFeedByLastUpdate()) {
            group = new CleanUpGroup(NLS.bind((String)Messages.CleanUpModel_DELETE_BY_UPDATE, (Object)this.fOps.getLastUpdateDays()));
            int days = this.fOps.getLastUpdateDays();
            long maxLastUpdateDate = DateUtils.getToday().getTimeInMillis() - (long)days * 86400000L;
            for (IBookMark mark : this.fBookmarks) {
                if (bookmarksToDelete.contains(mark)) continue;
                Date mostRecentNewsDate = mark.getMostRecentNewsDate();
                Date creationDate = mark.getCreationDate();
                boolean deleteBookMark = false;
                if (mostRecentNewsDate != null && mostRecentNewsDate.getTime() < maxLastUpdateDate) {
                    deleteBookMark = true;
                } else if (mostRecentNewsDate == null && creationDate.getTime() < maxLastUpdateDate) {
                    deleteBookMark = true;
                }
                if (!deleteBookMark) continue;
                bookmarksToDelete.add(mark);
                group.addTask(new BookMarkTask(group, mark));
            }
            if (!group.isEmpty()) {
                this.fTasks.add(group);
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (this.fOps.deleteFeedsByConError()) {
            group = new CleanUpGroup(Messages.CleanUpModel_DELETE_CON_ERROR);
            for (IBookMark mark : this.fBookmarks) {
                if (bookmarksToDelete.contains(mark) || !mark.isErrorLoading()) continue;
                bookmarksToDelete.add(mark);
                group.addTask(new BookMarkTask(group, mark));
            }
            if (!group.isEmpty()) {
                this.fTasks.add(group);
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (this.fOps.deleteFeedsByDuplicates()) {
            group = new CleanUpGroup(Messages.CleanUpModel_DELETE_DUPLICATES);
            for (IBookMark currentBookMark : this.fBookmarks) {
                if (bookmarksToDelete.contains(currentBookMark)) continue;
                TreeSet<IBookMark> sortedBookmarkGroup = new TreeSet<IBookMark>(new Comparator<IBookMark>(){

                    @Override
                    public int compare(IBookMark o1, IBookMark o2) {
                        if (o1.equals(o2)) {
                            return 0;
                        }
                        return o1.getCreationDate() == null ? -1 : o1.getCreationDate().compareTo(o2.getCreationDate());
                    }
                });
                for (IBookMark bookMark : this.fBookmarks) {
                    if (bookmarksToDelete.contains(bookMark) || !bookMark.getFeedLinkReference().equals((Object)currentBookMark.getFeedLinkReference())) continue;
                    sortedBookmarkGroup.add(bookMark);
                }
                if (sortedBookmarkGroup.size() <= 1) continue;
                Iterator iterator = sortedBookmarkGroup.iterator();
                iterator.next();
                while (iterator.hasNext()) {
                    IBookMark bookmark = (IBookMark)iterator.next();
                    bookmarksToDelete.add(bookmark);
                    group.addTask(new BookMarkTask(group, bookmark));
                }
            }
            if (!group.isEmpty()) {
                this.fTasks.add(group);
            }
        }
        if (this.fOps.deleteFeedsBySynchronization()) {
            group = new CleanUpGroup(Messages.CleanUpModel_DELETE_UNSUBSCRIBED_FEEDS);
            Set<String> googleReaderFeeds = this.loadGoogleReaderFeeds(monitor);
            if (googleReaderFeeds != null) {
                for (IBookMark mark : this.fBookmarks) {
                    String feedLink;
                    if (bookmarksToDelete.contains(mark) || !SyncUtils.isSynchronized((IBookMark)mark) || googleReaderFeeds.contains(feedLink = URIUtils.toHTTP((String)mark.getFeedLinkReference().getLinkAsText()))) continue;
                    bookmarksToDelete.add(mark);
                    group.addTask(new BookMarkTask(group, mark));
                }
            }
            if (!group.isEmpty()) {
                this.fTasks.add(group);
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        EnumSet<INews.State> states = this.fOps.keepUnreadNews() ? EnumSet.of(INews.State.READ) : EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED, INews.State.READ);
        ISearchField stateField = this.fFactory.createSearchField(14, this.fNewsName);
        ISearchCondition stateCondition = this.fFactory.createSearchCondition(stateField, SearchSpecifier.IS, states);
        ISearchField stickyField = this.fFactory.createSearchField(13, this.fNewsName);
        ISearchCondition stickyCondition = this.fFactory.createSearchCondition(stickyField, SearchSpecifier.IS_NOT, (Object)true);
        Collection labels = ((ILabelDAO)DynamicDAO.getDAO(ILabelDAO.class)).loadAll();
        ISearchField labelField = this.fFactory.createSearchField(15, this.fNewsName);
        ArrayList<ISearchCondition> labelConditions = new ArrayList<ISearchCondition>(labels.size());
        for (ILabel label : labels) {
            labelConditions.add(this.fFactory.createSearchCondition(labelField, SearchSpecifier.IS_NOT, (Object)label.getName()));
        }
        if (this.fOps.deleteNewsByCount()) {
            CleanUpGroup group2 = new CleanUpGroup(NLS.bind((String)Messages.CleanUpModel_DELETE_BY_COUNT, (Object)this.fOps.getMaxNewsCountPerFeed()));
            for (IBookMark mark : this.fBookmarks) {
                List<SearchHit<NewsReference>> results2;
                if (monitor.isCanceled()) {
                    return;
                }
                if (bookmarksToDelete.contains(mark)) continue;
                ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(3);
                conditions.add(this.getLocationCondition(mark));
                conditions.add(stickyCondition);
                conditions.add(stateCondition);
                if (this.fOps.keepLabeledNews()) {
                    conditions.addAll(labelConditions);
                }
                if ((results2 = this.filterInvalidResults(this.fModelSearch.searchNews(conditions, true), monitor)).size() <= this.fOps.getMaxNewsCountPerFeed()) continue;
                int toDeleteValue = results2.size() - this.fOps.getMaxNewsCountPerFeed();
                ArrayList<INews> resolvedNews = new ArrayList<INews>(results2.size());
                for (SearchHit<NewsReference> result : results2) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    INews resolvedNewsItem = ((NewsReference)result.getResult()).resolve();
                    if (resolvedNewsItem != null && resolvedNewsItem.isVisible()) {
                        resolvedNews.add(resolvedNewsItem);
                        continue;
                    }
                    CoreUtils.reportIndexIssue();
                }
                if (monitor.isCanceled()) {
                    return;
                }
                Collections.sort(resolvedNews, new Comparator<INews>(){

                    @Override
                    public int compare(INews news1, INews news2) {
                        return DateUtils.getRecentDate((INews)news1).compareTo(DateUtils.getRecentDate((INews)news2));
                    }
                });
                if (monitor.isCanceled()) {
                    return;
                }
                newsOfMarkToDelete = new HashSet();
                int i = 0;
                while (i < resolvedNews.size() && i < toDeleteValue) {
                    newsOfMarkToDelete.add(new NewsReference(((INews)resolvedNews.get(i)).getId().longValue()));
                    ++i;
                }
                if (newsOfMarkToDelete.isEmpty() || monitor.isCanceled()) continue;
                newsToDelete.put(mark, newsOfMarkToDelete);
                group2.addTask(new NewsTask(group2, mark, newsOfMarkToDelete));
            }
            if (!group2.isEmpty() && !monitor.isCanceled()) {
                this.fTasks.add(group2);
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (this.fOps.deleteNewsByAge()) {
            CleanUpGroup group3 = new CleanUpGroup(NLS.bind((String)Messages.CleanUpModel_DELETE_BY_AGE, (Object)this.fOps.getMaxNewsAge()));
            ISearchField ageInDaysField = this.fFactory.createSearchField(18, this.fNewsName);
            ISearchCondition ageCond = this.fFactory.createSearchCondition(ageInDaysField, SearchSpecifier.IS_GREATER_THAN, (Object)this.fOps.getMaxNewsAge());
            for (IBookMark mark : this.fBookmarks) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (bookmarksToDelete.contains(mark)) continue;
                ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(4);
                conditions.add(this.getLocationCondition(mark));
                conditions.add(ageCond);
                conditions.add(stateCondition);
                conditions.add(stickyCondition);
                if (this.fOps.keepLabeledNews()) {
                    conditions.addAll(labelConditions);
                }
                results = this.filterInvalidResults(this.fModelSearch.searchNews(conditions, true), monitor);
                newsOfMarkToDelete = new HashSet();
                for (SearchHit<NewsReference> result : results) {
                    newsOfMarkToDelete.add((NewsReference)result.getResult());
                }
                if (newsOfMarkToDelete.isEmpty()) continue;
                Collection existingNewsOfMarkToDelete = (Collection)newsToDelete.get(mark);
                if (monitor.isCanceled()) {
                    return;
                }
                if (existingNewsOfMarkToDelete == null) {
                    newsToDelete.put(mark, newsOfMarkToDelete);
                    group3.addTask(new NewsTask(group3, mark, newsOfMarkToDelete));
                    continue;
                }
                newsOfMarkToDelete.removeAll(existingNewsOfMarkToDelete);
                if (newsOfMarkToDelete.isEmpty()) continue;
                existingNewsOfMarkToDelete.addAll(newsOfMarkToDelete);
                group3.addTask(new NewsTask(group3, mark, newsOfMarkToDelete));
            }
            if (!group3.isEmpty() && !monitor.isCanceled()) {
                this.fTasks.add(group3);
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (this.fOps.deleteReadNews()) {
            CleanUpGroup group4 = new CleanUpGroup(Messages.CleanUpModel_READ_NEWS);
            EnumSet<INews.State> readState = EnumSet.of(INews.State.READ);
            ISearchCondition stateCond = this.fFactory.createSearchCondition(stateField, SearchSpecifier.IS, readState);
            for (IBookMark mark : this.fBookmarks) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (bookmarksToDelete.contains(mark)) continue;
                ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(3);
                conditions.add(this.getLocationCondition(mark));
                conditions.add(stateCond);
                conditions.add(stickyCondition);
                if (this.fOps.keepLabeledNews()) {
                    conditions.addAll(labelConditions);
                }
                results = this.filterInvalidResults(this.fModelSearch.searchNews(conditions, true), monitor);
                newsOfMarkToDelete = new HashSet<NewsReference>();
                for (SearchHit<NewsReference> result : results) {
                    newsOfMarkToDelete.add((NewsReference)result.getResult());
                }
                if (newsOfMarkToDelete.isEmpty() || monitor.isCanceled()) continue;
                Collection existingNewsOfMarkToDelete = (Collection)newsToDelete.get(mark);
                if (existingNewsOfMarkToDelete == null) {
                    newsToDelete.put(mark, newsOfMarkToDelete);
                    group4.addTask(new NewsTask(group4, mark, newsOfMarkToDelete));
                    continue;
                }
                newsOfMarkToDelete.removeAll(existingNewsOfMarkToDelete);
                if (newsOfMarkToDelete.isEmpty()) continue;
                existingNewsOfMarkToDelete.addAll(newsOfMarkToDelete);
                group4.addTask(new NewsTask(group4, mark, newsOfMarkToDelete));
            }
            if (!group4.isEmpty() && !monitor.isCanceled()) {
                this.fTasks.add(group4);
            }
        }
    }

    private Set<String> loadGoogleReaderFeeds(IProgressMonitor monitor) {
        InputStream inS = null;
        boolean isCanceled = false;
        try {
            ICredentials credentials = Owl.getConnectionService().getAuthCredentials(URI.create("https://www.google.com/accounts/ClientLogin"), null);
            if (credentials == null) {
                return null;
            }
            String authToken = SyncUtils.getGoogleAuthToken((String)credentials.getUsername(), (String)credentials.getPassword(), (boolean)false, (IProgressMonitor)monitor);
            if (authToken == null) {
                authToken = SyncUtils.getGoogleAuthToken((String)credentials.getUsername(), (String)credentials.getPassword(), (boolean)true, (IProgressMonitor)monitor);
            }
            if (monitor.isCanceled() || !StringUtils.isSet((String)authToken)) {
                return null;
            }
            URI opmlImportUri = URI.create("https://www.google.com/reader/subscriptions/export");
            IProtocolHandler handler = Owl.getConnectionService().getHandler(opmlImportUri);
            HashMap properties = new HashMap();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", SyncUtils.getGoogleAuthorizationHeader((String)authToken));
            properties.put("HEADERS", headers);
            inS = handler.openStream(opmlImportUri, monitor, properties);
            if (monitor.isCanceled()) {
                isCanceled = true;
                return null;
            }
            List types = Owl.getInterpreter().importFrom(inS);
            HashSet<IBookMark> bookmarks = new HashSet<IBookMark>();
            for (IEntity type : types) {
                if (type instanceof IBookMark) {
                    bookmarks.add((IBookMark)type);
                    continue;
                }
                if (!(type instanceof IFolder)) continue;
                CoreUtils.fillBookMarks(bookmarks, Collections.singleton((IFolder)type));
            }
            HashSet<String> feeds = new HashSet<String>();
            for (IBookMark bookmark : bookmarks) {
                feeds.add(bookmark.getFeedLinkReference().getLinkAsText());
            }
            feeds.add(URIUtils.toHTTP((String)"reader://notes"));
            feeds.add(URIUtils.toHTTP((String)"reader://shared"));
            feeds.add(URIUtils.toHTTP((String)"reader://recommended"));
            HashSet<String> hashSet = feeds;
            return hashSet;
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        finally {
            if (inS != null) {
                try {
                    if (isCanceled && inS instanceof IAbortable) {
                        ((IAbortable)inS).abort();
                    } else {
                        inS.close();
                    }
                }
                catch (IOException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    private List<SearchHit<NewsReference>> filterInvalidResults(List<SearchHit<NewsReference>> results, IProgressMonitor monitor) {
        ArrayList<SearchHit<NewsReference>> validResults = new ArrayList<SearchHit<NewsReference>>(results.size());
        for (SearchHit<NewsReference> searchHit : results) {
            if (monitor.isCanceled()) break;
            if (this.fNewsDao.exists(((NewsReference)searchHit.getResult()).getId())) {
                validResults.add(searchHit);
                continue;
            }
            CoreUtils.reportIndexIssue();
        }
        return validResults;
    }
}

