/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.welcome;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.welcome.Messages;
import org.rssowl.ui.internal.util.BrowserUtils;
import org.rssowl.ui.internal.util.LayoutUtils;

public class TutorialPage
extends WizardPage {
    private static final char BOLD = '#';
    private static final char BLUE = '%';
    private final Chapter fChapter;

    TutorialPage(Chapter chapter) {
        super(TutorialPage.getTitle(chapter), TutorialPage.getTitle(chapter), null);
        this.fChapter = chapter;
        this.setMessage(TutorialPage.getMessage(chapter));
    }

    private static String getTitle(Chapter chapter) {
        switch (chapter) {
            case INTRO: {
                return Messages.TutorialPage_INTRO;
            }
            case LAYOUT: {
                return Messages.TutorialPage_OVERVIEW;
            }
            case NEWS: {
                return Messages.TutorialPage_NEWS;
            }
            case SAVEDSEARCH: {
                return Messages.TutorialPage_SAVED_SEARCHES;
            }
            case NEWSBIN: {
                return Messages.TutorialPage_NEWS_BINS;
            }
            case NEWSFILTER: {
                return Messages.TutorialPage_NEWS_FILTERS;
            }
            case NOTIFIER: {
                return Messages.TutorialPage_NOTIFICATIONS;
            }
            case SHARING: {
                return Messages.TutorialPage_SHARING;
            }
            case IMPORT_EXPORT: {
                return Messages.TutorialPage_IMPORT_EXPORT;
            }
            case SYNCHRONIZATION: {
                return Messages.TutorialPage_SYNCHRONIZATION;
            }
            case PREFERENCES: {
                return Messages.TutorialPage_PREFERENCES;
            }
            case TIPS: {
                return Messages.TutorialPage_TIPS_AND_TRICKS;
            }
            case FINISH: {
                return Messages.TutorialPage_FINISH;
            }
        }
        return null;
    }

    private static String getMessage(Chapter chapter) {
        switch (chapter) {
            case INTRO: {
                return Messages.TutorialPage_WELCOME_TUTORIAL;
            }
            case LAYOUT: {
                return Messages.TutorialPage_OVERVIEW_TITLE;
            }
            case NEWS: {
                return Messages.TutorialPage_WORKING_WITH_NEWS;
            }
            case SAVEDSEARCH: {
                return Messages.TutorialPage_SAVING_SEARCH_RESULTS;
            }
            case NEWSBIN: {
                return Messages.TutorialPage_STORING_NEWS_BINS;
            }
            case NEWSFILTER: {
                return Messages.TutorialPage_NEWS_FILTER_POWER;
            }
            case NOTIFIER: {
                return Messages.TutorialPage_NOTIFIER_TITLE;
            }
            case SHARING: {
                return Messages.TutorialPage_SHARE_FEEDS_TITLE;
            }
            case IMPORT_EXPORT: {
                return Messages.TutorialPage_IMPORT_EXPORT_TITLE;
            }
            case SYNCHRONIZATION: {
                return Messages.TutorialPage_SYNCHRONIZATION_TITLE;
            }
            case PREFERENCES: {
                return Messages.TutorialPage_CONFIGURE_TITLE;
            }
            case TIPS: {
                return Messages.TutorialPage_TIPS_TITLE;
            }
            case FINISH: {
                return Messages.TutorialPage_FINISH_TITLE;
            }
        }
        return null;
    }

    private ImageDescriptor getTitleImage() {
        switch (this.fChapter) {
            case LAYOUT: {
                return OwlUI.getImageDescriptor("icons/wizban/layout_wiz.png");
            }
            case NEWS: {
                return OwlUI.getImageDescriptor("icons/wizban/bkmrk_wiz.gif");
            }
            case SAVEDSEARCH: {
                return OwlUI.getImageDescriptor("icons/wizban/search.gif");
            }
            case NEWSBIN: {
                return OwlUI.getImageDescriptor("icons/wizban/newsbin_wiz.gif");
            }
            case NEWSFILTER: {
                return OwlUI.getImageDescriptor("icons/wizban/filter_wiz.png");
            }
            case NOTIFIER: {
                return OwlUI.getImageDescriptor("icons/wizban/notifier_wiz.gif");
            }
            case SHARING: {
                return OwlUI.getImageDescriptor("icons/wizban/sharing_wiz.gif");
            }
            case IMPORT_EXPORT: {
                return OwlUI.getImageDescriptor("icons/wizban/import_wiz.png");
            }
            case SYNCHRONIZATION: {
                return OwlUI.getImageDescriptor("icons/wizban/reader_wiz.png");
            }
            case PREFERENCES: {
                return OwlUI.getImageDescriptor("icons/wizban/preferences_wiz.gif");
            }
            case TIPS: {
                return OwlUI.getImageDescriptor("icons/wizban/tips_wiz.png");
            }
        }
        return OwlUI.getImageDescriptor("icons/wizban/welcome_wiz.gif");
    }

    public void createControl(Composite parent) {
        this.setImageDescriptor(this.getTitleImage());
        final Composite container = new Composite(parent, 2048);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setBackground(parent.getDisplay().getSystemColor(1));
        SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                TutorialPage.this.createContents(container);
            }

            public void handleException(Throwable th) {
                Activator.safeLogError(th.getMessage(), th);
            }
        });
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private void createContents(Composite container) {
        switch (this.fChapter) {
            case INTRO: {
                this.createIntroPage(container);
                break;
            }
            case LAYOUT: {
                this.createOverviewPage(container);
                break;
            }
            case NEWS: {
                this.createNewsPage(container);
                break;
            }
            case SAVEDSEARCH: {
                this.createSavedSearchPage(container);
                break;
            }
            case NEWSBIN: {
                this.createNewsBinPage(container);
                break;
            }
            case NEWSFILTER: {
                this.createNewsFilterPage(container);
                break;
            }
            case NOTIFIER: {
                this.createNotificationsPage(container);
                break;
            }
            case SHARING: {
                this.createSharingPage(container);
                break;
            }
            case IMPORT_EXPORT: {
                this.createImportExportPage(container);
                break;
            }
            case SYNCHRONIZATION: {
                this.createSynchronizationPage(container);
                break;
            }
            case PREFERENCES: {
                this.createPreferencesPage(container);
                break;
            }
            case TIPS: {
                this.createTipsPage(container);
                break;
            }
            case FINISH: {
                this.createFinishPage(container);
            }
        }
    }

    private void createIntroPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_WELCOME_TEXT, text);
    }

    private void createOverviewPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_LAYOUT_TEXT, text);
    }

    private void createNewsPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_NEWS_TEXT, text);
    }

    private void createSavedSearchPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_SAVED_SEARCHES_TEXT, text);
    }

    private void createNewsBinPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_NEWS_BIN_TEXT, text);
    }

    private void createNewsFilterPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_NEWS_FILTER_TEXT, text);
    }

    private void createNotificationsPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_NOTIFIER_TEXT, text);
    }

    private void createSharingPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_SHARING_TEXT, text);
    }

    private void createImportExportPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_IMPORT_EXPORT_TEXT, text);
    }

    private void createSynchronizationPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_SYNCHRONIZATION_TEXT, text);
    }

    private void createPreferencesPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_PREFERENCES_TEXT, text);
    }

    private void createTipsPage(Composite container) {
        StyledText text = this.createStyledText(container);
        this.applyRichText(Messages.TutorialPage_TIPS_TEXT, text);
    }

    private void createFinishPage(Composite container) {
        StyledText text = this.createStyledText(container, false);
        this.applyRichText(Messages.TutorialPage_FINISH_TEXT, text);
        Composite linkContainer = new Composite(container, 0);
        linkContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        linkContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        linkContainer.setBackground(container.getBackground());
        this.createHyperLink(linkContainer, Messages.TutorialPage_FAQ, "http://www.rssowl.org/help");
        this.createHyperLink(linkContainer, Messages.TutorialPage_FORUMS, "http://sourceforge.net/projects/rssowl/forums");
        this.createHyperLink(linkContainer, Messages.TutorialPage_REPORT_BUGS, "http://dev.rssowl.org");
        this.createHyperLink(linkContainer, Messages.TutorialPage_CONTACT, "http://www.rssowl.org/contact");
        this.createHyperLink(linkContainer, Messages.TutorialPage_WEBSITE, "http://www.rssowl.org");
    }

    private StyledText createStyledText(Composite container) {
        return this.createStyledText(container, true);
    }

    private StyledText createStyledText(Composite container, boolean grabVertical) {
        StyledText text = new StyledText(container, 72);
        text.setEnabled(false);
        text.setLayoutData((Object)new GridData(4, 4, true, grabVertical));
        ((GridData)text.getLayoutData()).widthHint = 500;
        text.setLineSpacing(5);
        return text;
    }

    private Link createHyperLink(Composite container, String text, final String href) {
        Link link = new Link(container, 0);
        link.setText("<a>" + text + "</a>");
        link.setBackground(container.getBackground());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtils.openLinkExternal(href);
            }
        });
        return link;
    }

    private void applyRichText(String text, StyledText widget) {
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        StringBuilder buffer = new StringBuilder();
        StringReader reader = new StringReader(text);
        int index = 0;
        boolean inBold = false;
        boolean inBlue = false;
        int boldStartIndex = 0;
        int blueStartIndex = 0;
        try {
            int character;
            while ((character = reader.read()) != -1) {
                if (character == 35 && !inBold) {
                    inBold = true;
                    boldStartIndex = index;
                    continue;
                }
                if (character == 35 && inBold) {
                    inBold = false;
                    ranges.add(new StyleRange(boldStartIndex, index - boldStartIndex, null, null, 1));
                    continue;
                }
                if (character == 37 && !inBlue) {
                    inBlue = true;
                    blueStartIndex = index;
                    continue;
                }
                if (character == 37 && inBlue) {
                    inBlue = false;
                    StyleRange range = new StyleRange();
                    range.foreground = widget.getDisplay().getSystemColor(10);
                    range.start = blueStartIndex;
                    range.length = index - blueStartIndex;
                    ranges.add(range);
                    continue;
                }
                buffer.append((char)character);
                ++index;
            }
        }
        catch (IOException iOException) {}
        widget.setText(buffer.toString());
        widget.setStyleRanges(ranges.toArray(new StyleRange[ranges.size()]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Chapter {
        INTRO,
        LAYOUT,
        NEWS,
        SAVEDSEARCH,
        NEWSBIN,
        NEWSFILTER,
        NOTIFIER,
        SHARING,
        IMPORT_EXPORT,
        SYNCHRONIZATION,
        PREFERENCES,
        TIPS,
        FINISH;

    }
}

