/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.browser;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.browser.Messages;
import org.rssowl.ui.internal.editors.browser.WebBrowserContext;

public class WebBrowserInput
implements IEditorInput {
    private static final String FACTORY_ID = "org.rssowl.ui.WebBrowserViewFactory";
    static final String URL = "org.rssowl.ui.internal.editors.browser.Url";
    private final String fUrl;
    private final WebBrowserContext fContext;
    private String fCurrentUrl;

    public WebBrowserInput(String url) {
        this(url, null);
    }

    public WebBrowserInput(String url, WebBrowserContext context) {
        this.fUrl = url;
        this.fContext = context;
    }

    public String getUrl() {
        return this.fUrl;
    }

    public void setCurrentUrl(String url) {
        this.fCurrentUrl = url;
    }

    public WebBrowserContext getContext() {
        return this.fContext;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return OwlUI.getImageDescriptor("icons/eview16/webbrowser.gif");
    }

    public String getName() {
        return this.fUrl != null ? this.fUrl : Messages.WebBrowserInput_LOADING;
    }

    public IPersistableElement getPersistable() {
        IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
        if (OwlUI.useExternalBrowser()) {
            return null;
        }
        boolean restore = preferences.getBoolean(DefaultPreferences.REOPEN_BROWSER_TABS);
        if (!restore) {
            return null;
        }
        return new IPersistableElement(){

            public String getFactoryId() {
                return WebBrowserInput.FACTORY_ID;
            }

            public void saveState(IMemento memento) {
                memento.putString(WebBrowserInput.URL, WebBrowserInput.this.fCurrentUrl != null ? WebBrowserInput.this.fCurrentUrl : WebBrowserInput.this.fUrl);
            }
        };
    }

    public String getToolTipText() {
        return "";
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

