/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.notifier;

import java.util.EnumSet;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.FeedView;
import org.rssowl.ui.internal.notifier.Messages;
import org.rssowl.ui.internal.notifier.NotificationItem;
import org.rssowl.ui.internal.util.EditorUtils;

public class SearchNotificationItem
extends NotificationItem {
    private final ISearchMark fSearchmark;
    private final int fTotalResultCount;

    public SearchNotificationItem(ISearchMark searchmark, int unreadResultCount) {
        super(SearchNotificationItem.makeText(searchmark, unreadResultCount), OwlUI.SEARCHMARK);
        this.fSearchmark = searchmark;
        this.fTotalResultCount = this.fSearchmark.getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.READ, INews.State.UPDATED));
    }

    private static String makeText(ISearchMark searchmark, int unreadResultCount) {
        return NLS.bind((String)Messages.SearchNotificationItem_NAME_UNREAD_COUNT, (Object)searchmark.getName(), (Object)unreadResultCount);
    }

    public void open(MouseEvent e) {
        IWorkbenchPage page = OwlUI.getPage();
        if (page != null) {
            OwlUI.restoreWindow(page);
            IEditorReference editorRef = EditorUtils.findEditor(page.getEditorReferences(), this.fSearchmark);
            if (editorRef != null) {
                IEditorPart editor = editorRef.getEditor(false);
                if (editor instanceof FeedView) {
                    page.activate((IWorkbenchPart)editor);
                }
            } else {
                OwlUI.openInFeedView(page, (IStructuredSelection)new StructuredSelection((Object)this.fSearchmark));
            }
        }
    }

    public void setSticky(boolean sticky) {
    }

    public boolean isSticky() {
        return false;
    }

    public boolean supportsSticky() {
        return false;
    }

    public void setRead(boolean read) {
    }

    public void setColor(RGB color) {
    }

    public boolean isRead() {
        return false;
    }

    public boolean supportsMarkRead() {
        return false;
    }

    public String getDescription() {
        return NLS.bind((String)Messages.SearchNotificationItem_NEW_RESULTS, (Object)this.fTotalResultCount);
    }

    public int compareTo(NotificationItem o) {
        if (o instanceof SearchNotificationItem) {
            if (this.equals(o)) {
                return 0;
            }
            int res = this.getText().compareTo(o.getText());
            return res != 0 ? res : -1;
        }
        return -1;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fSearchmark == null ? 0 : this.fSearchmark.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchNotificationItem other = (SearchNotificationItem)obj;
        return !(this.fSearchmark == null ? other.fSearchmark != null : !this.fSearchmark.equals(other.fSearchmark));
    }
}

