/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.search;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DAOService;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.search.LocationControl;
import org.rssowl.ui.internal.search.Messages;
import org.rssowl.ui.internal.search.StateConditionControl;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchConditionItem
extends Composite {
    private Composite fInputFieldContainer;
    private final ISearchCondition fCondition;
    private final List<Integer> fFieldsToExclude;
    private Object fInputValue;
    private IModelFactory fFactory;
    private DAOService fDaoService;
    private boolean fModified;
    private ComboViewer fFieldViewer;
    private ComboViewer fSpecifierViewer;

    public SearchConditionItem(Composite parent, int style, ISearchCondition condition, List<Integer> fieldsToExclude) {
        super(parent, style);
        this.fCondition = condition;
        this.fFieldsToExclude = fieldsToExclude;
        this.fFactory = Owl.getModelFactory();
        this.fDaoService = Owl.getPersistenceService().getDAOService();
        this.initComponents();
    }

    boolean isModified() {
        return this.fModified;
    }

    boolean hasValue() {
        return this.fInputValue != null && !"".equals(this.fInputValue);
    }

    void focusInput() {
        Control[] children = this.fInputFieldContainer.getChildren();
        if (children.length > 0) {
            children[0].setFocus();
        }
    }

    ISearchCondition createCondition(ISearchMark searchmark, boolean filterEmpty) {
        if (filterEmpty && (this.fInputValue == null || "".equals(this.fInputValue))) {
            return null;
        }
        ISearchField field = (ISearchField)((IStructuredSelection)this.fFieldViewer.getSelection()).getFirstElement();
        SearchSpecifier specifier = (SearchSpecifier)((IStructuredSelection)this.fSpecifierViewer.getSelection()).getFirstElement();
        if (searchmark != null) {
            return this.fFactory.createSearchCondition(null, searchmark, field, specifier, this.fInputValue != null ? this.fInputValue : "");
        }
        return this.fFactory.createSearchCondition(field, specifier, this.fInputValue != null ? this.fInputValue : "");
    }

    private void initComponents() {
        this.setLayout((Layout)LayoutUtils.createGridLayout(3, 5, 5));
        ((GridLayout)this.getLayout()).horizontalSpacing = 10;
        this.createFieldCombo();
        this.createSpecifierCombo();
        this.createInputField();
    }

    private void createFieldCombo() {
        Combo fieldCombo = new Combo((Composite)this, 2056);
        fieldCombo.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        fieldCombo.setVisibleItemCount(100);
        this.fFieldViewer = new ComboViewer(fieldCombo);
        this.fFieldViewer.setContentProvider((IContentProvider)new ComboContentProvider());
        this.fFieldViewer.setLabelProvider((IBaseLabelProvider)new ComboLabelProvider());
        this.fFieldViewer.setInput((Object)this.fCondition);
        this.fFieldViewer.setSelection((ISelection)new StructuredSelection((Object)this.fCondition.getField()));
        this.fFieldViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SearchConditionItem.this.fModified = true;
            }
        });
    }

    private void createSpecifierCombo() {
        final Combo specifierCombo = new Combo((Composite)this, 2056);
        specifierCombo.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        ((GridData)specifierCombo.getLayoutData()).widthHint = Application.IS_WINDOWS ? 90 : 160;
        specifierCombo.setVisibleItemCount(100);
        this.fSpecifierViewer = new ComboViewer(specifierCombo);
        this.fSpecifierViewer.setContentProvider((IContentProvider)new ComboContentProvider());
        this.fSpecifierViewer.setLabelProvider((IBaseLabelProvider)new ComboLabelProvider());
        this.fSpecifierViewer.setInput((Object)this.fCondition.getField());
        if (this.fCondition.getSpecifier() != null) {
            this.fSpecifierViewer.setSelection((ISelection)new StructuredSelection((Object)this.fCondition.getSpecifier()));
        }
        if (this.fSpecifierViewer.getSelection().isEmpty()) {
            this.fSpecifierViewer.getCombo().select(0);
        }
        specifierCombo.setToolTipText(this.getSpecifierTooltip((IStructuredSelection)this.fSpecifierViewer.getSelection()));
        this.fFieldViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    ISelection oldSelection = SearchConditionItem.this.fSpecifierViewer.getSelection();
                    ISearchField field = (ISearchField)selection.getFirstElement();
                    SearchConditionItem.this.fSpecifierViewer.setInput((Object)field);
                    SearchConditionItem.this.fSpecifierViewer.setSelection(oldSelection);
                    if (SearchConditionItem.this.fSpecifierViewer.getCombo().getSelectionIndex() == -1) {
                        SearchConditionItem.this.selectFirstItem(SearchConditionItem.this.fSpecifierViewer);
                    }
                }
            }
        });
        this.fSpecifierViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SearchConditionItem.this.fModified = true;
                specifierCombo.setToolTipText(SearchConditionItem.this.getSpecifierTooltip((IStructuredSelection)event.getSelection()));
            }
        });
    }

    private String getSpecifierTooltip(IStructuredSelection selection) {
        SearchSpecifier specifier;
        Object element = selection.getFirstElement();
        if (element instanceof SearchSpecifier && (specifier = (SearchSpecifier)element) == SearchSpecifier.CONTAINS) {
            return Messages.SearchConditionItem_CONTAINS_ANY;
        }
        return null;
    }

    private void createInputField() {
        this.fInputFieldContainer = new Composite((Composite)this, 0);
        this.fInputFieldContainer.setLayout((Layout)LayoutUtils.createFillLayout(true, 0, 0));
        this.fInputFieldContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        ((GridData)this.fInputFieldContainer.getLayoutData()).widthHint = 220;
        this.updateInputField(this.fInputFieldContainer, this.fCondition.getField(), this.fCondition.getValue());
        this.fFieldViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    ISearchField field = (ISearchField)selection.getFirstElement();
                    SearchConditionItem.this.updateInputField(SearchConditionItem.this.fInputFieldContainer, field, null);
                }
            }
        });
    }

    private void updateInputField(Composite inputField, final ISearchField field, final Object input) {
        Control[] children;
        Control[] controlArray = children = inputField.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (field.getId() == 14) {
            Object presetInput;
            final StateConditionControl stateConditionControl = new StateConditionControl(inputField, 0);
            stateConditionControl.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    SearchConditionItem.this.fInputValue = stateConditionControl.getSelection();
                    if (SearchConditionItem.this.fInputValue == null && input != null || SearchConditionItem.this.fInputValue != null && !SearchConditionItem.this.fInputValue.equals(input)) {
                        SearchConditionItem.this.fModified = true;
                    }
                }
            });
            Object object = presetInput = input == null ? this.fInputValue : input;
            if (presetInput != null && presetInput instanceof EnumSet) {
                stateConditionControl.select((EnumSet)presetInput);
            }
            this.fInputValue = stateConditionControl.getSelection();
        } else if (field.getId() == 19) {
            Object presetInput;
            final LocationControl locationConditionControl = new LocationControl(inputField, 0);
            locationConditionControl.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    SearchConditionItem.this.fInputValue = locationConditionControl.getSelection();
                    if (SearchConditionItem.this.fInputValue == null && input != null || SearchConditionItem.this.fInputValue != null && !SearchConditionItem.this.fInputValue.equals(input)) {
                        SearchConditionItem.this.fModified = true;
                    }
                }
            });
            Object object = presetInput = input == null ? this.fInputValue : input;
            if (presetInput != null && presetInput instanceof Long[][]) {
                locationConditionControl.select((Long[][])presetInput);
            }
            this.fInputValue = locationConditionControl.getSelection();
        } else if (field.getId() == 18 || field.getId() == 21) {
            Object presetInput;
            Composite container = new Composite(inputField, 0);
            container.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
            final Spinner spinner = new Spinner(container, 2048);
            spinner.setLayoutData((Object)new GridData(4, 1, true, false));
            spinner.setMinimum(1);
            spinner.setMaximum(1000000);
            final Combo combo = new Combo(container, 2056);
            combo.add(Messages.SearchConditionItem_DAYS);
            combo.add(Messages.SearchConditionItem_HOURS);
            combo.add(Messages.SearchConditionItem_MINUTES);
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    SearchConditionItem.this.fInputValue = SearchConditionItem.this.getAgeValue(spinner, combo);
                    if (!SearchConditionItem.this.fInputValue.equals(input)) {
                        SearchConditionItem.this.fModified = true;
                    }
                }
            };
            spinner.addListener(24, listener);
            combo.addListener(24, listener);
            Object object = presetInput = input == null ? this.fInputValue : input;
            if (presetInput != null && presetInput instanceof Integer) {
                Integer inputValue = (Integer)presetInput;
                if (inputValue >= 0) {
                    spinner.setSelection(inputValue.intValue());
                    combo.select(0);
                } else if (inputValue % 60 == 0) {
                    spinner.setSelection(Math.abs(inputValue) / 60);
                    combo.select(1);
                } else {
                    spinner.setSelection(Math.abs(inputValue));
                    combo.select(2);
                }
            } else {
                spinner.setSelection(1);
                combo.select(0);
            }
            this.fInputValue = this.getAgeValue(spinner, combo);
        } else {
            switch (field.getSearchValueType().getId()) {
                case 6: {
                    Object presetInput;
                    final Combo combo = new Combo(inputField, 2056);
                    combo.add(Messages.SearchConditionItem_TRUE);
                    combo.add(Messages.SearchConditionItem_FALSE);
                    combo.addListener(24, new Listener(){

                        public void handleEvent(Event event) {
                            SearchConditionItem.this.fInputValue = Boolean.valueOf(combo.getItem(combo.getSelectionIndex()));
                            if (!SearchConditionItem.this.fInputValue.equals(input)) {
                                SearchConditionItem.this.fModified = true;
                            }
                        }
                    });
                    Object object = presetInput = input == null ? this.fInputValue : input;
                    if (presetInput != null && presetInput instanceof Boolean) {
                        combo.select((Boolean)presetInput != false ? 0 : 1);
                    } else {
                        combo.select(0);
                    }
                    this.fInputValue = Boolean.valueOf(combo.getItem(combo.getSelectionIndex()));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    Object presetInput;
                    final Calendar cal = Calendar.getInstance();
                    final DateTime datetime = new DateTime(inputField, 2080);
                    datetime.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            cal.set(5, datetime.getDay());
                            cal.set(2, datetime.getMonth());
                            cal.set(1, datetime.getYear());
                            SearchConditionItem.this.fInputValue = cal.getTime();
                            if (!SearchConditionItem.this.fInputValue.equals(input)) {
                                SearchConditionItem.this.fModified = true;
                            }
                        }
                    });
                    Object object = presetInput = input == null ? this.fInputValue : input;
                    if (presetInput != null && presetInput instanceof Date) {
                        cal.setTime((Date)presetInput);
                    }
                    datetime.setDay(cal.get(5));
                    datetime.setMonth(cal.get(2));
                    datetime.setYear(cal.get(1));
                    this.fInputValue = cal.getTime();
                    break;
                }
                case 7: {
                    String inputValue;
                    final Text text = new Text(inputField, 2048);
                    text.addListener(24, new Listener(){

                        public void handleEvent(Event event) {
                            SearchConditionItem.this.fInputValue = text.getText();
                            if (!SearchConditionItem.this.fInputValue.equals(input)) {
                                SearchConditionItem.this.fModified = true;
                            }
                        }
                    });
                    OwlUI.hookAutoComplete(text, field.getSearchValueType().getEnumValues(), true, true);
                    String string = inputValue = input != null ? input.toString() : null;
                    if (inputValue != null) {
                        text.setText(inputValue);
                    }
                    this.fInputValue = text.getText();
                    break;
                }
                case 4: 
                case 5: {
                    Object presetInput;
                    final Spinner spinner = new Spinner(inputField, 2048);
                    spinner.setMinimum(0);
                    spinner.setMaximum(1000);
                    spinner.addListener(24, new Listener(){

                        public void handleEvent(Event event) {
                            SearchConditionItem.this.fInputValue = spinner.getSelection();
                            if (!SearchConditionItem.this.fInputValue.equals(input)) {
                                SearchConditionItem.this.fModified = true;
                            }
                        }
                    });
                    Object object = presetInput = input == null ? this.fInputValue : input;
                    if (presetInput != null && presetInput instanceof Integer) {
                        spinner.setSelection(((Integer)presetInput).intValue());
                    }
                    this.fInputValue = spinner.getSelection();
                    break;
                }
                case 0: 
                case 8: {
                    Object presetInput;
                    final Text text = new Text(inputField, 2048);
                    OwlUI.makeAccessible((Control)text, NLS.bind((String)Messages.SearchConditionItem_SEARCH_VALUE_FIELD, (Object)field.getName()));
                    final ControlDecoration controlDeco = new ControlDecoration((Control)text, 16512);
                    controlDeco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
                    controlDeco.setShowOnlyOnFocus(true);
                    text.addListener(24, new Listener(){
                        private boolean isShowingWarning = false;

                        public void handleEvent(Event event) {
                            String textValue = text.getText();
                            SearchConditionItem.this.fInputValue = textValue;
                            if (!SearchConditionItem.this.fInputValue.equals(input)) {
                                SearchConditionItem.this.fModified = true;
                            }
                            if (this.isShowingWarning) {
                                controlDeco.hideHover();
                            }
                            SearchWarning warning = SearchWarning.NO_WARNING;
                            if (field.getId() == 12 || field.getId() == 9 || field.getId() == 17 || field.getId() == 1) {
                                if (StringUtils.isPhraseSearch((String)textValue)) {
                                    warning = SearchWarning.PHRASE_SEARCH_UNSUPPORTED;
                                }
                            } else if (StringUtils.isPhraseSearchWithWildcardToken((String)textValue)) {
                                warning = SearchWarning.PHRASE_AND_WILDCARD_SEARCH_COMBINED;
                            } else if (StringUtils.isSpecialCharacterSearchWithWildcardToken((String)textValue)) {
                                warning = SearchWarning.WILDCARD_AND_SPECIAL_CHAR_SEARCH;
                            }
                            if (warning != SearchWarning.NO_WARNING && !this.isShowingWarning) {
                                SearchConditionItem.this.updateFieldDecoration(text, controlDeco, warning, field);
                                this.isShowingWarning = true;
                            } else if (warning == SearchWarning.NO_WARNING && this.isShowingWarning) {
                                SearchConditionItem.this.updateFieldDecoration(text, controlDeco, warning, field);
                                this.isShowingWarning = false;
                            }
                        }
                    });
                    if (field.getId() == 12 || field.getId() == 3 || field.getId() == 17) {
                        controlDeco.setDescriptionText(Messages.SearchConditionItem_CONTENT_ASSIST_INFO);
                        final Pair<SimpleContentProposalProvider, ContentProposalAdapter> pair = OwlUI.hookAutoComplete(text, null, false, true);
                        JobRunner.runInBackgroundThread(100, new Runnable(){

                            public void run() {
                                if (!text.isDisposed()) {
                                    TreeSet<String> values = new TreeSet<String>(new Comparator<String>(){

                                        @Override
                                        public int compare(String o1, String o2) {
                                            return o1.compareToIgnoreCase(o2);
                                        }
                                    });
                                    if (field.getId() == 12) {
                                        values.addAll(SearchConditionItem.this.fDaoService.getCategoryDAO().loadAllNames());
                                    } else if (field.getId() == 3) {
                                        values.addAll(SearchConditionItem.this.fDaoService.getPersonDAO().loadAllNames());
                                    } else if (field.getId() == 17) {
                                        values.addAll(CoreUtils.getFeedLinks());
                                    }
                                    if (!text.isDisposed()) {
                                        OwlUI.applyAutoCompleteProposals(values, (SimpleContentProposalProvider)pair.getFirst(), (ContentProposalAdapter)pair.getSecond(), true);
                                    }
                                }
                            }
                        });
                    } else {
                        controlDeco.setDescriptionText(Messages.SearchConditionItem_SEARCH_HELP);
                    }
                    Object object = presetInput = input == null && this.fInputValue instanceof String ? this.fInputValue : input;
                    if (presetInput != null) {
                        text.setText(presetInput.toString());
                    }
                    this.fInputValue = text.getText();
                }
            }
        }
        inputField.getParent().layout();
        inputField.getParent().update();
        inputField.layout();
        inputField.update();
    }

    private void updateFieldDecoration(Text text, ControlDecoration deco, SearchWarning warning, ISearchField field) {
        if (warning != SearchWarning.NO_WARNING) {
            String decoText = warning == SearchWarning.PHRASE_SEARCH_UNSUPPORTED ? Messages.SearchConditionItem_WARNING_PHRASE_SEARCH_UNSUPPORTED : (warning == SearchWarning.PHRASE_AND_WILDCARD_SEARCH_COMBINED ? Messages.SearchConditionItem_ERROR_PHRASE_AND_WILDCARD_SEARCH : Messages.SearchConditionItem_WARNING_WILDCARD_SPECIAL_CHAR_SEARCH);
            deco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
            deco.setDescriptionText(decoText);
            if (text.isFocusControl()) {
                deco.showHoverText(decoText);
            }
        } else {
            deco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
            if (field.getId() == 12 || field.getId() == 3 || field.getId() == 17) {
                deco.setDescriptionText(Messages.SearchConditionItem_CONTENT_ASSIST_INFO);
            } else {
                deco.setDescriptionText(Messages.SearchConditionItem_SEARCH_HELP);
            }
        }
    }

    private int getAgeValue(Spinner valueSpinner, Combo scopeCombo) {
        int value = valueSpinner.getSelection();
        if (scopeCombo.getSelectionIndex() == 0) {
            return value;
        }
        if (scopeCombo.getSelectionIndex() == 1) {
            return value * 60 * -1;
        }
        return value * -1;
    }

    private List<ISearchField> createFields(ISearchCondition condition) {
        ArrayList<ISearchField> fields = new ArrayList<ISearchField>();
        String entityName = condition.getField().getEntityName();
        if (INews.class.getName().equals(entityName)) {
            ArrayList<Integer> newsFields = new ArrayList<Integer>();
            newsFields.add(-1);
            newsFields.add(14);
            newsFields.add(19);
            newsFields.add(0);
            newsFields.add(2);
            newsFields.add(3);
            newsFields.add(12);
            newsFields.add(18);
            newsFields.add(6);
            newsFields.add(7);
            newsFields.add(8);
            newsFields.add(10);
            newsFields.add(11);
            newsFields.add(9);
            newsFields.add(1);
            newsFields.add(13);
            newsFields.add(15);
            newsFields.add(17);
            if (this.fFieldsToExclude != null) {
                newsFields.removeAll(this.fFieldsToExclude);
            }
            for (Integer newsField : newsFields) {
                fields.add(this.fFactory.createSearchField(newsField.intValue(), entityName));
            }
        }
        return fields;
    }

    private List<SearchSpecifier> createSpecifier(ISearchField field) {
        ArrayList<SearchSpecifier> specifiers = new ArrayList<SearchSpecifier>();
        String entityName = field.getEntityName();
        if (INews.class.getName().equals(entityName)) {
            int fieldId = field.getId();
            int typeId = field.getSearchValueType().getId();
            if (fieldId != -1 && fieldId != 0 && fieldId != 2 && fieldId != 11 && fieldId != 3) {
                specifiers.add(SearchSpecifier.IS);
                if (fieldId != 18) {
                    specifiers.add(SearchSpecifier.IS_NOT);
                }
            } else {
                specifiers.add(SearchSpecifier.CONTAINS_ALL);
                specifiers.add(SearchSpecifier.CONTAINS);
                specifiers.add(SearchSpecifier.CONTAINS_NOT);
            }
            if (fieldId == 1 || fieldId == 9 || fieldId == 15 || fieldId == 12 || fieldId == 17) {
                specifiers.add(SearchSpecifier.BEGINS_WITH);
                specifiers.add(SearchSpecifier.ENDS_WITH);
            }
            if (typeId == 1 || typeId == 2 || typeId == 3) {
                specifiers.add(SearchSpecifier.IS_BEFORE);
                specifiers.add(SearchSpecifier.IS_AFTER);
            }
            if (typeId == 5 || typeId == 4) {
                specifiers.add(SearchSpecifier.IS_GREATER_THAN);
                specifiers.add(SearchSpecifier.IS_LESS_THAN);
            }
            if (fieldId == 0 || fieldId == 3 || fieldId == 12) {
                specifiers.add(SearchSpecifier.SIMILIAR_TO);
            }
        }
        return specifiers;
    }

    private void selectFirstItem(ComboViewer viewer) {
        viewer.getCombo().select(0);
        viewer.setSelection(viewer.getSelection());
    }

    private class ComboContentProvider
    implements IStructuredContentProvider {
        private ComboContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof ISearchCondition) {
                return SearchConditionItem.this.createFields((ISearchCondition)input).toArray();
            }
            if (input instanceof ISearchField) {
                return SearchConditionItem.this.createSpecifier((ISearchField)input).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ComboLabelProvider
    extends LabelProvider {
        private ComboLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ISearchField) {
                return ((ISearchField)element).getName();
            }
            if (element instanceof SearchSpecifier) {
                return ((SearchSpecifier)element).getName();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SearchWarning {
        NO_WARNING,
        PHRASE_AND_WILDCARD_SEARCH_COMBINED,
        PHRASE_SEARCH_UNSUPPORTED,
        WILDCARD_AND_SPECIAL_CHAR_SEARCH;

    }
}

