/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.util.Messages;

public class ColorPicker {
    private static final String[] COLOR_LABELS = new String[]{Messages.ColorPicker_BARN_RED, Messages.ColorPicker_SALEM_RED, Messages.ColorPicker_SALMON, Messages.ColorPicker_PUMPKIN, Messages.ColorPicker_MARIGOLD_YELLOW, Messages.ColorPicker_MUSTARD, Messages.ColorPicker_BARBERRY_GREEN, Messages.ColorPicker_TAVERN_GREEN, Messages.ColorPicker_LEXINGTON_GREEN, Messages.ColorPicker_SEA_GREEN, Messages.ColorPicker_FEDERAL_BLUE, Messages.ColorPicker_SOLIDER_BLUE, Messages.ColorPicker_SLATE, Messages.ColorPicker_PITCH_BLACK, Messages.ColorPicker_DRIFTWOOD, Messages.ColorPicker_CHOCOLATE_BROWN};
    private static final RGB[] COLOR_VALUES = new RGB[]{new RGB(124, 10, 2), new RGB(163, 21, 2), new RGB(214, 148, 99), new RGB(200, 118, 10), new RGB(240, 177, 12), new RGB(209, 161, 17), new RGB(136, 128, 54), new RGB(129, 150, 93), new RGB(82, 92, 58), new RGB(126, 135, 130), new RGB(111, 121, 174), new RGB(92, 101, 126), new RGB(144, 152, 163), new RGB(25, 16, 17), new RGB(82, 66, 41), new RGB(82, 16, 0)};
    private Menu fColorMenu;
    private final Composite fParent;
    private ToolBar fBar;
    private ToolItem fColorItem;
    private List<Image> fImagesToDispose = new ArrayList<Image>();
    private RGB fSelectedColor = new RGB(0, 0, 0);

    public ColorPicker(Composite parent, int style) {
        this.fParent = parent;
        this.initControl(style);
    }

    public void setColor(RGB color) {
        this.onColorSelected(color);
    }

    public Control getControl() {
        return this.fBar;
    }

    public RGB getColor() {
        return this.fSelectedColor;
    }

    private void initControl(int style) {
        this.fBar = new ToolBar(this.fParent, style);
        OwlUI.makeAccessible((Control)this.fBar, Messages.ColorPicker_COLOR_LABEL);
        this.fBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OwlUI.safeDispose(ColorPicker.this.fColorMenu);
                for (Image img : ColorPicker.this.fImagesToDispose) {
                    img.dispose();
                }
            }
        });
        this.createColorMenu();
        this.fColorItem = new ToolItem(this.fBar, 4);
        this.fColorItem.setImage(this.createColorImage(this.fSelectedColor));
        this.fColorItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = ColorPicker.this.fColorItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = ColorPicker.this.fBar.toDisplay(pt);
                ColorPicker.this.fColorMenu.setLocation(pt.x, pt.y);
                ColorPicker.this.fColorMenu.setVisible(true);
            }
        });
    }

    private void createColorMenu() {
        this.fColorMenu = new Menu((Decorations)this.fParent.getShell(), 8);
        int i = 0;
        while (i < COLOR_LABELS.length) {
            MenuItem item = new MenuItem(this.fColorMenu, 16);
            item.setText(COLOR_LABELS[i]);
            final RGB color = COLOR_VALUES[i];
            item.setImage(this.createColorImage(color));
            item.setData((Object)color);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ColorPicker.this.onColorSelected(color);
                }
            });
            ++i;
        }
        new MenuItem(this.fColorMenu, 2);
        MenuItem moreColor = new MenuItem(this.fColorMenu, 8);
        moreColor.setText(Messages.ColorPicker_OTHER);
        moreColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorPicker.this.onSelectOtherColor();
            }
        });
    }

    private void onColorSelected(RGB color) {
        MenuItem[] items;
        this.fSelectedColor = color;
        if (this.fColorItem.getImage() != null) {
            this.fColorItem.getImage().dispose();
        }
        this.fColorItem.setImage(this.createColorImage(this.fSelectedColor));
        MenuItem[] menuItemArray = items = this.fColorMenu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (this.fSelectedColor.equals(item.getData())) {
                item.setSelection(true);
            } else if (item.getSelection()) {
                item.setSelection(false);
            }
            ++n2;
        }
    }

    private Image createColorImage(RGB color) {
        Image img = OwlUI.createColorImage(this.fParent.getDisplay(), color);
        this.fImagesToDispose.add(img);
        return img;
    }

    private void onSelectOtherColor() {
        ColorDialog dialog = new ColorDialog(this.fParent.getShell());
        dialog.setRGB(this.fSelectedColor);
        RGB color = dialog.open();
        if (color != null) {
            this.onColorSelected(color);
        }
    }
}

