/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.Mark;
import org.rssowl.core.internal.persist.NewsContainer;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.reference.SearchMarkReference;
import org.rssowl.core.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchMark
extends Mark
implements ISearchMark {
    private List<ISearchCondition> fSearchConditions;
    private boolean fMatchAllConditions;
    private final transient NewsContainer fNewsContainer;

    public SearchMark(Long id, IFolder folder, String name) {
        super(id, folder, name);
        this.fSearchConditions = new ArrayList<ISearchCondition>(5);
        this.fNewsContainer = this.createNewsContainer();
    }

    private NewsContainer createNewsContainer() {
        EnumMap<INews.State, Boolean> statesToSortedMap = new EnumMap<INews.State, Boolean>(INews.State.class);
        statesToSortedMap.put(INews.State.NEW, Boolean.TRUE);
        return new NewsContainer(statesToSortedMap);
    }

    protected SearchMark() {
        this.fNewsContainer = this.createNewsContainer();
    }

    public synchronized NewsContainer internalGetNewsContainer() {
        return this.fNewsContainer;
    }

    @Override
    public synchronized Pair<Boolean, Boolean> setNewsRefs(Map<INews.State, List<NewsReference>> results) {
        return this.fNewsContainer.setNews(results);
    }

    @Override
    public synchronized void addSearchCondition(ISearchCondition searchCondition) {
        Assert.isNotNull((Object)searchCondition, (String)"Exception adding NULL as Search Condition into SearchMark");
        this.fSearchConditions.add(searchCondition);
    }

    @Override
    public synchronized boolean removeSearchCondition(ISearchCondition searchCondition) {
        return this.fSearchConditions.remove(searchCondition);
    }

    @Override
    public synchronized boolean containsSearchCondition(ISearchCondition searchCondition) {
        return this.fSearchConditions.contains(searchCondition);
    }

    @Override
    public synchronized List<ISearchCondition> getSearchConditions() {
        return new ArrayList<ISearchCondition>(this.fSearchConditions);
    }

    @Override
    public synchronized boolean matchAllConditions() {
        return this.fMatchAllConditions;
    }

    @Override
    public synchronized void setMatchAllConditions(boolean requiresAllConditions) {
        this.fMatchAllConditions = requiresAllConditions;
    }

    @Override
    public SearchMarkReference toReference() {
        return new SearchMarkReference(this.getIdAsPrimitive());
    }

    @Override
    public List<INews> getNews() {
        return this.getNews(EnumSet.allOf(INews.State.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<INews> getNews(Set<INews.State> states) {
        List<NewsReference> newsRefs;
        SearchMark searchMark = this;
        synchronized (searchMark) {
            newsRefs = this.fNewsContainer.getNews(states);
        }
        return SearchMark.getNews(newsRefs);
    }

    @Override
    public synchronized int getNewsCount(Set<INews.State> states) {
        Assert.isNotNull(states, (String)"states");
        return this.fNewsContainer.getNewsCount(states);
    }

    @Override
    public synchronized List<NewsReference> getNewsRefs() {
        return this.fNewsContainer.getNews();
    }

    @Override
    public synchronized List<NewsReference> getNewsRefs(Set<INews.State> states) {
        return this.fNewsContainer.getNews(states);
    }

    @Override
    public boolean isGetNewsRefsEfficient() {
        return true;
    }

    @Override
    public boolean containsNews(INews news) {
        return this.fNewsContainer.containsNews(news);
    }

    public synchronized boolean isIdentical(ISearchMark searchMark) {
        if (this == searchMark) {
            return true;
        }
        if (!(searchMark instanceof SearchMark)) {
            return false;
        }
        SearchMark s = (SearchMark)searchMark;
        return (this.getId() == null ? s.getId() == null : this.getId().equals(s.getId())) && (this.getParent() == null ? s.getParent() == null : this.getParent().equals(s.getParent())) && (this.fSearchConditions == null ? s.fSearchConditions == null : this.fSearchConditions.equals(s.fSearchConditions)) && (this.getLastVisitDate() == null ? s.getLastVisitDate() == null : this.getLastVisitDate().equals(s.getLastVisitDate())) && this.getPopularity() == s.getPopularity() && this.fMatchAllConditions == s.matchAllConditions() && (this.getProperties() == null ? s.getProperties() == null : this.getProperties().equals(s.getProperties()));
    }

    @Override
    public synchronized String toLongString() {
        return String.valueOf(super.toString()) + "Search Conditions = " + this.fSearchConditions.toString() + ")";
    }
}

