/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.migration;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rssowl.core.internal.persist.Description;
import org.rssowl.core.internal.persist.News;
import org.rssowl.core.internal.persist.migration.Messages;
import org.rssowl.core.internal.persist.migration.MigrationHelper;
import org.rssowl.core.internal.persist.migration.MigrationResult;
import org.rssowl.core.internal.persist.service.ConfigurationFactory;
import org.rssowl.core.internal.persist.service.Migration;

public class Migration2To3
implements Migration {
    public int getDestinationFormat() {
        return 3;
    }

    public int getOriginFormat() {
        return 2;
    }

    public MigrationResult migrate(ConfigurationFactory configFactory, String dbFileName, IProgressMonitor progressMonitor) {
        int totalProgressIncremented = 0;
        progressMonitor.beginTask(Messages.Migration2To3_MIGRATING_DATA, 100);
        ObjectContainer oc = Db4o.openFile((Configuration)configFactory.createConfiguration(), (String)dbFileName);
        totalProgressIncremented = Migration2To3.migrate(progressMonitor, 100, totalProgressIncremented, oc);
        oc.commit();
        oc.close();
        progressMonitor.worked(100 - totalProgressIncremented);
        return new MigrationResult(false, false, false);
    }

    static int migrate(IProgressMonitor progressMonitor, int totalProgress, int totalProgressIncremented, ObjectContainer oc) {
        ObjectSet newsList = oc.query(News.class);
        int newsCountPerIncrement = newsList.size() / totalProgress;
        int i = 0;
        for (News news : newsList) {
            oc.activate((Object)news, Integer.MAX_VALUE);
            String descriptionFieldName = "fDescription";
            String descriptionValue = (String)MigrationHelper.getFieldValue(news, descriptionFieldName);
            if (descriptionValue != null) {
                MigrationHelper.setField(news, descriptionFieldName, null);
                Description description = new Description(news, descriptionValue);
                oc.ext().set((Object)description, Integer.MAX_VALUE);
                oc.ext().set((Object)news, Integer.MAX_VALUE);
            }
            ++i;
            if (newsCountPerIncrement == 0) {
                int progressIncrement = totalProgress / newsList.size();
                totalProgressIncremented += progressIncrement;
                progressMonitor.worked(progressIncrement);
                continue;
            }
            if (i % newsCountPerIncrement != 0) continue;
            ++totalProgressIncremented;
            progressMonitor.worked(1);
        }
        return totalProgressIncremented;
    }
}

