/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.search;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.internal.persist.LongArrayList;
import org.rssowl.core.internal.persist.dao.EntitiesToBeIndexedDAOImpl;
import org.rssowl.core.internal.persist.search.IndexingTask;
import org.rssowl.core.internal.persist.search.LowercaseDelimiterAnalyzer;
import org.rssowl.core.internal.persist.search.LowercaseWhitespaceAnalyzer;
import org.rssowl.core.internal.persist.search.Messages;
import org.rssowl.core.internal.persist.search.ModelSearchImpl;
import org.rssowl.core.internal.persist.search.NewsDocument;
import org.rssowl.core.internal.persist.search.SearchDocument;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.internal.persist.service.EntityIdsByEventType;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.event.LabelAdapter;
import org.rssowl.core.persist.event.LabelEvent;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.NewsListener;
import org.rssowl.core.persist.event.runnable.EventType;
import org.rssowl.core.persist.reference.ModelReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.JobQueue;
import org.rssowl.core.util.SearchHit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indexer {
    private static final int INDEX_JOB_PROGRESS_DELAY = 800;
    private static final int MAX_INDEX_JOBS_COUNT = 1;
    private static final String DISABLE_STOP_WORDS_PROPERTY = "disableStopWords";
    static final boolean DISABLE_STOP_WORDS = System.getProperty("disableStopWords") != null;
    private final Directory fIndexDirectory;
    private IndexWriter fIndexWriter;
    private final JobQueue fJobQueue;
    private NewsListener fNewsListener;
    private LabelAdapter fLabelListener;
    private final ModelSearchImpl fSearch;
    private final EntityIdsByEventType fUncommittedNews;
    private volatile boolean fFlushRequired;

    Indexer(ModelSearchImpl search, Directory directory) throws PersistenceException {
        this.fSearch = search;
        this.fIndexDirectory = directory;
        this.fJobQueue = new JobQueue(Messages.Indexer_UPDATE_SAVED_SEARCHES, 1, Integer.MAX_VALUE, false, 800);
        this.fUncommittedNews = new EntityIdsByEventType(false);
    }

    synchronized void index(List<INews> entities, boolean isUpdate) {
        this.index(entities, isUpdate, true);
    }

    synchronized void index(List<INews> entities, boolean isUpdate, boolean acid) {
        int docCount = 0;
        ListIterator<INews> it = entities.listIterator(entities.size());
        while (it.hasPrevious()) {
            INews news = it.previous();
            it.remove();
            if (Owl.isShuttingDown()) break;
            NewsDocument newsDoc = new NewsDocument(news);
            try {
                if (!newsDoc.addFields()) continue;
                ++docCount;
                if (isUpdate) {
                    Term term = this.createTerm(news);
                    if (acid) {
                        this.fUncommittedNews.addUpdatedEntity(news);
                    }
                    this.fIndexWriter.updateDocument(term, newsDoc.getDocument());
                    continue;
                }
                if (acid) {
                    this.fUncommittedNews.addPersistedEntity(news);
                }
                this.fIndexWriter.addDocument(newsDoc.getDocument());
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
        }
        if (docCount > 0) {
            this.fFlushRequired = true;
            this.fSearch.notifyIndexUpdated(docCount);
        }
    }

    synchronized void removeFromIndex(Collection<NewsReference> entities) throws IOException {
        int docCount = 0;
        for (NewsReference newsRef : entities) {
            Term term = this.createTerm(newsRef);
            this.fUncommittedNews.addRemovedEntityId(newsRef.getId());
            this.fIndexWriter.deleteDocuments(term);
            ++docCount;
        }
        if (docCount > 0) {
            this.fFlushRequired = true;
            this.fSearch.notifyIndexUpdated(docCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean flushIfNecessary() throws PersistenceException {
        if (!this.fFlushRequired) {
            return false;
        }
        Indexer indexer = this;
        synchronized (indexer) {
            block5: {
                if (this.fFlushRequired) break block5;
                return true;
            }
            this.dispose();
            this.createIndexWriter(false);
            Indexer.saveCommittedNews(false, new EntityIdsByEventType(this.fUncommittedNews));
            this.fUncommittedNews.clear();
        }
        return true;
    }

    synchronized void shutdown(boolean emergency) {
        if (this.fJobQueue != null) {
            if (!emergency) {
                this.fJobQueue.cancel(false, true);
            } else {
                this.fJobQueue.seal();
            }
        }
        if (Owl.isStarted()) {
            this.unregisterListeners();
        }
        this.dispose();
        if (!emergency) {
            Indexer.saveCommittedNews(true, this.fUncommittedNews);
            this.fUncommittedNews.clear();
        }
    }

    synchronized void clearIndex() throws IOException {
        this.dispose();
        this.fUncommittedNews.clear();
        if (IndexReader.indexExists((Directory)this.fIndexDirectory)) {
            this.fIndexWriter = this.createIndexWriter(this.fIndexDirectory, true);
        }
    }

    synchronized void optimize() throws CorruptIndexException, IOException {
        this.fIndexWriter.optimize();
    }

    public static Analyzer createAnalyzer() {
        PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)new DefaultAnalyzer());
        StandardAnalyzer stdAnalyzer = DISABLE_STOP_WORDS ? new StandardAnalyzer(Collections.EMPTY_SET) : new StandardAnalyzer();
        analyzer.addAnalyzer(String.valueOf(0), (Analyzer)stdAnalyzer);
        analyzer.addAnalyzer(String.valueOf(2), (Analyzer)stdAnalyzer);
        analyzer.addAnalyzer(String.valueOf(11), (Analyzer)stdAnalyzer);
        LowercaseWhitespaceAnalyzer simpleAnalyzer = new LowercaseWhitespaceAnalyzer();
        analyzer.addAnalyzer(String.valueOf(3), (Analyzer)simpleAnalyzer);
        analyzer.addAnalyzer(String.valueOf(15), (Analyzer)simpleAnalyzer);
        analyzer.addAnalyzer(String.valueOf(12), (Analyzer)new LowercaseDelimiterAnalyzer('\n'));
        return analyzer;
    }

    private void init(boolean clearIndex) throws PersistenceException {
        this.createIndexWriter(clearIndex);
        this.registerListeners();
        if (!Boolean.getBoolean("rssowl.reindex")) {
            if (!InternalOwl.TESTING) {
                Job delayedIndexJob = new Job(Messages.Indexer_INDEX_FROM_SHUTDOWN){

                    protected IStatus run(IProgressMonitor monitor) {
                        for (IndexingTask task : Indexer.this.getIndexOutstandingEntitiesTasks()) {
                            Indexer.this.fJobQueue.schedule(task);
                        }
                        return Status.OK_STATUS;
                    }
                };
                delayedIndexJob.setSystem(true);
                delayedIndexJob.setUser(false);
                delayedIndexJob.schedule(1000L);
            } else {
                for (IndexingTask task : this.getIndexOutstandingEntitiesTasks()) {
                    task.run((IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
    }

    private List<IndexingTask> getIndexOutstandingEntitiesTasks() {
        final EntitiesToBeIndexedDAOImpl dao = DBHelper.getEntitiesToBeIndexedDAO();
        ArrayList<IndexingTask> indexingTasks = new ArrayList<IndexingTask>(3);
        if (dao != null) {
            List<NewsReference> removedEntityRefs;
            List<NewsReference> updatedEntityRefs;
            IndexingTask.RemovedNewsRefsListener removedNewsRefsListener = new IndexingTask.RemovedNewsRefsListener(){

                @Override
                public void event(Collection<NewsReference> newsRefs) {
                    LongArrayList list = new LongArrayList(newsRefs.size());
                    for (NewsReference newsRef : newsRefs) {
                        list.add(newsRef.getId());
                    }
                    EntityIdsByEventType entityIdsByEventType = dao.load();
                    entityIdsByEventType.removeAll(list, list, list);
                    dao.save(entityIdsByEventType);
                }
            };
            EntityIdsByEventType outstandingNewsIds = dao.load();
            List<NewsReference> persistedEntityRefs = outstandingNewsIds.getPersistedEntityRefs();
            if (!persistedEntityRefs.isEmpty()) {
                indexingTasks.add(new IndexingTask(this, EventType.PERSIST, persistedEntityRefs, removedNewsRefsListener));
            }
            if (!(updatedEntityRefs = outstandingNewsIds.getUpdatedEntityRefs()).isEmpty()) {
                indexingTasks.add(new IndexingTask(this, EventType.UPDATE, updatedEntityRefs, removedNewsRefsListener));
            }
            if (!(removedEntityRefs = outstandingNewsIds.getRemovedEntityRefs()).isEmpty()) {
                indexingTasks.add(new IndexingTask(this, EventType.REMOVE, removedEntityRefs, removedNewsRefsListener));
            }
        }
        return indexingTasks;
    }

    synchronized void initIfNecessary(boolean clearIndex) {
        if (this.fIndexWriter == null) {
            this.init(clearIndex);
        }
    }

    private void createIndexWriter(boolean clearIndex) {
        try {
            this.fIndexWriter = this.createIndexWriter(this.fIndexDirectory, clearIndex || !IndexReader.indexExists((Directory)this.fIndexDirectory));
        }
        catch (IOException e) {
            throw new PersistenceException(e.getMessage(), e);
        }
    }

    private void registerListeners() {
        if (this.fNewsListener != null) {
            return;
        }
        this.fNewsListener = new NewsListener(){

            @Override
            public void entitiesAdded(Set<NewsEvent> events) {
                Indexer.this.handleEntitiesAdded(DBHelper.filterPersistedNewsForIndexing(events));
            }

            @Override
            public void entitiesUpdated(Set<NewsEvent> events) {
                HashSet<NewsEvent> newsToUpdate = new HashSet<NewsEvent>(3);
                HashSet<NewsEvent> newsToRestore = new HashSet<NewsEvent>(3);
                HashSet<NewsEvent> newsToDelete = new HashSet<NewsEvent>(3);
                for (NewsEvent event : events) {
                    DBHelper.indexTypeForNewsUpdate(event, newsToRestore, newsToUpdate, newsToDelete);
                }
                if (!newsToRestore.isEmpty()) {
                    Indexer.this.handleEntitiesAdded(newsToRestore);
                }
                if (!newsToUpdate.isEmpty()) {
                    Indexer.this.handleEntitiesUpdated(newsToUpdate);
                }
                if (!newsToDelete.isEmpty()) {
                    Indexer.this.handleEntitiesDeleted(newsToDelete);
                }
            }

            @Override
            public void entitiesDeleted(Set<NewsEvent> events) {
                Indexer.this.handleEntitiesDeleted(events);
            }
        };
        this.fLabelListener = new LabelAdapter(){

            @Override
            public void entitiesUpdated(Set<LabelEvent> events) {
                ISearchField searchField = Owl.getModelFactory().createSearchField(15, INews.class.getName());
                HashSet<Long> newsIndexed = new HashSet<Long>();
                for (LabelEvent labelEvent : events) {
                    ILabel oldLabel = labelEvent.getOldLabel();
                    ILabel updatedLabel = labelEvent.getEntity();
                    if (oldLabel == null || oldLabel.getName().equals(updatedLabel.getName())) continue;
                    ISearchCondition searchCondition = Owl.getModelFactory().createSearchCondition(searchField, SearchSpecifier.IS, oldLabel.getName());
                    List<SearchHit<NewsReference>> hits = Owl.getPersistenceService().getModelSearch().searchNews(Collections.singletonList(searchCondition), true);
                    ArrayList<INews> newsList = new ArrayList<INews>(hits.size());
                    for (SearchHit<NewsReference> hit : hits) {
                        INews news = hit.getResult().resolve();
                        if (news != null && news.isVisible()) {
                            if (newsIndexed.contains(news.getId())) continue;
                            newsList.add(news);
                            newsIndexed.add(news.getId());
                            continue;
                        }
                        CoreUtils.reportIndexIssue();
                    }
                    if (newsList.isEmpty()) continue;
                    if (!InternalOwl.TESTING) {
                        Indexer.this.fJobQueue.schedule(new IndexingTask(Indexer.this, newsList, EventType.UPDATE));
                        continue;
                    }
                    new IndexingTask(Indexer.this, newsList, EventType.UPDATE).run((IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
        InternalOwl.getDefault().getPersistenceService().getDAOService().getNewsDAO().addEntityListener(this.fNewsListener);
        InternalOwl.getDefault().getPersistenceService().getDAOService().getLabelDAO().addEntityListener(this.fLabelListener);
    }

    private void handleEntityEvents(Set<NewsEvent> events, EventType eventType) {
        if (!InternalOwl.TESTING) {
            this.fJobQueue.schedule(new IndexingTask(this, events, eventType));
        } else {
            new IndexingTask(this, events, eventType).run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void handleEntitiesAdded(Set<NewsEvent> events) {
        this.handleEntityEvents(events, EventType.PERSIST);
    }

    private void handleEntitiesUpdated(Set<NewsEvent> events) {
        this.handleEntityEvents(events, EventType.UPDATE);
    }

    private void handleEntitiesDeleted(Set<NewsEvent> events) {
        this.handleEntityEvents(events, EventType.REMOVE);
    }

    private void unregisterListeners() {
        if (this.fNewsListener != null) {
            Owl.getPersistenceService().getDAOService().getNewsDAO().removeEntityListener(this.fNewsListener);
        }
        if (this.fLabelListener != null) {
            Owl.getPersistenceService().getDAOService().getLabelDAO().removeEntityListener(this.fLabelListener);
        }
        this.fNewsListener = null;
    }

    private IndexWriter createIndexWriter(Directory directory, boolean create) throws IOException {
        IndexWriter indexWriter = new IndexWriter(directory, false, Indexer.createAnalyzer(), create);
        indexWriter.setMergeFactor(6);
        this.fFlushRequired = false;
        return indexWriter;
    }

    private Term createTerm(ModelReference reference) {
        String value = String.valueOf(reference.getId());
        return new Term(SearchDocument.ENTITY_ID_TEXT, value);
    }

    private Term createTerm(IEntity entity) {
        String value = String.valueOf(entity.getId());
        return new Term(SearchDocument.ENTITY_ID_TEXT, value);
    }

    private void dispose() throws PersistenceException {
        if (this.fIndexWriter == null) {
            return;
        }
        try {
            this.fIndexWriter.close();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        this.fIndexWriter = null;
        this.fFlushRequired = false;
    }

    private static void saveCommittedNews(boolean sync, final EntityIdsByEventType uncommittedNews) {
        if (uncommittedNews.size() == 0) {
            return;
        }
        if (sync || InternalOwl.TESTING) {
            Indexer.doSaveCommittedNews(uncommittedNews);
        } else {
            Job job = new Job(Messages.Indexer_SAVE_INDEXER){

                protected IStatus run(IProgressMonitor monitor) {
                    Indexer.doSaveCommittedNews(uncommittedNews);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private static void doSaveCommittedNews(EntityIdsByEventType uncommittedNews) {
        EntityIdsByEventType newsToBeIndexed;
        EntitiesToBeIndexedDAOImpl dao = DBHelper.getEntitiesToBeIndexedDAO();
        if (dao != null && (newsToBeIndexed = dao.load()) != null) {
            newsToBeIndexed.removeAll(uncommittedNews.getPersistedEntityIds(), uncommittedNews.getUpdatedEntityIds(), uncommittedNews.getRemovedEntityIds());
            dao.save(newsToBeIndexed);
        }
    }

    private static class DefaultAnalyzer
    extends KeywordAnalyzer {
        private DefaultAnalyzer() {
        }

        public TokenStream tokenStream(String fieldName, Reader reader) {
            TokenStream result = super.tokenStream(fieldName, reader);
            result = new LowerCaseFilter(result);
            return result;
        }

        public TokenStream reusableTokenStream(String fieldName, Reader reader) {
            return this.tokenStream(fieldName, reader);
        }
    }
}

