/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.search;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.NumberTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.persist.search.Indexer;
import org.rssowl.core.internal.persist.search.LowercaseWhitespaceAnalyzer;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.reference.BookMarkReference;
import org.rssowl.core.persist.reference.FolderReference;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSearchQueries {
    private static final String MAX_DATE = DateTools.dateToString((Date)new Date(Long.MAX_VALUE), (DateTools.Resolution)DateTools.Resolution.DAY);
    private static final String MIN_DATE = DateTools.dateToString((Date)new Date(0L), (DateTools.Resolution)DateTools.Resolution.DAY);
    private static final String MAX_NUMBER = NumberTools.longToString((long)Long.MAX_VALUE);
    private static final String MIN_NUMBER = NumberTools.longToString((long)Long.MIN_VALUE);
    private static final Long DAY = 86400000L;
    private static final Long MINUTE = 60000L;
    private static final char STRING_WILDCARD = '*';
    private static final char CHAR_WILDCARD = '?';

    public static Query createQuery(ISearch search) throws IOException {
        return ModelSearchQueries.createQuery(search.getSearchConditions(), null, search.matchAllConditions());
    }

    public static Query createQuery(Collection<ISearchCondition> conditions, ISearchCondition scope, boolean matchAllConditions) throws IOException {
        try {
            return ModelSearchQueries.internalCreateQuery(conditions, scope, matchAllConditions);
        }
        catch (BooleanQuery.TooManyClauses e) {
            if (BooleanQuery.getMaxClauseCount() != 65536) {
                BooleanQuery.setMaxClauseCount((int)65536);
                return ModelSearchQueries.internalCreateQuery(conditions, scope, matchAllConditions);
            }
            throw e;
        }
    }

    private static Query internalCreateQuery(Collection<ISearchCondition> conditions, ISearchCondition scope, boolean matchAllConditions) throws IOException {
        boolean isScoped = false;
        BooleanQuery bQuery = new BooleanQuery();
        Analyzer analyzer = Indexer.createAnalyzer();
        for (ISearchCondition condition : conditions) {
            BooleanQuery locationScopeClause;
            if (!ModelSearchQueries.isLocationScopeCondition(condition) || (locationScopeClause = ModelSearchQueries.createLocationClause(condition)).clauses().isEmpty()) continue;
            bQuery.add((Query)locationScopeClause, BooleanClause.Occur.MUST);
            isScoped = true;
        }
        if (scope != null) {
            ModelSearchQueries.addFieldClauses(Collections.singleton(scope), true, bQuery, analyzer);
            isScoped = true;
        }
        BooleanQuery fieldQuery = bQuery;
        if (isScoped) {
            fieldQuery = new BooleanQuery();
        }
        ModelSearchQueries.addFieldClauses(conditions, matchAllConditions, fieldQuery, analyzer);
        if (isScoped && !fieldQuery.clauses().isEmpty()) {
            bQuery.add((Query)fieldQuery, BooleanClause.Occur.MUST);
        }
        return bQuery;
    }

    private static void addFieldClauses(Collection<ISearchCondition> conditions, boolean matchAllConditions, BooleanQuery bQuery, Analyzer analyzer) throws IOException {
        BooleanClause clause;
        BooleanQuery statesQuery = null;
        for (ISearchCondition condition : conditions) {
            if (!ModelSearchQueries.requiresStateGrouping(condition)) continue;
            if (statesQuery == null) {
                statesQuery = new BooleanQuery();
                bQuery.add((Query)statesQuery, matchAllConditions ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
            }
            ModelSearchQueries.addStateClause(statesQuery, condition);
        }
        BooleanQuery fieldQuery = null;
        for (ISearchCondition condition : conditions) {
            if (ModelSearchQueries.requiresStateGrouping(condition) || ModelSearchQueries.isLocationScopeCondition(condition)) continue;
            if (fieldQuery == null) {
                fieldQuery = new BooleanQuery();
                bQuery.add((Query)fieldQuery, matchAllConditions ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
            }
            clause = null;
            clause = condition.getField().getId() == -1 ? ModelSearchQueries.createAllNewsFieldsClause(analyzer, condition, matchAllConditions) : ModelSearchQueries.createBooleanClause(analyzer, condition, matchAllConditions);
            Query query = clause.getQuery();
            if (query instanceof BooleanQuery && ((BooleanQuery)query).clauses().isEmpty()) continue;
            if (condition.getSpecifier().isNegation() && !matchAllConditions) {
                BooleanQuery nestedquery = new BooleanQuery();
                nestedquery.add(clause);
                nestedquery.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST));
                fieldQuery.add(new BooleanClause((Query)nestedquery, BooleanClause.Occur.SHOULD));
                continue;
            }
            fieldQuery.add(clause);
        }
        if (fieldQuery != null && matchAllConditions) {
            BooleanClause[] clauses;
            boolean requireAllDocsQuery = true;
            BooleanClause[] booleanClauseArray = clauses = fieldQuery.getClauses();
            int n = clauses.length;
            int n2 = 0;
            while (n2 < n) {
                clause = booleanClauseArray[n2];
                if (clause.getOccur() != BooleanClause.Occur.MUST_NOT) {
                    requireAllDocsQuery = false;
                    break;
                }
                ++n2;
            }
            if (requireAllDocsQuery) {
                fieldQuery.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST));
            }
        }
    }

    private static void addStateClause(BooleanQuery statesQuery, ISearchCondition condition) {
        String fieldName = String.valueOf(14);
        BooleanClause.Occur occur = condition.getSpecifier().isNegation() ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.SHOULD;
        EnumSet newsStates = (EnumSet)condition.getValue();
        for (INews.State state : newsStates) {
            String value = String.valueOf(state.ordinal());
            TermQuery stateQuery = new TermQuery(new Term(fieldName, value));
            statesQuery.add(new BooleanClause((Query)stateQuery, occur));
        }
        if (condition.getSpecifier().isNegation()) {
            statesQuery.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST));
        }
    }

    private static boolean requiresStateGrouping(ISearchCondition condition) {
        return condition.getField().getId() == 14;
    }

    private static boolean isLocationScopeCondition(ISearchCondition condition) {
        return condition.getSpecifier() == SearchSpecifier.SCOPE;
    }

    private static BooleanClause createAllNewsFieldsClause(Analyzer analyzer, ISearchCondition condition, boolean matchAllConditions) throws IOException {
        IModelFactory factory = Owl.getModelFactory();
        BooleanQuery allFieldsQuery = new BooleanQuery();
        if (condition.getSpecifier() == SearchSpecifier.CONTAINS_ALL) {
            ArrayList<ISearchCondition> tokenConditions = new ArrayList<ISearchCondition>();
            List<String> tokens = StringUtils.tokenizePhraseAware((String)condition.getValue(), true);
            for (String token : tokens) {
                ISearchCondition tokenCondition = factory.createSearchCondition(condition.getField(), condition.getSpecifier(), token);
                if (condition.getSpecifier() == SearchSpecifier.CONTAINS_ALL) {
                    tokenCondition.setSpecifier(SearchSpecifier.CONTAINS);
                } else {
                    tokenCondition.setSpecifier(SearchSpecifier.CONTAINS_NOT);
                }
                tokenConditions.add(tokenCondition);
            }
            for (ISearchCondition tokenCondition : tokenConditions) {
                BooleanClause tokenClause = ModelSearchQueries.createAllNewsFieldsClause(analyzer, tokenCondition, matchAllConditions);
                if (tokenClause.getQuery() instanceof BooleanQuery && ((BooleanQuery)tokenClause.getQuery()).getClauses().length == 0) continue;
                tokenClause.setOccur(BooleanClause.Occur.MUST);
                allFieldsQuery.add(tokenClause);
            }
        } else {
            ArrayList<ISearchCondition> allFieldsConditions = new ArrayList<ISearchCondition>(5);
            ISearchField field = factory.createSearchField(0, condition.getField().getEntityName());
            allFieldsConditions.add(factory.createSearchCondition(field, condition.getSpecifier(), condition.getValue()));
            field = factory.createSearchField(2, condition.getField().getEntityName());
            allFieldsConditions.add(factory.createSearchCondition(field, condition.getSpecifier(), condition.getValue()));
            field = factory.createSearchField(3, condition.getField().getEntityName());
            allFieldsConditions.add(factory.createSearchCondition(field, condition.getSpecifier(), condition.getValue()));
            field = factory.createSearchField(12, condition.getField().getEntityName());
            List<String> tokens = StringUtils.tokenizePhraseAware(condition.getValue().toString(), false);
            if (!tokens.contains(condition.getValue().toString())) {
                tokens.add(condition.getValue().toString());
            }
            for (String token : tokens) {
                if (token.length() == 0) continue;
                allFieldsConditions.add(factory.createSearchCondition(field, condition.getSpecifier().isNegation() ? SearchSpecifier.IS_NOT : SearchSpecifier.IS, token));
            }
            field = factory.createSearchField(11, condition.getField().getEntityName());
            allFieldsConditions.add(factory.createSearchCondition(field, condition.getSpecifier(), condition.getValue()));
            boolean anyClauseIsEmpty = false;
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (ISearchCondition allFieldCondition : allFieldsConditions) {
                BooleanClause clause = ModelSearchQueries.createBooleanClause(analyzer, allFieldCondition, matchAllConditions);
                clause.setOccur(BooleanClause.Occur.SHOULD);
                clauses.add(clause);
                if (!(clause.getQuery() instanceof BooleanQuery) || ((BooleanQuery)clause.getQuery()).getClauses().length != 0) continue;
                anyClauseIsEmpty = true;
            }
            if (!anyClauseIsEmpty) {
                for (BooleanClause clause : clauses) {
                    allFieldsQuery.add(clause);
                }
            }
        }
        BooleanClause.Occur occur = ModelSearchQueries.getOccur(condition.getSpecifier(), matchAllConditions);
        return new BooleanClause((Query)allFieldsQuery, occur);
    }

    private static Query createWildcardQuery(String field, String term) {
        if (String.valueOf(15).equals(field) || ModelSearchQueries.isValidWildcardTerm(term)) {
            return new WildcardQuery(new Term(field, term));
        }
        return new TermQuery(new Term(field, term));
    }

    private static boolean isValidWildcardTerm(String term) {
        int i = 0;
        while (i < term.length()) {
            char charAtIndex = term.charAt(i);
            if (charAtIndex != '*' && charAtIndex != '?') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static BooleanClause createBooleanClause(Analyzer analyzer, ISearchCondition condition, boolean matchAllConditions) throws IOException {
        Query query = null;
        if (condition.getField().getId() == 18 || condition.getField().getId() == 21) {
            query = ModelSearchQueries.createAgeClause(condition);
        } else if (condition.getField().getId() == 19) {
            query = ModelSearchQueries.createLocationClause(condition);
        } else {
            try {
                switch (condition.getField().getSearchValueType().getId()) {
                    case 6: {
                        query = ModelSearchQueries.createTermQuery(condition);
                        break;
                    }
                    case 0: 
                    case 7: 
                    case 8: {
                        query = ModelSearchQueries.createStringQuery(analyzer, condition);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        query = ModelSearchQueries.createDateQuery(condition);
                        break;
                    }
                    case 4: 
                    case 5: {
                        query = ModelSearchQueries.createNumberQuery(condition);
                    }
                }
            }
            catch (ParseException e) {
                Activator.getDefault().getLog().log(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
        }
        if (query == null) {
            query = ModelSearchQueries.createTermQuery(condition);
        }
        BooleanClause.Occur occur = ModelSearchQueries.getOccur(condition.getSpecifier(), matchAllConditions);
        return new BooleanClause(query, occur);
    }

    private static Query createAgeClause(ISearchCondition condition) {
        Integer age = (Integer)condition.getValue();
        if (age < 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(System.currentTimeMillis() + (long)age.intValue() * MINUTE);
            String value = DateTools.dateToString((Date)cal.getTime(), (DateTools.Resolution)DateTools.Resolution.MINUTE);
            String fieldname = String.valueOf(21);
            return ModelSearchQueries.createAgeQuery(condition, fieldname, value);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis() - (long)age.intValue() * DAY);
        String value = DateTools.dateToString((Date)cal.getTime(), (DateTools.Resolution)DateTools.Resolution.DAY);
        String fieldname = String.valueOf(18);
        return ModelSearchQueries.createAgeQuery(condition, fieldname, value);
    }

    private static Query createAgeQuery(ISearchCondition condition, String fieldname, String value) {
        switch (condition.getSpecifier()) {
            case IS: {
                return new TermQuery(new Term(fieldname, value));
            }
            case IS_GREATER_THAN: {
                Term lowerBound = new Term(fieldname, MIN_DATE);
                Term upperBound = new Term(fieldname, value);
                return new ConstantScoreRangeQuery(fieldname, lowerBound.text(), upperBound.text(), false, false);
            }
            case IS_LESS_THAN: {
                Term lowerBound = new Term(fieldname, value);
                Term upperBound = new Term(fieldname, MAX_DATE);
                return new ConstantScoreRangeQuery(fieldname, lowerBound.text(), upperBound.text(), false, false);
            }
        }
        throw new UnsupportedOperationException("Unsupported Specifier for Age Query");
    }

    private static BooleanQuery createLocationClause(ISearchCondition condition) {
        BooleanQuery bQuery = new BooleanQuery();
        Long[][] value = (Long[][])condition.getValue();
        if (value != null) {
            int i = 0;
            while (value[0] != null && i < value[0].length) {
                IFolder folder;
                if (value[0][i] != null && (folder = new FolderReference(value[0][i]).resolve()) != null) {
                    ModelSearchQueries.addFolderLocationClause(bQuery, folder);
                }
                ++i;
            }
            i = 0;
            while (value[1] != null && i < value[1].length) {
                IBookMark bookmark;
                if (value[1][i] != null && (bookmark = new BookMarkReference(value[1][i]).resolve()) != null) {
                    ModelSearchQueries.addBookMarkLocationClause(bQuery, bookmark);
                }
                ++i;
            }
            if (value.length == 3) {
                i = 0;
                while (value[2] != null && i < value[2].length) {
                    INewsBin newsbin;
                    if (value[2][i] != null && (newsbin = new NewsBinReference(value[2][i]).resolve()) != null) {
                        ModelSearchQueries.addNewsBinLocationClause(bQuery, newsbin);
                    }
                    ++i;
                }
            }
        }
        if (bQuery.clauses().isEmpty()) {
            bQuery.add((Query)new TermQuery(new Term(String.valueOf(17), "")), BooleanClause.Occur.SHOULD);
        }
        return bQuery;
    }

    private static void addFolderLocationClause(BooleanQuery bQuery, IFolder folder) {
        if (folder != null) {
            List<IFolder> folders = folder.getFolders();
            List<IMark> marks = folder.getMarks();
            for (IFolder childFolder : folders) {
                ModelSearchQueries.addFolderLocationClause(bQuery, childFolder);
            }
            for (IMark mark : marks) {
                if (mark instanceof IBookMark) {
                    ModelSearchQueries.addBookMarkLocationClause(bQuery, (IBookMark)mark);
                    continue;
                }
                if (!(mark instanceof INewsBin)) continue;
                ModelSearchQueries.addNewsBinLocationClause(bQuery, (INewsBin)mark);
            }
        }
    }

    private static void addBookMarkLocationClause(BooleanQuery bQuery, IBookMark bookmark) {
        if (bookmark != null) {
            BooleanQuery bookMarkLocationQuery = new BooleanQuery();
            String feed = bookmark.getFeedLinkReference().getLinkAsText().toLowerCase();
            bookMarkLocationQuery.add((Query)new TermQuery(new Term(String.valueOf(17), feed)), BooleanClause.Occur.MUST);
            bookMarkLocationQuery.add((Query)new TermQuery(new Term(String.valueOf(20), NumberTools.longToString((long)0L))), BooleanClause.Occur.MUST);
            bQuery.add((Query)bookMarkLocationQuery, BooleanClause.Occur.SHOULD);
        }
    }

    private static void addNewsBinLocationClause(BooleanQuery bQuery, INewsBin newsbin) {
        if (newsbin != null) {
            bQuery.add((Query)new TermQuery(new Term(String.valueOf(20), NumberTools.longToString((long)newsbin.getId()))), BooleanClause.Occur.SHOULD);
        }
    }

    private static Query createStringQuery(Analyzer analyzer, ISearchCondition condition) throws ParseException, IOException {
        SearchSpecifier specifier = condition.getSpecifier();
        String fieldname = String.valueOf(condition.getField().getId());
        String value = condition.getValue() instanceof Enum ? String.valueOf(((Enum)condition.getValue()).ordinal()) : String.valueOf(condition.getValue());
        switch (specifier) {
            case IS: 
            case IS_NOT: {
                return ModelSearchQueries.createWildcardQuery(fieldname, value.toLowerCase());
            }
            case CONTAINS: 
            case CONTAINS_NOT: 
            case CONTAINS_ALL: {
                QueryParser parser = new QueryParser(fieldname, analyzer);
                QueryParser.Operator operator = specifier == SearchSpecifier.CONTAINS || specifier == SearchSpecifier.CONTAINS_NOT ? QueryParser.OR_OPERATOR : QueryParser.AND_OPERATOR;
                parser.setDefaultOperator(operator);
                parser.setAllowLeadingWildcard(true);
                value = ModelSearchQueries.prepareForParsing(value);
                return parser.parse(value);
            }
            case BEGINS_WITH: {
                value = String.valueOf(value.toLowerCase()) + "*";
                return ModelSearchQueries.createWildcardQuery(fieldname, value);
            }
            case ENDS_WITH: {
                value = "*" + value.toLowerCase();
                return ModelSearchQueries.createWildcardQuery(fieldname, value);
            }
            case SIMILIAR_TO: {
                BooleanQuery similarityQuery = new BooleanQuery();
                LowercaseWhitespaceAnalyzer similarAnalyzer = new LowercaseWhitespaceAnalyzer();
                TokenStream tokenStream = similarAnalyzer.tokenStream(String.valueOf(-1), new StringReader(value));
                Token token = null;
                while ((token = tokenStream.next()) != null) {
                    String termText = new String(token.termBuffer(), 0, token.termLength());
                    Term term = new Term(fieldname, termText);
                    similarityQuery.add(new BooleanClause((Query)new FuzzyQuery(term), BooleanClause.Occur.MUST));
                }
                return similarityQuery;
            }
        }
        throw new UnsupportedOperationException("Unsupported Specifier for Parsed Queries");
    }

    private static Query createTermQuery(ISearchCondition condition) {
        String value = condition.getValue() instanceof Enum ? String.valueOf(((Enum)condition.getValue()).ordinal()) : String.valueOf(condition.getValue());
        String fieldname = String.valueOf(condition.getField().getId());
        Term term = new Term(fieldname, value);
        return new TermQuery(term);
    }

    private static Query createDateQuery(ISearchCondition condition) {
        SearchSpecifier specifier = condition.getSpecifier();
        String value = DateTools.dateToString((Date)((Date)condition.getValue()), (DateTools.Resolution)DateTools.Resolution.DAY);
        String fieldname = String.valueOf(condition.getField().getId());
        switch (specifier) {
            case IS: 
            case IS_NOT: {
                return new TermQuery(new Term(fieldname, value));
            }
            case IS_AFTER: {
                Term lowerBound = new Term(fieldname, value);
                Term upperBound = new Term(fieldname, MAX_DATE);
                return new ConstantScoreRangeQuery(fieldname, lowerBound.text(), upperBound.text(), false, false);
            }
            case IS_BEFORE: {
                Term lowerBound = new Term(fieldname, MIN_DATE);
                Term upperBound = new Term(fieldname, value);
                return new ConstantScoreRangeQuery(fieldname, lowerBound.text(), upperBound.text(), false, false);
            }
        }
        throw new UnsupportedOperationException("Unsupported Specifier for Date/Time Queries");
    }

    private static Query createNumberQuery(ISearchCondition condition) {
        SearchSpecifier specifier = condition.getSpecifier();
        String value = NumberTools.longToString((long)((Integer)condition.getValue()).intValue());
        String fieldname = String.valueOf(condition.getField().getId());
        switch (specifier) {
            case IS: 
            case IS_NOT: {
                return new TermQuery(new Term(fieldname, value));
            }
            case IS_GREATER_THAN: {
                Term lowerBound = new Term(fieldname, value);
                Term upperBound = new Term(fieldname, MAX_NUMBER);
                return new ConstantScoreRangeQuery(fieldname, lowerBound.text(), upperBound.text(), false, false);
            }
            case IS_LESS_THAN: {
                Term lowerBound = new Term(fieldname, MIN_NUMBER);
                Term upperBound = new Term(fieldname, value);
                return new ConstantScoreRangeQuery(fieldname, lowerBound.text(), upperBound.text(), false, false);
            }
        }
        throw new UnsupportedOperationException("Unsupported Specifier for Number Queries");
    }

    private static BooleanClause.Occur getOccur(SearchSpecifier specifier, boolean matchAllConditions) {
        switch (specifier) {
            case IS_NOT: 
            case CONTAINS_NOT: {
                return BooleanClause.Occur.MUST_NOT;
            }
        }
        return matchAllConditions ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD;
    }

    private static String prepareForParsing(String s) {
        int doubleQuoteCount = 0;
        boolean startsWithDoubleQuote = false;
        boolean endsWithDoubleQuote = false;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '{' || c == '}' || c == '~') {
                sb.append('\\');
            } else if (c == '\"') {
                ++doubleQuoteCount;
                if (i == 0) {
                    startsWithDoubleQuote = true;
                } else if (i == s.length() - 1) {
                    endsWithDoubleQuote = true;
                }
            }
            sb.append(c);
            ++i;
        }
        String escapedString = sb.toString();
        if (doubleQuoteCount % 2 != 0) {
            escapedString = escapedString.replace("\"", "\\\"");
            if (startsWithDoubleQuote && endsWithDoubleQuote) {
                escapedString = String.valueOf(escapedString.substring(1, escapedString.length() - 2)) + "\"";
            }
        }
        return escapedString;
    }
}

