/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.internal.persist.service.Messages;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.LongOperationMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BackupService {
    private static final int MIN_SIZE_FOR_PROGRESS = 0x6400000;
    private final File fFileToBackup;
    private final String fBackupFileSuffix;
    private final int fMaxBackupsCount;
    private final File fBackupTimestampFile;
    private final Long fBackupFrequency;
    private BackupLayoutStrategy fLayoutStrategy;
    private File fFileToBackupAlias;
    private BackupStrategy fBackupStrategy;

    public BackupService(File fileToBackup, String backupFileSuffix, int maxBackupsCount) {
        this(fileToBackup, backupFileSuffix, maxBackupsCount, null, null);
    }

    public BackupService(File fileToBackup, String backupFileSuffix, int maxBackupsCount, File backupTimestampFile, Long backupFrequency) {
        Assert.isNotNull((Object)fileToBackup, (String)"fileToBackup");
        Assert.isLegal((boolean)fileToBackup.isFile(), (String)("fileToBackup must be a file: " + fileToBackup.getAbsolutePath()));
        Assert.isLegal((backupFileSuffix != null && backupFileSuffix.length() > 0 ? 1 : 0) != 0, (String)"backupSuffix should contain a non-empty String");
        Assert.isLegal((maxBackupsCount > 0 ? 1 : 0) != 0, (String)"filesKeptCount should be higher than 0");
        if (backupFrequency != null) {
            Assert.isNotNull((Object)backupTimestampFile, (String)"backupTimestampFile should not be null if backupFrequency is not null");
        }
        this.fFileToBackup = fileToBackup;
        this.fBackupFileSuffix = backupFileSuffix;
        this.fMaxBackupsCount = maxBackupsCount;
        this.fBackupTimestampFile = backupTimestampFile;
        this.fBackupFrequency = backupFrequency;
        this.fLayoutStrategy = new DefaultBackupLayoutStrategy(this.getBackupFile());
        this.fBackupStrategy = new BackupStrategy(){

            public void backup(File originFile, File destinationFile, IProgressMonitor monitor) {
                if (originFile.length() > 0x6400000L && monitor instanceof LongOperationMonitor && !((LongOperationMonitor)monitor).isLongOperationRunning()) {
                    ((LongOperationMonitor)monitor).beginLongOperation(true);
                    int chunks = (int)(originFile.length() / 32768L);
                    monitor.beginTask(Messages.DBManager_PROGRESS_WAIT, chunks);
                    monitor.subTask(Messages.DBManager_CREATING_DB_BACKUP);
                }
                DBHelper.copyFileIO(originFile, destinationFile, monitor);
                if (monitor.isCanceled()) {
                    destinationFile.delete();
                }
            }
        };
    }

    public void setBackupStrategy(BackupStrategy backupStrategy) {
        this.fBackupStrategy = backupStrategy;
    }

    public void setFileToBackupAlias(File alias) {
        Assert.isLegal((boolean)alias.isFile(), (String)"alias must be a file");
        this.fFileToBackupAlias = alias;
    }

    public void setLayoutStrategy(BackupLayoutStrategy layoutStrategy) {
        this.fLayoutStrategy = layoutStrategy;
    }

    public File getFileToBackup() {
        return this.fFileToBackup;
    }

    private void prepareBackup() {
        File backupFile = this.getBackupFile();
        List<File> backupFiles = this.fLayoutStrategy.findBackupFiles();
        this.deleteOldBackups(backupFiles);
        if (!backupFiles.isEmpty()) {
            this.fLayoutStrategy.rotateBackups(backupFiles);
        }
        Assert.isLegal((!backupFile.exists() ? 1 : 0) != 0, (String)("backupFile should have been rotated or deleted: " + backupFile));
    }

    public boolean backup(boolean force, IProgressMonitor monitor) throws PersistenceException {
        if (!this.shouldBackup(force)) {
            return false;
        }
        boolean backupSuccess = false;
        try {
            this.prepareBackup();
            File sourceFile = this.fFileToBackup;
            if (this.fFileToBackupAlias != null) {
                sourceFile = this.fFileToBackupAlias;
            }
            this.fBackupStrategy.backup(sourceFile, this.getBackupFile(), monitor);
            backupSuccess = true;
        }
        finally {
            if (backupSuccess || !force) {
                this.writeBackupTimestamp();
            }
        }
        return true;
    }

    private boolean shouldBackup(boolean force) {
        if (force) {
            return true;
        }
        if (!this.fBackupTimestampFile.exists()) {
            this.writeBackupTimestamp();
            return false;
        }
        try {
            long lastBackupTimestamp = Long.parseLong(DBHelper.readFirstLineFromFile(this.fBackupTimestampFile));
            long now = System.currentTimeMillis();
            return now - lastBackupTimestamp >= this.fBackupFrequency;
        }
        catch (NumberFormatException e) {
            throw new PersistenceException(String.valueOf(this.fBackupTimestampFile.getAbsolutePath()) + " does not contain a number for the date as expected", e);
        }
    }

    private void writeBackupTimestamp() {
        if (this.fBackupTimestampFile == null) {
            return;
        }
        if (!this.fBackupTimestampFile.exists()) {
            try {
                this.fBackupTimestampFile.createNewFile();
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to create new file", e);
            }
        }
        DBHelper.writeToFile(this.fBackupTimestampFile, String.valueOf(System.currentTimeMillis()));
    }

    public File getBackupFile() {
        String backupFilePath = String.valueOf(this.fFileToBackup.getAbsolutePath()) + this.fBackupFileSuffix;
        File backupFile = new File(backupFilePath);
        return backupFile;
    }

    public File getBackupFile(int index) {
        List<File> backupFiles = this.fLayoutStrategy.findBackupFiles();
        if (index >= backupFiles.size()) {
            return null;
        }
        return backupFiles.get(index);
    }

    public File getTempBackupFile() {
        return new File(String.valueOf(this.getBackupFile().getAbsolutePath()) + ".temp");
    }

    public File getWeeklyBackupFile() {
        return new File(String.valueOf(this.getBackupFile().getAbsolutePath()) + ".weekly");
    }

    public File getCorruptedFile(Integer index) {
        String fileName = String.valueOf(this.getFileToBackup().getAbsolutePath()) + ".corrupted";
        if (index != null) {
            fileName = String.valueOf(fileName) + "." + index;
        }
        return new File(fileName);
    }

    private void deleteOldBackups(List<File> backupFiles) {
        while (backupFiles.size() > this.fMaxBackupsCount - 1) {
            File fileToDelete = backupFiles.remove(backupFiles.size() - 1);
            if (fileToDelete.delete()) continue;
            throw new PersistenceException("Failed to delete file: " + fileToDelete);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface BackupLayoutStrategy {
        public List<File> findBackupFiles();

        public void rotateBackups(List<File> var1);
    }

    static interface BackupStrategy {
        public void backup(File var1, File var2, IProgressMonitor var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultBackupLayoutStrategy
    implements BackupLayoutStrategy {
        private final File fBackupFile;

        DefaultBackupLayoutStrategy(File backupFile) {
            this.fBackupFile = backupFile;
        }

        @Override
        public List<File> findBackupFiles() {
            int index = 0;
            ArrayList<File> backupFiles = new ArrayList<File>(5);
            File tempFile = this.fBackupFile;
            while (tempFile.exists()) {
                backupFiles.add(tempFile);
                tempFile = new File(String.valueOf(this.fBackupFile.getAbsolutePath()) + "." + index++);
            }
            return backupFiles;
        }

        @Override
        public void rotateBackups(List<File> backupFiles) {
            while (backupFiles.size() > 0) {
                File newFile;
                int index = backupFiles.size() - 1;
                File fileToRename = backupFiles.remove(index);
                if (fileToRename.renameTo(newFile = new File(String.valueOf(this.fBackupFile.getAbsolutePath()) + "." + index))) continue;
                throw new PersistenceException("Failed to rename file from " + fileToRename + " to " + newFile);
            }
        }
    }
}

