/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.service;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.config.ObjectClass;
import com.db4o.config.ObjectField;
import com.db4o.config.ObjectTranslator;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.config.TSerializable;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.query.Query;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.internal.persist.BookMark;
import org.rssowl.core.internal.persist.ConditionalGet;
import org.rssowl.core.internal.persist.Description;
import org.rssowl.core.internal.persist.Feed;
import org.rssowl.core.internal.persist.Folder;
import org.rssowl.core.internal.persist.Label;
import org.rssowl.core.internal.persist.News;
import org.rssowl.core.internal.persist.NewsBin;
import org.rssowl.core.internal.persist.Preference;
import org.rssowl.core.internal.persist.SearchFilter;
import org.rssowl.core.internal.persist.migration.MigrationResult;
import org.rssowl.core.internal.persist.migration.Migrations;
import org.rssowl.core.internal.persist.service.BackupService;
import org.rssowl.core.internal.persist.service.ConfigurationFactory;
import org.rssowl.core.internal.persist.service.Counter;
import org.rssowl.core.internal.persist.service.DB4OIDGenerator;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.internal.persist.service.DatabaseEvent;
import org.rssowl.core.internal.persist.service.DatabaseListener;
import org.rssowl.core.internal.persist.service.EntityIdsByEventType;
import org.rssowl.core.internal.persist.service.EventManager;
import org.rssowl.core.internal.persist.service.Messages;
import org.rssowl.core.internal.persist.service.Migration;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.NewsCounter;
import org.rssowl.core.persist.NewsCounterItem;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.DiskFullException;
import org.rssowl.core.persist.service.IModelSearch;
import org.rssowl.core.persist.service.InsufficientFilePermissionException;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.persist.service.ProfileLockedException;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.LongOperationMonitor;
import org.rssowl.core.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBManager {
    private static final String FORMAT_FILE_NAME = "format2";
    private static final String DB_NAME = "rssowl.db";
    private static final String DB_RESTORE_NAME = "rssowl.db.restore";
    private static DBManager fInstance;
    private static final long LARGE_DB_STARTING_SIZE = 0x60000000L;
    private static final int LARGE_DB_BLOCK_SIZE = 8;
    private static final boolean ENABLE_MIGRATION = false;
    private static final String TMP_BACKUP_NAME = "tmp.bak";
    private static final String DEFRAGMENT_MARKER = "defragment";
    private static final String LARGE_BLOCK_SIZE_MARKER = "largeblocksize";
    private static final String ONLINE_RUNNING_BACKUP_MARKER = "onlinebakmarker";
    private static final String CLEANUP_INDEX_MARKER = "cleanupindex";
    private static final String REINDEX_MARKER = "reindex";
    private static final String REINDEX_RUNNING_MARKER = "reindexmarker";
    private static final boolean PERFORM_SCHEDULED_BACKUPS = false;
    private static final int MAX_OFFLINE_BACKUPS_COUNT = 1;
    private static final int MAX_ONLINE_BACKUPS_COUNT = 1;
    private static final int MAX_ONLINE_BACKUP_AGE = 604800000;
    private static final String RESTORE_BACKUP_NAME = ".restorebak";
    private static final String ONLINE_BACKUP_NAME = ".onlinebak";
    private static final String OFFLINE_BACKUP_NAME = ".backup";
    private static final int OFFLINE_BACKUP_INTERVAL = 604800000;
    private static final int ONLINE_BACKUP_SCHEDULE_INTERVAL = 300000;
    private static final int ONLINE_BACKUP_DELAY_THRESHOLD = 1800000;
    private static final int ONLINE_BACKUP_SHORT_INTERVAL = 3300000;
    private static final int ONLINE_BACKUP_LONG_INTERVAL = 36000000;
    private static final int DEFRAG_TOTAL_WORK = 10000000;
    private static final int DEFRAG_SUB_WORK_LABELS = 100000;
    private static final int DEFRAG_SUB_WORK_FOLDERS = 500000;
    private static final int DEFRAG_SUB_WORK_BINS = 1000000;
    private static final int DEFRAG_SUB_WORK_FEEDS = 3000000;
    private static final int DEFRAG_SUB_WORK_DESCRIPTIONS = 3000000;
    private static final int DEFRAG_SUB_WORK_PREFERENCES = 100000;
    private static final int DEFRAG_SUB_WORK_FILTERS = 100000;
    private static final int DEFRAG_SUB_WORK_CONDITIONAL_GET = 100000;
    private static final int DEFRAG_SUB_WORK_COUNTERS = 100000;
    private static final int DEFRAG_SUB_WORK_EVENTS = 100000;
    private static final int DEFRAG_SUB_WORK_COMMITT_DESTINATION = 300000;
    private static final int DEFRAG_SUB_WORK_CLOSE_DESTINATION = 100000;
    private static final int DEFRAG_SUB_WORK_CLOSE_SOURCE = 100000;
    private static final int DEFRAG_SUB_WORK_FINISH = 100000;
    private ObjectContainer fObjectContainer;
    private final AtomicLong fNextOnlineBackup = new AtomicLong();
    private final ReadWriteLock fLock = new ReentrantReadWriteLock();
    private final List<DatabaseListener> fEntityStoreListeners = new CopyOnWriteArrayList<DatabaseListener>();

    public static DBManager getDefault() {
        if (fInstance == null) {
            fInstance = new DBManager();
        }
        return fInstance;
    }

    public void startup(LongOperationMonitor monitor, boolean emergency, boolean forRestore) throws PersistenceException {
        File restoreDBFile;
        EventManager.getInstance();
        if (!forRestore && (restoreDBFile = new File(DBManager.getDBRestoreFilePath())).exists()) {
            Activator.safeLogInfo("Start: Restoring a Backup (renaming rssowl.db.restore to rssowl.db");
            this.backupAndDeleteProfile();
            DBHelper.rename(restoreDBFile, new File(DBManager.getDBFilePath()));
            Activator.safeLogInfo("End: Restoring a Backup (renaming rssowl.db.restore to rssowl.db");
        }
        this.createDatabase(monitor, emergency, forRestore);
    }

    private void createDatabase(LongOperationMonitor progressMonitor, boolean emergency, boolean forRestore) throws PersistenceException {
        block21: {
            this.checkDirPermissions();
            SubMonitor subMonitor = null;
            MigrationResult migrationResult = new MigrationResult(false, false, false);
            try {
                if (!emergency) {
                    int workspaceVersion = this.getWorkspaceFormatVersion();
                    try {
                        if (this.getOnlineBackupMarkerFile().exists()) {
                            Activator.safeLogInfo("Detected an Online Backup that did not complete");
                            this.safeDelete(this.getOnlineBackupMarkerFile());
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (this.getReindexMarkerFile().exists()) {
                            Activator.safeLogInfo("Detected a Search Re-Indexing that did not complete");
                            this.safeDelete(this.getReindexMarkerFile());
                        }
                    }
                    catch (Exception exception) {}
                    if (!this.defragmentIfNecessary(progressMonitor, subMonitor) && migrationResult.isDefragmentDatabase()) {
                        this.defragment(false, progressMonitor, subMonitor);
                    }
                }
                Configuration config = DBManager.createConfiguration(false);
                this.createObjectContainer(config, forRestore);
                this.fireDatabaseEvent(new DatabaseEvent(this.fObjectContainer, this.fLock), true);
                if (emergency) break block21;
                boolean reindexed = false;
                boolean shouldReindex = this.shouldReindex(migrationResult);
                if (shouldReindex) {
                    progressMonitor.beginLongOperation(false);
                    subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.DBManager_PROGRESS_WAIT, (int)20);
                }
                IModelSearch modelSearch = InternalOwl.getDefault().getPersistenceService().getModelSearch();
                if (!progressMonitor.isCanceled() && (shouldReindex || migrationResult.isOptimizeIndex()) && shouldReindex && !progressMonitor.isCanceled()) {
                    Activator.safeLogInfo("Start: Search Re-Indexing");
                    File marker = this.getReindexMarkerFile();
                    File reIndexFile = this.getReIndexFile();
                    try {
                        if (!marker.exists()) {
                            this.safeCreate(marker);
                        }
                        reindexed = true;
                        modelSearch.reindexAll((IProgressMonitor)(subMonitor != null ? subMonitor.newChild(20) : new NullProgressMonitor()));
                        if (reIndexFile.exists()) {
                            this.safeDelete(reIndexFile);
                        }
                    }
                    finally {
                        this.safeDelete(marker);
                    }
                    Activator.safeLogInfo("Finished: Search Re-Indexing");
                }
                File cleanUpIndexFile = this.getCleanUpIndexFile();
                if (!reindexed && cleanUpIndexFile.exists() && !progressMonitor.isCanceled()) {
                    progressMonitor.beginLongOperation(false);
                    subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.DBManager_PROGRESS_WAIT, (int)20);
                    modelSearch = InternalOwl.getDefault().getPersistenceService().getModelSearch();
                    modelSearch.startup();
                    if (!progressMonitor.isCanceled()) {
                        Activator.safeLogInfo("Start: Search Clean-Up");
                        modelSearch.cleanUp((IProgressMonitor)(subMonitor != null ? subMonitor.newChild(20) : new NullProgressMonitor()));
                        this.safeDelete(cleanUpIndexFile);
                        Activator.safeLogInfo("Finished: Search Clean-Up");
                    }
                }
                final BackupService backupService = this.createOnlineBackupService();
                Job job = new Job("Online Backup Service"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        if (!Owl.isShuttingDown() && !monitor.isCanceled()) {
                            AtomicLong atomicLong = DBManager.this.fNextOnlineBackup;
                            synchronized (atomicLong) {
                                if (DBManager.this.shouldOnlineBackup() && !DBManager.this.delayOnlineBackup()) {
                                    try {
                                        backupService.backup(true, monitor);
                                        DBManager.this.fNextOnlineBackup.set(System.currentTimeMillis() + DBManager.this.getOnlineBackupDelay(false));
                                    }
                                    catch (PersistenceException e) {
                                        Activator.safeLogError(e.getMessage(), e);
                                    }
                                }
                            }
                            if (!Owl.isShuttingDown() && !monitor.isCanceled()) {
                                this.schedule(300000L);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule(300000L);
                this.fNextOnlineBackup.set(System.currentTimeMillis() + this.getOnlineBackupDelay(true));
            }
            finally {
                if (subMonitor != null) {
                    progressMonitor.done();
                }
            }
        }
    }

    private boolean shouldOnlineBackup() {
        return System.currentTimeMillis() >= this.fNextOnlineBackup.get();
    }

    private boolean delayOnlineBackup() {
        boolean delay;
        boolean bl = delay = System.currentTimeMillis() >= this.fNextOnlineBackup.get() + 1800000L;
        if (delay) {
            this.fNextOnlineBackup.set(System.currentTimeMillis() + 3300000L);
        }
        return delay;
    }

    private long getOnlineBackupDelay(boolean initial) {
        if (initial) {
            return 3300000L;
        }
        return this.getLongProperty("rssowl.onlinebackup.interval", 36000000L);
    }

    private long getLongProperty(String propertyName, long defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            try {
                long longProperty = Long.parseLong(propertyValue);
                if (longProperty > 0L) {
                    return longProperty;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public void addEntityStoreListener(DatabaseListener listener) {
        if (listener instanceof EventManager) {
            this.fEntityStoreListeners.add(0, listener);
        } else if (listener instanceof DB4OIDGenerator) {
            if (!this.fEntityStoreListeners.isEmpty() && this.fEntityStoreListeners.get(0) instanceof EventManager) {
                this.fEntityStoreListeners.add(1, listener);
            } else {
                this.fEntityStoreListeners.add(0, listener);
            }
        } else {
            this.fEntityStoreListeners.add(listener);
        }
    }

    private void fireDatabaseEvent(DatabaseEvent event, boolean storeOpened) {
        for (DatabaseListener listener : this.fEntityStoreListeners) {
            if (storeOpened) {
                listener.databaseOpened(event);
                continue;
            }
            listener.databaseClosed(event);
        }
    }

    private void createObjectContainer(Configuration config, boolean forRestore) throws PersistenceException {
        try {
            this.fObjectContainer = Db4o.openFile((Configuration)config, (String)(forRestore ? DBManager.getDBRestoreFilePath() : DBManager.getDBFilePath()));
            if (this.fObjectContainer == null) {
                throw new PersistenceException(Messages.DBManager_UNABLE_TO_OPEN_PROFILE);
            }
            this.storeProfileLastUsed();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof PersistenceException) {
                throw (PersistenceException)e;
            }
            if (e instanceof DatabaseFileLockedException) {
                throw new ProfileLockedException(e.getMessage(), e);
            }
            File file = new File(DBManager.getDBFilePath());
            if (!file.exists()) {
                throw new DiskFullException(Messages.DBManager_DISK_FULL_ERROR, e);
            }
            if (!file.canRead() || !file.canWrite()) {
                throw new InsufficientFilePermissionException(NLS.bind((String)Messages.DBManager_FILE_PERMISSION_ERROR, (Object)file), null);
            }
            throw new PersistenceException(e);
        }
    }

    private void checkDirPermissions() {
        File dir = new File(Activator.getDefault().getStateLocation().toOSString());
        if (!dir.canRead() || !dir.canWrite()) {
            throw new InsufficientFilePermissionException(NLS.bind((String)Messages.DBManager_DIRECTORY_PERMISSION_ERROR, (Object)dir), null);
        }
    }

    private boolean shouldReindex(MigrationResult migrationResult) {
        boolean shouldReindex = migrationResult.isReindex();
        if (!shouldReindex && this.getReIndexFile().exists()) {
            shouldReindex = true;
        }
        if (shouldReindex) {
            System.setProperty("rssowl.reindex", "true");
            return true;
        }
        return Boolean.getBoolean("rssowl.reindex");
    }

    private BackupService createOnlineBackupService() {
        File file = new File(DBManager.getDBFilePath());
        if (!file.exists()) {
            return null;
        }
        final BackupService onlineBackupService = new BackupService(file, ONLINE_BACKUP_NAME, 1);
        onlineBackupService.setBackupStrategy(new BackupService.BackupStrategy(){

            public void backup(File originFile, File backupFile, IProgressMonitor monitor) {
                File marker = DBManager.this.getOnlineBackupMarkerFile();
                File tmpBackupFile = null;
                try {
                    if (Owl.isShuttingDown() || monitor.isCanceled()) {
                        return;
                    }
                    try {
                        if (!marker.exists()) {
                            DBManager.this.safeCreate(marker);
                        }
                        if ((tmpBackupFile = new File(backupFile.getParentFile(), DBManager.TMP_BACKUP_NAME)).exists() && !tmpBackupFile.delete()) {
                            throw new PersistenceException("Failed to delete file: " + tmpBackupFile);
                        }
                        DBManager.this.fObjectContainer.ext().backup(tmpBackupFile.getAbsolutePath());
                        File weeklyBackup = onlineBackupService.getWeeklyBackupFile();
                        boolean renameToWeekly = false;
                        if (!weeklyBackup.exists()) {
                            renameToWeekly = true;
                        } else if (weeklyBackup.lastModified() < System.currentTimeMillis() - 604800000L) {
                            renameToWeekly = true;
                        }
                        DBHelper.rename(tmpBackupFile, renameToWeekly ? weeklyBackup : backupFile);
                    }
                    catch (IOException e) {
                        throw new PersistenceException(e);
                    }
                }
                finally {
                    DBManager.this.safeDelete(marker);
                    if (tmpBackupFile != null && tmpBackupFile.exists()) {
                        DBManager.this.safeDelete(tmpBackupFile);
                    }
                }
            }
        });
        return onlineBackupService;
    }

    private void safeCreate(File file) {
        try {
            file.createNewFile();
        }
        catch (Exception exception) {}
    }

    private void safeDelete(File file) {
        try {
            file.delete();
        }
        catch (Exception exception) {}
    }

    public File getDefragmentFile() {
        File dir = new File(Activator.getDefault().getStateLocation().toOSString());
        return new File(dir, DEFRAGMENT_MARKER);
    }

    public static File getLargeBlockSizeMarkerFile() {
        File dir = new File(Activator.getDefault().getStateLocation().toOSString());
        return new File(dir, LARGE_BLOCK_SIZE_MARKER);
    }

    public File getOnlineBackupMarkerFile() {
        File dir = new File(Activator.getDefault().getStateLocation().toOSString());
        return new File(dir, ONLINE_RUNNING_BACKUP_MARKER);
    }

    public File getCleanUpIndexFile() {
        File dir = new File(Activator.getDefault().getStateLocation().toOSString());
        return new File(dir, CLEANUP_INDEX_MARKER);
    }

    public File getReIndexFile() {
        File dir = new File(Activator.getDefault().getStateLocation().toOSString());
        return new File(dir, REINDEX_MARKER);
    }

    public File getReindexMarkerFile() {
        File dir = new File(Activator.getDefault().getStateLocation().toOSString());
        return new File(dir, REINDEX_RUNNING_MARKER);
    }

    public static final String getDBFilePath() {
        String filePath = String.valueOf(Activator.getDefault().getStateLocation().toOSString()) + File.separator + DB_NAME;
        return filePath;
    }

    public static final String getDBRestoreFilePath() {
        String filePath = String.valueOf(Activator.getDefault().getStateLocation().toOSString()) + File.separator + DB_RESTORE_NAME;
        return filePath;
    }

    private File getDBFormatFile() {
        File dir = new File(Activator.getDefault().getStateLocation().toOSString());
        File formatFile = new File(dir, FORMAT_FILE_NAME);
        return formatFile;
    }

    public void removeEntityStoreListener(DatabaseListener listener) {
        this.fEntityStoreListeners.remove(listener);
    }

    private BackupService createScheduledBackupService(Long backupFrequency) {
        return new BackupService(new File(DBManager.getDBFilePath()), OFFLINE_BACKUP_NAME, 1, this.getDBLastBackUpFile(), backupFrequency);
    }

    private void scheduledBackup(IProgressMonitor monitor) {
        if (!new File(DBManager.getDBFilePath()).exists()) {
            return;
        }
        long sevenDays = this.getLongProperty("rssowl.offlinebackup.interval", 604800000L);
        try {
            this.createScheduledBackupService(sevenDays).backup(false, monitor);
        }
        catch (PersistenceException e) {
            Activator.safeLogError(e.getMessage(), e);
        }
    }

    public File getDBLastBackUpFile() {
        File dir = new File(Activator.getDefault().getStateLocation().toOSString());
        File lastBackUpFile = new File(dir, "lastbackup");
        return lastBackUpFile;
    }

    private File getDBLastUsedFile() {
        File dir = new File(Activator.getDefault().getStateLocation().toOSString());
        File lastDBUseFile = new File(dir, "lastused");
        return lastDBUseFile;
    }

    Long getProfileLastUsed() {
        File file = this.getDBLastUsedFile();
        if (file.exists()) {
            try {
                return Long.parseLong(DBHelper.readFirstLineFromFile(file));
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private void storeProfileLastUsed() {
        File file = this.getDBLastUsedFile();
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            DBHelper.writeToFile(file, String.valueOf(System.currentTimeMillis()));
        }
        catch (Exception exception) {}
    }

    private MigrationResult migrate(final int workspaceFormat, int currentFormat, IProgressMonitor progressMonitor) {
        Activator.safeLogInfo(NLS.bind((String)"Migrating RSSOwl (from version {0} to version {1}", (Object)workspaceFormat, (Object)currentFormat));
        ConfigurationFactory configFactory = new ConfigurationFactory(){

            public Configuration createConfiguration() {
                return DBManager.createConfiguration(false);
            }
        };
        Migration migration = new Migrations().getMigration(workspaceFormat, currentFormat);
        if (migration == null) {
            throw new PersistenceException("It was not possible to migrate your data to the current version of RSSOwl. Migrations are supported between final versions and between consecutive milestones. In other words, 2.0M7 to 2.0M8 and 2.0 to 2.1 are supported but 2.0M6 to 2.0M8 is not supported. In the latter case, you would need to launch 2.0M7 and then 2.0M8 to be able to use that version. Migration was attempted from originFormat: " + workspaceFormat + " to destinationFormat: " + currentFormat);
        }
        final File dbFile = new File(DBManager.getDBFilePath());
        BackupService backupService = new BackupService(dbFile, ".mig." + workspaceFormat, 1);
        backupService.setLayoutStrategy(new BackupService.BackupLayoutStrategy(){

            @Override
            public List<File> findBackupFiles() {
                ArrayList<File> backupFiles = new ArrayList<File>(3);
                int i = workspaceFormat;
                while (i >= 0) {
                    File file = new File(dbFile.getAbsoluteFile() + ".mig." + i);
                    if (file.exists()) {
                        backupFiles.add(file);
                    }
                    --i;
                }
                return backupFiles;
            }

            @Override
            public void rotateBackups(List<File> backupFiles) {
                throw new UnsupportedOperationException("No rotation supported because maxBackupCount is 1");
            }
        });
        backupService.backup(true, (IProgressMonitor)new NullProgressMonitor());
        File migDbFile = backupService.getTempBackupFile();
        DBHelper.copyFileNIO(dbFile, migDbFile);
        MigrationResult migrationResult = migration.migrate(configFactory, migDbFile.getAbsolutePath(), progressMonitor);
        File dbFormatFile = this.getDBFormatFile();
        File migFormatFile = new File(String.valueOf(dbFormatFile.getAbsolutePath()) + ".mig.temp");
        try {
            if (!migFormatFile.exists()) {
                migFormatFile.createNewFile();
            }
            if (!dbFormatFile.exists()) {
                dbFormatFile.createNewFile();
            }
        }
        catch (IOException ioe) {
            throw new PersistenceException("Failed to migrate data", ioe);
        }
        this.setFormatVersion(migFormatFile);
        DBHelper.rename(migFormatFile, dbFormatFile);
        DBHelper.rename(migDbFile, dbFile);
        if (this.getOldDBFormatFile().exists()) {
            this.getOldDBFormatFile().delete();
        }
        return migrationResult;
    }

    private File getOldDBFormatFile() {
        File dir = new File(Activator.getDefault().getStateLocation().toOSString());
        File formatFile = new File(dir, "format");
        return formatFile;
    }

    private int getWorkspaceFormatVersion() {
        boolean dbFileExists = new File(DBManager.getDBFilePath()).exists();
        File formatFile = this.getDBFormatFile();
        boolean formatFileExists = formatFile.exists();
        if (!formatFileExists && this.getOldDBFormatFile().exists()) {
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new FileReader(this.getOldDBFormatFile()));
                    String text = reader.readLine();
                    DBHelper.writeToFile(formatFile, text);
                    formatFileExists = true;
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            catch (Throwable throwable) {
                DBHelper.closeQuietly(reader);
                throw throwable;
            }
            DBHelper.closeQuietly(reader);
        }
        if (dbFileExists) {
            if (!formatFileExists) {
                return 0;
            }
            String versionText = DBHelper.readFirstLineFromFile(formatFile);
            try {
                int version = Integer.parseInt(versionText);
                return version;
            }
            catch (NumberFormatException e) {
                throw new PersistenceException("Format file does not contain a number as the version", e);
            }
        }
        if (!formatFileExists) {
            try {
                formatFile.createNewFile();
            }
            catch (IOException ioe) {
                throw new PersistenceException("Error creating database", ioe);
            }
        }
        this.setFormatVersion(formatFile);
        return this.getCurrentFormatVersion();
    }

    private void setFormatVersion(File formatFile) {
        DBHelper.writeToFile(formatFile, String.valueOf(this.getCurrentFormatVersion()));
    }

    private int getCurrentFormatVersion() {
        return 5;
    }

    private boolean defragmentIfNecessary(LongOperationMonitor progressMonitor, SubMonitor subMonitor) {
        boolean defragmentToLargeBlockSize = false;
        if (this.defragmentToLargerBlockSize()) {
            defragmentToLargeBlockSize = true;
            File defragmentFile = this.getDefragmentFile();
            if (defragmentFile.exists()) {
                defragmentFile.delete();
            }
        } else {
            File defragmentFile = this.getDefragmentFile();
            if (!defragmentFile.exists()) {
                return false;
            }
            if (!defragmentFile.delete()) {
                Activator.getDefault().logError("Failed to delete defragment file", null);
            }
        }
        this.defragment(defragmentToLargeBlockSize, progressMonitor, subMonitor);
        return true;
    }

    private boolean defragmentToLargerBlockSize() {
        long length;
        if (DBManager.getLargeBlockSizeMarkerFile().exists()) {
            return false;
        }
        File database = new File(DBManager.getDBFilePath());
        long l = length = database.exists() ? database.length() : 0L;
        return length > 0x60000000L;
    }

    private void defragment(boolean useLargeBlockSize, LongOperationMonitor progressMonitor, SubMonitor subMonitor) {
        SubMonitor monitor;
        if (subMonitor == null) {
            progressMonitor.beginLongOperation(true);
            String monitorText = Messages.DBManager_PROGRESS_WAIT;
            subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)monitorText, (int)10000000);
            monitor = subMonitor.newChild(10000000);
            monitor.beginTask(monitorText, 10000000);
        } else {
            monitor = subMonitor.newChild(10);
            monitor.setWorkRemaining(100);
        }
        Activator.safeLogInfo("Start: Database Defragmentation");
        BackupService backupService = this.createScheduledBackupService(null);
        File database = new File(DBManager.getDBFilePath());
        File defragmentedDatabase = new File(database.getParentFile(), TMP_BACKUP_NAME);
        if (defragmentedDatabase.exists() && !defragmentedDatabase.delete()) {
            throw new PersistenceException("Failed to delete file: " + defragmentedDatabase);
        }
        if (!useLargeBlockSize && monitor.isCanceled()) {
            Activator.safeLogInfo("Cancelled: Database Defragmentation");
            return;
        }
        monitor.subTask(Messages.DBManager_IMPROVING_APP_PERFORMANCE);
        DBManager.copyDatabase(database, defragmentedDatabase, useLargeBlockSize, (IProgressMonitor)monitor);
        if (!useLargeBlockSize && monitor.isCanceled()) {
            Activator.safeLogInfo("Cancelled: Database Defragmentation");
            defragmentedDatabase.delete();
            return;
        }
        monitor.subTask(Messages.DBManager_CREATING_DB_BACKUP);
        backupService.backup(true, (IProgressMonitor)monitor);
        if (!useLargeBlockSize && monitor.isCanceled()) {
            Activator.safeLogInfo("Cancelled: Database Defragmentation");
            defragmentedDatabase.delete();
            return;
        }
        DBHelper.rename(defragmentedDatabase, database);
        File largeBlockSizeMarkerFile = DBManager.getLargeBlockSizeMarkerFile();
        if (useLargeBlockSize && !largeBlockSizeMarkerFile.exists()) {
            try {
                if (!largeBlockSizeMarkerFile.createNewFile()) {
                    Activator.getDefault().logError("Failed to create large blocksize marker file", null);
                }
            }
            catch (IOException e) {
                Activator.getDefault().logError("Failed to create large blocksize marker file", e);
            }
        }
        monitor.done();
        Activator.safeLogInfo("Finished: Database Defragmentation");
    }

    public static final void copyDatabase(File source, File destination, boolean useLargeBlockSize, IProgressMonitor monitor) {
        ObjectContainer sourceDb = null;
        ObjectContainer destinationDb = null;
        try {
            sourceDb = Db4o.openFile((Configuration)DBManager.createConfiguration(true), (String)source.getAbsolutePath());
            Configuration destinationDbConfiguration = DBManager.createConfiguration(true);
            if (useLargeBlockSize) {
                destinationDbConfiguration.blockSize(8);
            }
            destinationDb = Db4o.openFile((Configuration)destinationDbConfiguration, (String)destination.getAbsolutePath());
            DBManager.internalCopyDatabase(sourceDb, destinationDb, useLargeBlockSize, monitor);
        }
        finally {
            if (sourceDb != null) {
                sourceDb.close();
            }
            if (destinationDb != null) {
                destinationDb.close();
            }
        }
    }

    public static final void internalCopyDatabase(ObjectContainer sourceDb, ObjectContainer destinationDb, boolean useLargeBlockSize, IProgressMonitor monitor) {
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        ArrayList<Label> labels = new ArrayList<Label>();
        ObjectSet allLabels = sourceDb.query(Label.class);
        int available = 100000;
        if (!allLabels.isEmpty()) {
            int chunk = available / allLabels.size();
            for (Label label : allLabels) {
                if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
                    return;
                }
                labels.add(label);
                sourceDb.activate((Object)label, Integer.MAX_VALUE);
                destinationDb.ext().set((Object)label, Integer.MAX_VALUE);
                monitor.worked(chunk);
            }
            allLabels = null;
        } else {
            monitor.worked(available);
        }
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        ObjectSet allFolders = sourceDb.query(Folder.class);
        available = 500000;
        if (!allFolders.isEmpty()) {
            int chunk = available / allFolders.size();
            for (Folder type : allFolders) {
                if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
                    return;
                }
                sourceDb.activate((Object)type, Integer.MAX_VALUE);
                if (type.getParent() == null) {
                    destinationDb.ext().set((Object)type, Integer.MAX_VALUE);
                }
                monitor.worked(chunk);
            }
            allFolders = null;
        } else {
            monitor.worked(available);
        }
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        ObjectSet allBins = destinationDb.query(NewsBin.class);
        available = 1000000;
        if (!allBins.isEmpty()) {
            int chunk = available / allBins.size();
            for (NewsBin newsBin : allBins) {
                if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
                    return;
                }
                destinationDb.activate((Object)newsBin, Integer.MAX_VALUE);
                ArrayList<NewsReference> staleNewsRefs = new ArrayList<NewsReference>(0);
                for (NewsReference newsRef : newsBin.getNewsRefs()) {
                    if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
                        return;
                    }
                    Query query = sourceDb.query();
                    query.constrain(News.class);
                    query.descend("fId").constrain((Object)newsRef.getId());
                    Iterator newsIt = query.execute().iterator();
                    if (!newsIt.hasNext()) {
                        Activator.getDefault().logError("NewsBin " + newsBin + " has reference to news with id: " + newsRef.getId() + ", but that news does not exist.", null);
                        staleNewsRefs.add(newsRef);
                        continue;
                    }
                    Object news = newsIt.next();
                    sourceDb.activate(news, Integer.MAX_VALUE);
                    destinationDb.ext().set(news, Integer.MAX_VALUE);
                }
                if (!staleNewsRefs.isEmpty()) {
                    if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
                        return;
                    }
                    newsBin.removeNewsRefs(staleNewsRefs);
                    destinationDb.ext().set((Object)newsBin, Integer.MAX_VALUE);
                }
                monitor.worked(chunk);
            }
            allBins = null;
        } else {
            monitor.worked(available);
        }
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        available = 3000000;
        int feedCounter = 0;
        NewsCounter newsCounter = new NewsCounter();
        ObjectSet allFeeds = sourceDb.query(Feed.class);
        if (!allFeeds.isEmpty()) {
            int allFeedsSize = allFeeds.size();
            int chunk = available / allFeedsSize;
            int i = 1;
            for (Feed feed : allFeeds) {
                if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
                    return;
                }
                monitor.subTask(NLS.bind((String)Messages.DBManager_OPTIMIZING_NEWSFEEDS, (Object)i, (Object)allFeedsSize));
                ++i;
                sourceDb.activate((Object)feed, Integer.MAX_VALUE);
                DBManager.addNewsCounterItem(newsCounter, feed);
                destinationDb.ext().set((Object)feed, Integer.MAX_VALUE);
                if (++feedCounter % 40 == 0) {
                    destinationDb.commit();
                    System.gc();
                }
                monitor.worked(chunk);
            }
            allFeeds = null;
            destinationDb.commit();
            System.gc();
        } else {
            monitor.worked(available);
        }
        monitor.subTask(Messages.DBManager_IMPROVING_APP_PERFORMANCE);
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        destinationDb.ext().set((Object)newsCounter, Integer.MAX_VALUE);
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        available = 3000000;
        int descriptionCounter = 0;
        ObjectSet allDescriptions = sourceDb.query(Description.class);
        if (!allDescriptions.isEmpty()) {
            int chunk = Math.max(1, available / allDescriptions.size());
            for (Description description : allDescriptions) {
                if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
                    return;
                }
                sourceDb.activate((Object)description, Integer.MAX_VALUE);
                destinationDb.ext().set((Object)description, Integer.MAX_VALUE);
                if (++descriptionCounter % 600 == 0) {
                    destinationDb.commit();
                    System.gc();
                }
                monitor.worked(chunk);
            }
            allDescriptions = null;
            destinationDb.commit();
            System.gc();
        } else {
            monitor.worked(available);
        }
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        available = 100000;
        ObjectSet allPreferences = sourceDb.query(Preference.class);
        if (!allPreferences.isEmpty()) {
            int chunk = available / allPreferences.size();
            for (Preference pref : allPreferences) {
                if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
                    return;
                }
                sourceDb.activate((Object)pref, Integer.MAX_VALUE);
                destinationDb.ext().set((Object)pref, Integer.MAX_VALUE);
                monitor.worked(chunk);
            }
            allPreferences = null;
        } else {
            monitor.worked(available);
        }
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        available = 100000;
        ObjectSet allFilters = sourceDb.query(SearchFilter.class);
        if (!allFilters.isEmpty()) {
            int chunk = available / allFilters.size();
            for (ISearchFilter filter : allFilters) {
                if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
                    return;
                }
                sourceDb.activate((Object)filter, Integer.MAX_VALUE);
                destinationDb.ext().set((Object)filter, Integer.MAX_VALUE);
                monitor.worked(chunk);
            }
            allFilters = null;
        } else {
            monitor.worked(available);
        }
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        ObjectSet counterSet = sourceDb.query(Counter.class);
        Counter counter = (Counter)counterSet.iterator().next();
        sourceDb.activate((Object)counter, Integer.MAX_VALUE);
        destinationDb.ext().set((Object)counter, Integer.MAX_VALUE);
        monitor.worked(100000);
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        EntityIdsByEventType entityIdsByEventType = (EntityIdsByEventType)sourceDb.query(EntityIdsByEventType.class).iterator().next();
        sourceDb.activate((Object)entityIdsByEventType, Integer.MAX_VALUE);
        destinationDb.ext().set((Object)entityIdsByEventType, Integer.MAX_VALUE);
        monitor.worked(100000);
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        available = 100000;
        ObjectSet allConditionalGets = sourceDb.query(ConditionalGet.class);
        if (!allConditionalGets.isEmpty()) {
            int chunk = available / allConditionalGets.size();
            for (ConditionalGet conditionalGet : allConditionalGets) {
                if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
                    return;
                }
                sourceDb.activate((Object)conditionalGet, Integer.MAX_VALUE);
                destinationDb.ext().set((Object)conditionalGet, Integer.MAX_VALUE);
                monitor.worked(chunk);
            }
            allConditionalGets = null;
        } else {
            monitor.worked(available);
        }
        if (DBManager.isCanceled(monitor, useLargeBlockSize, sourceDb, destinationDb)) {
            return;
        }
        sourceDb.close();
        monitor.worked(100000);
        if (monitor.isCanceled()) {
            destinationDb.close();
            return;
        }
        destinationDb.commit();
        monitor.worked(300000);
        if (monitor.isCanceled()) {
            destinationDb.close();
            return;
        }
        destinationDb.close();
        monitor.worked(100000);
        if (monitor.isCanceled()) {
            return;
        }
        System.gc();
        monitor.worked(100000);
    }

    private static boolean isCanceled(IProgressMonitor monitor, boolean useLargeBlockSize, ObjectContainer source, ObjectContainer dest) {
        if (monitor.isCanceled()) {
            if (useLargeBlockSize) {
                monitor.setTaskName(Messages.DBManager_WAIT_TASK_COMPLETION);
                return false;
            }
            source.close();
            dest.close();
            return true;
        }
        return false;
    }

    private static void addNewsCounterItem(NewsCounter newsCounter, Feed feed) {
        Map<INews.State, Integer> stateToCountMap = feed.getNewsCount();
        int unreadCount = DBManager.getCount(stateToCountMap, EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED));
        Integer newCount = stateToCountMap.get((Object)INews.State.NEW);
        newsCounter.put(feed.getLink().toString(), new NewsCounterItem(newCount, unreadCount, feed.getStickyCount()));
    }

    private static int getCount(Map<INews.State, Integer> stateToCountMap, Set<INews.State> states) {
        int count = 0;
        for (INews.State state : states) {
            count += stateToCountMap.get((Object)state).intValue();
        }
        return count;
    }

    public static final Configuration createConfiguration(boolean forDefrag) {
        Configuration config = Db4o.newConfiguration();
        if (DBManager.getLargeBlockSizeMarkerFile().exists()) {
            config.blockSize(8);
        }
        config.setOut(new PrintStream(new ByteArrayOutputStream()){

            public void write(byte[] buf, int off, int len) {
                if (buf != null && len >= 0 && off >= 0 && off <= buf.length - len) {
                    CoreUtils.appendLogMessage(new String(buf, off, len));
                }
            }
        });
        config.lockDatabaseFile(true);
        config.queries().evaluationMode(forDefrag ? QueryEvaluationMode.LAZY : QueryEvaluationMode.IMMEDIATE);
        config.automaticShutDown(false);
        config.callbacks(false);
        config.activationDepth(2);
        config.flushFileBuffers(false);
        config.callConstructors(true);
        config.exceptionsOnNotStorable(true);
        DBManager.configureAbstractEntity(config);
        config.objectClass(BookMark.class).objectField("fFeedLink").indexed(true);
        config.objectClass(ConditionalGet.class).objectField("fLink").indexed(true);
        DBManager.configureFeed(config);
        DBManager.configureNews(config);
        DBManager.configureFolder(config);
        config.objectClass(Description.class).objectField("fNewsId").indexed(true);
        config.objectClass(NewsCounter.class).cascadeOnDelete(true);
        config.objectClass(Preference.class).cascadeOnDelete(true);
        config.objectClass(Preference.class).objectField("fKey").indexed(true);
        config.objectClass(SearchFilter.class).objectField("fActions").cascadeOnDelete(true);
        if (DBManager.isIBM_VM_1_6()) {
            config.objectClass((Object)"java.util.MiniEnumSet").translate((ObjectTranslator)new TSerializable());
        }
        return config;
    }

    private static boolean isIBM_VM_1_6() {
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        return javaVendor != null && javaVendor.contains("IBM") && javaVersion != null && javaVersion.contains("1.6");
    }

    private static void configureAbstractEntity(Configuration config) {
        ObjectClass abstractEntityClass = config.objectClass(AbstractEntity.class);
        ObjectField idField = abstractEntityClass.objectField("fId");
        idField.indexed(true);
        idField.cascadeOnActivate(true);
        abstractEntityClass.objectField("fProperties").cascadeOnUpdate(true);
    }

    private static void configureFolder(Configuration config) {
        ObjectClass oc = config.objectClass(Folder.class);
        oc.objectField("fChildren").cascadeOnUpdate(true);
    }

    private static void configureNews(Configuration config) {
        ObjectClass oc = config.objectClass(News.class);
        oc.objectField("fParentId").indexed(true);
        oc.objectField("fFeedLink").indexed(true);
        oc.objectField("fStateOrdinal").indexed(true);
    }

    private static void configureFeed(Configuration config) {
        ObjectClass oc = config.objectClass(Feed.class);
        ObjectField linkText = oc.objectField("fLinkText");
        linkText.indexed(true);
        linkText.cascadeOnActivate(true);
        oc.objectField("fTitle").cascadeOnActivate(true);
    }

    public void shutdown() throws PersistenceException {
        this.fLock.writeLock().lock();
        try {
            this.fireDatabaseEvent(new DatabaseEvent(this.fObjectContainer, this.fLock), false);
            if (this.fObjectContainer != null) {
                while (!this.fObjectContainer.close()) {
                }
            }
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public final ObjectContainer getObjectContainer() {
        return this.fObjectContainer;
    }

    Pair<File, Long> getProfile() {
        File profile = new File(DBManager.getDBFilePath());
        Long timestamp = this.getProfileLastUsed();
        return Pair.create(profile, timestamp);
    }

    List<File> getProfileBackups() {
        File offlineBackupOlder;
        File offlineBackup;
        File onlineDailyBackupOlder;
        File onlineDailyBackup;
        ArrayList<File> backups = new ArrayList<File>();
        File backupDir = new File(Activator.getDefault().getStateLocation().toOSString());
        File onlineWeeklyBackup = new File(backupDir, "rssowl.db.onlinebak.weekly");
        if (onlineWeeklyBackup.exists()) {
            backups.add(onlineWeeklyBackup);
        }
        if ((onlineDailyBackup = new File(backupDir, "rssowl.db.onlinebak")).exists()) {
            backups.add(onlineDailyBackup);
        }
        if ((onlineDailyBackupOlder = new File(backupDir, "rssowl.db.onlinebak.0")).exists()) {
            backups.add(onlineDailyBackupOlder);
        }
        if ((offlineBackup = new File(backupDir, "rssowl.db.backup")).exists()) {
            backups.add(offlineBackup);
        }
        if ((offlineBackupOlder = new File(backupDir, "rssowl.db.backup.0")).exists()) {
            backups.add(offlineBackupOlder);
        }
        Collections.sort(backups, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.lastModified() > f2.lastModified() ? -1 : 1;
            }
        });
        return backups;
    }

    void restoreProfile(File backup) throws PersistenceException {
        Activator.safeLogInfo(NLS.bind((String)"Start: Database Restore from Backup ({0})", (Object)backup.getName()));
        File db = new File(DBManager.getDBRestoreFilePath());
        DBHelper.rename(backup, db);
        try {
            File largeBlockSizeMarkerFile = DBManager.getLargeBlockSizeMarkerFile();
            if (largeBlockSizeMarkerFile.exists() && db.length() < 0x60000000L) {
                largeBlockSizeMarkerFile.delete();
            } else if (!largeBlockSizeMarkerFile.exists() && db.length() > 0x60000000L) {
                largeBlockSizeMarkerFile.createNewFile();
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        Activator.safeLogInfo("End: Database Restore from Backup");
    }

    private void backupAndDeleteProfile() {
        File db = new File(DBManager.getDBFilePath());
        if (db.exists()) {
            Activator.safeLogInfo("Start: Backup and Delete Profile");
            if (InternalOwl.TESTING) {
                this.shutdown();
            }
            int i = 0;
            File backupDir = new File(Activator.getDefault().getStateLocation().toOSString());
            File backupCandidate = new File(backupDir, "rssowl.db.restorebak");
            while (backupCandidate.exists()) {
                backupCandidate = new File(backupDir, "rssowl.db.restorebak." + i++);
            }
            DBHelper.rename(db, backupCandidate);
            Activator.safeLogInfo(NLS.bind((String)"End: Backup and Delete Profile ({0})", (Object)backupCandidate.getName()));
        }
    }

    void dropDatabaseForTests() throws PersistenceException {
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                DBManager.this.shutdown();
                File dbFile = new File(DBManager.getDBFilePath());
                if (dbFile.exists() && !dbFile.delete()) {
                    Activator.getDefault().logError("Failed to delete db file", null);
                }
                DBManager.this.delete(new File[]{DBManager.this.getDBFormatFile(), DBManager.this.getDefragmentFile(), DBManager.this.getReIndexFile(), DBManager.this.getCleanUpIndexFile()});
            }
        });
    }

    private void delete(File ... files) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                file.delete();
            }
            ++n2;
        }
    }
}

