/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.event.ModelEvent;
import org.rssowl.core.persist.event.runnable.EventRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsMap {
    private static final EventsMap INSTANCE = new EventsMap();
    private final ThreadLocal<InternalMap> fEvents = new ThreadLocal();
    private final ThreadLocal<Map<IEntity, ModelEvent>> fEventTemplatesMap = new ThreadLocal();

    private EventsMap() {
    }

    public static final EventsMap getInstance() {
        return INSTANCE;
    }

    public final void putPersistEvent(ModelEvent event) {
        EventRunnable<? extends ModelEvent> eventRunnable = this.getEventRunnable(event);
        eventRunnable.addCheckedPersistEvent(event);
    }

    public final void putUpdateEvent(ModelEvent event) {
        EventRunnable<? extends ModelEvent> eventRunnable = this.getEventRunnable(event);
        eventRunnable.addCheckedUpdateEvent(event);
    }

    public final void putRemoveEvent(ModelEvent event) {
        EventRunnable<? extends ModelEvent> eventRunnable = this.getEventRunnable(event);
        eventRunnable.addCheckedRemoveEvent(event);
    }

    public final boolean containsPersistEvent(Class<? extends ModelEvent> eventClass, IEntity entity) {
        EventRunnable<? extends ModelEvent> eventRunnable = this.getEventRunnable(eventClass);
        return eventRunnable.getPersistEvents().contains(entity);
    }

    public final boolean containsUpdateEvent(Class<? extends ModelEvent> eventClass, IEntity entity) {
        EventRunnable<? extends ModelEvent> eventRunnable = this.getEventRunnable(eventClass);
        return eventRunnable.getUpdateEvents().contains(entity);
    }

    public final boolean containsRemoveEvent(Class<? extends ModelEvent> eventClass, IEntity entity) {
        EventRunnable<? extends ModelEvent> eventRunnable = this.getEventRunnable(eventClass);
        return eventRunnable.getRemoveEvents().contains(entity);
    }

    private EventRunnable<? extends ModelEvent> getEventRunnable(Class<? extends ModelEvent> eventClass) {
        InternalMap map = this.fEvents.get();
        if (map == null) {
            map = new InternalMap();
            this.fEvents.set(map);
        }
        EventRunnable eventRunnable = (EventRunnable)map.get(eventClass);
        return eventRunnable;
    }

    private EventRunnable<? extends ModelEvent> getEventRunnable(ModelEvent event) {
        Class<?> eventClass = event.getClass();
        EventRunnable<? extends ModelEvent> eventRunnable = this.getEventRunnable(eventClass);
        if (eventRunnable == null) {
            eventRunnable = event.createEventRunnable();
            this.fEvents.get().put(eventClass, eventRunnable);
        }
        return eventRunnable;
    }

    public EventRunnable<? extends ModelEvent> removeEventRunnable(Class<? extends ModelEvent> klass) {
        InternalMap map = this.fEvents.get();
        if (map == null) {
            return null;
        }
        EventRunnable runnable = (EventRunnable)map.remove(klass);
        return runnable;
    }

    public List<EventRunnable<?>> getEventRunnables() {
        InternalMap map = this.fEvents.get();
        if (map == null) {
            return new ArrayList(0);
        }
        ArrayList eventRunnables = new ArrayList(map.size());
        for (Map.Entry entry : map.entrySet()) {
            eventRunnables.add((EventRunnable)entry.getValue());
        }
        return eventRunnables;
    }

    public List<EventRunnable<?>> removeEventRunnables() {
        InternalMap map = this.fEvents.get();
        if (map == null) {
            return new ArrayList(0);
        }
        List<EventRunnable<?>> eventRunnables = this.getEventRunnables();
        map.clear();
        return eventRunnables;
    }

    public void putEventTemplate(ModelEvent event) {
        Map<IEntity, ModelEvent> map = this.fEventTemplatesMap.get();
        if (map == null) {
            map = new IdentityHashMap<IEntity, ModelEvent>();
            this.fEventTemplatesMap.set(map);
        }
        map.put(event.getEntity(), event);
    }

    public final Map<IEntity, ModelEvent> getEventTemplatesMap() {
        Map<IEntity, ModelEvent> map = this.fEventTemplatesMap.get();
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.fEventTemplatesMap.get());
    }

    public Map<IEntity, ModelEvent> removeEventTemplatesMap() {
        Map<IEntity, ModelEvent> map = this.fEventTemplatesMap.get();
        this.fEventTemplatesMap.remove();
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalMap
    extends HashMap<Class<? extends ModelEvent>, EventRunnable<? extends ModelEvent>> {
        InternalMap() {
        }
    }
}

