/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.util.StringMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandingReader
extends Reader {
    private final StringBuilder fPushed = new StringBuilder();
    private final StringBuilder fBuf = new StringBuilder();
    private final Reader fIn;
    private final Collection<StringMatcher> fStringMatcher;
    private final String fPreExpand;
    private final String fPostExpand;
    private final boolean fSkipTags;
    private int fPushbackOffset;
    private boolean fInTags;

    public ExpandingReader(Reader in, Collection<String> words, String preValue, String postValue, boolean skipTags) {
        Assert.isNotNull((Object)in);
        Assert.isNotNull(words);
        Assert.isNotNull((Object)preValue);
        Assert.isNotNull((Object)postValue);
        this.fIn = in;
        this.fPreExpand = preValue;
        this.fPostExpand = postValue;
        this.fSkipTags = skipTags;
        this.fStringMatcher = new ArrayList<StringMatcher>(words.size());
        for (String word : words) {
            this.fStringMatcher.add(new StringMatcher(word, true, false));
        }
    }

    @Override
    public int read() throws IOException {
        int ch = this.next();
        if (this.fPushbackOffset != 0) {
            return ch;
        }
        if (this.fSkipTags && ch == 60) {
            this.fInTags = true;
        } else if (this.fSkipTags && ch == 62) {
            this.fInTags = false;
        }
        if (this.fSkipTags && (this.fInTags || ch == 62)) {
            return ch;
        }
        while (true) {
            if (ch == -1 || this.isWordTerminator(ch)) {
                String result = this.fBuf.toString();
                if (result.length() > 0 && this.shouldExpand(result)) {
                    result = this.expand(result);
                }
                this.fPushed.append(result);
                if (ch != -1) {
                    this.fPushed.append((char)ch);
                    if (this.fSkipTags && ch == 60) {
                        this.fInTags = true;
                    } else if (this.fSkipTags && ch == 62) {
                        this.fInTags = false;
                    }
                }
                this.fBuf.setLength(0);
                return this.next();
            }
            this.fBuf.append((char)ch);
            ch = this.fIn.read();
        }
    }

    private boolean isWordTerminator(int c) {
        return !Character.isLetterOrDigit(c);
    }

    private boolean shouldExpand(String word) {
        for (StringMatcher matcher : this.fStringMatcher) {
            if (!matcher.match(word)) continue;
            return true;
        }
        return false;
    }

    private String expand(String word) {
        return String.valueOf(this.fPreExpand) + word + this.fPostExpand;
    }

    private int next() throws IOException {
        int len = this.fPushed.length();
        if (this.fPushbackOffset < len) {
            char ch = this.fPushed.charAt(this.fPushbackOffset);
            ++this.fPushbackOffset;
            return ch;
        }
        if (this.fPushbackOffset != 0) {
            this.fPushbackOffset = 0;
            this.fPushed.setLength(0);
        }
        return this.fIn.read();
    }

    @Override
    public void close() throws IOException {
        this.fIn.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = 0;
        i = 0;
        while (i < len) {
            int ch = this.read();
            if (ch == -1) break;
            cbuf[off++] = (char)ch;
            ++i;
        }
        if (i == 0) {
            if (len == 0) {
                return 0;
            }
            return -1;
        }
        return i;
    }
}

